package Cmds::BroadMatch;

use utf8;
use base qw(Cmds::Base);


sub rights :CMD {
    my ($proj, $vars) = @_;
    $proj->dd($proj->user->rights);
}

sub rightslist :CMD {
    my ($proj, $vars) = @_;
    $proj->dd($proj->user_states->states->get_states_hash);
}

sub rightslisth :CMDH {
    my ($proj, $vars) = @_;
    return {
        title => 'Система прав',
        readonly => 1,
        getlistflt => sub {
            my $rts = $proj->user_states->states->get_states_hash;
            my @res = ();
            for my $st (keys %$rts){
                push(@res, map {{ state => $st, right => $_, }} keys %{ $rts->{$st} });
            }
            @res = sort { $a->{state} cmp $b->{state} || $a->{right} cmp $b->{right} } grep { $_->{right} =~ /right_/ } @res;
            return \@res;
        },
        default_field_params => { shlist => 1, },
        fields => [
            { name => 'state', },
            { name => 'right', },
        ],     
    };
}

sub users :CMDH {
    my ($proj, $vars) = @_;
    return {
        readonly => 1,
        title => 'Список пользователей',
        table => 'Users',
        default_field_params => { shlist => 1, },
        fields => [
            { name => 'uid', },
            { name => 'Login', },
            { name => 'NumVisits', },
            { name => 'LastVisit', },
            { name => 'state', },
            { name => 'role', },
            { title => 'Права на кампании', grp => [
                { name => 'DirectCampaignsDate', },
                { name => 'DirectCampaignsJSON', },
            ]},
            { name => 'EMail', },
        ],
        filters => [
               { name => 'Login', field => 'Login', },
               { name => 'Роль', field => 'role', grp=>1, },
        ],
        pager => { name => 'p', cc => 20, },
    }; 
}

sub usersstat :CMDH {
    my ($proj, $vars) = @_;

    return {
        readonly => 1,
        title => 'Статистика посещения catmedia',
        default_field_params => { shlist => 1, },
        fields => [
            { name => 'date', inlinefilter => {}, },
        ],
        wwwfilters => [
            { name => 'date', field => 'date', },
        ],
        stat_fields => [ qw{ hits users }, ],
        getlistflt => sub {
            my ($self, %prm) = @_;
            my $lst =  $self->proj->List_SQL("select LEFT(UpdateTime, 10) date, count(*) hits, count(distinct Login) users from UsersVisitsLog group by date order by date desc");
            return $lst;
        },
        wwwcharts => {
            date_field => 'date',
            list => [
                {
                    dtvalue => 'hits',
                    type    => 'simple_line_inf',
                },
                {
                    dtvalue => 'users',
                    type    => 'simple_line',
                },
            ],
        },
        pager => { name => 'p', cc => 20, },
    };
}

1;

