package Cmds::VideoDirectGroups;

use utf8;

use base qw(Cmds::Base);
use Encode;
use List::Util qw(min);
use Text::Iconv;
use Data::Dumper;
use URI::Escape;
use Utils::Sys qw(format_number h2sa);
use Time::HiRes qw(gettimeofday tv_interval);
use Utils::Sys qw(md5int);
use Utils::XLS qw(array2xls array2xlsx xls2array xlsx2array xls_edit_line xls_lines_list);

my $exclude_groups = {
    'НЕ РАСПРЕДЕЛЕНО' => 1,
    'UNKNOWN'         => 1,
};

our $videodirectgroups_table_name = 'categs_videodirectgroups';

sub del_virt_pref { my $t = $_[0]; $t =~ s/^.+ _ //g; return $t }

sub videodirectgroups :CMDH {
    my ($proj, $vars) = @_;
    return {
        title => 'Группы категорий для видеоподложек',
        table => 'categs_videodirectgroups',
        readonly => 1,
        idfield => 'ID',
        debug => 0,
        rights => 'right_edit_videodirectgroups',
        #compact_inline_add => 1,
        fix_sql_problem => 0,
        logchanges => 1,
        #group_by => 'Category',
        delonly => 1,
        default_field_params => { shlist => 1, },
        group_by_add_fields => [ "max(UpdateTime) MaxUpdateTime" ],
        action_onlist => sub { 
            my ($proj, $el) = @_;
            my $lst = $proj->List_SQL('select distinct level2
                                       from videodirectgroups_second_level
                                       where videodirectgroup = ?', 
                                       [$el->{videodirectgroup}]);
            $el->{'level2'} = join '/', grep {!exists $exclude_groups->{$_}} map {$_->{level2}} @{$lst};
        },
        fields => [
            { name => 'videodirectgroup', title => 'Группа категорий', edlist => 1, dbtype => "varchar(255) DEFAULT ''", inlinefilter => {}, }, 
            { name => 'UpdateTime', dbtype => 'timestamp', shlist => 0, autoedit => sub { $proj->dates->cur_date('db_time') }, },
            { extname => 'MaxUpdateTime', dbtype => 'timestamp', title => 'UpdateTime', autoedit => sub { $proj->dates->cur_date('db_time') }, inlinefilter => {}, },
            { name => 'virt', title => 'Виртуальные категорий', edlist => 1, shlist => 0, dbtype => "varchar(255) DEFAULT ''",
                  autoedit => sub { my ($proj, $h) = @_; return $h->{ categ } =~ / _ / ? 'yes' : 'no' }, 
            },
            { extname => 'level2', title => 'Второй уровень', },
            { extsql => ['select videodirectgroup, count(*) cc from categs_videodirectgroups where videodirectgroup in (?) group by videodirectgroup', 'videodirectgroup'],
              extname => 'cc',
            },
            { name => 'categ', title => 'Категория', shlist => 0, wmanual_category => 1, edlist => 1, addform => 1, dbtype => "varchar(255) DEFAULT ''", },
            #{ name => 'UserState', show_good_bad => 1, dbtype => "varchar(255) DEFAULT ''", ftype=>'hidden', disable_add => '1', addform => 0, },
        ],
        filters => [
               { field => 'videodirectgroup',  name => 'Группа категорий', use_other_filters => 1, like => 1, },
               { field => 'virt', name => 'Виртуальные', grp => 1, selectnames => { 'yes' => 'виртуальные', 'no' => 'не виртульные' }, },
        ],
        group_by => 'videodirectgroup',
        default_filter => { virt => 'no', },
        extlists => [
            { cmd => 'videodirectgroups_categs', act => 'AddForm', using => '', addelemparams => { 'videodirectgroup' => 'videodirectgroup', }, },
            { cmd => 'videodirectgroups_categs', using => '', addelemparams => { 'videodirectgroup' => 'videodirectgroup', }, addfilterparams => { 'flt_virt' => 'virt', } },
        ],
        pager => { name => 'p', cc => 50, },
        topmenu => [
            { title => 'Данные', sublist => [
                { 
                      title => 'Залить новый маппинг', name => 'newmapping',
                      filefield => 'mappingfile',
                      action => sub {
                          my ($self, $lst1, $lst2, $prmsh) = @_;
                          my $proj = $self->proj;
                          #my $h = { MediaGroup => $prmsh->{NewGroup} };
                          #my @arr = map { [  $_, $h ] } split ',', $lst1;
                          ##$self->dtact_multiedit(\@arr);
                          ##$proj->dd('FFFF');
                          ##$proj->dd($proj->form, $prmsh->{'mappingfile_filename'});
                          #$proj->dd($prmsh->{'mappingfile_filename'});
                          ##print '['.$prmsh->{'mappingfile'}.']';
                          ##$proj->dd($proj->xls2arr($prmsh->{'mappingfile'}, $prmsh->{'mappingfile_filename'}));
                    
                          my $data = $proj->xls2arr($prmsh->{'mappingfile'}, $prmsh->{'mappingfile_filename'});
                    
                          return unless $data && (@{$data->[0]} > 0);
                    
                          $data = $data->[0]; #берем данные только с первой страницы 
                    
                          #my %mpg = map { $_->[0] => $_->[1] } map  { [ split( "\t", $_) ] } grep { !/Article/ } @$data;
                          #У одной категории может быть несколько медиагрупп
                          my %mpg = ();
                          push( @{$mpg{ $_->[0] } ||= []}, $_->[1] ) for map  { [ split( "\t", $_) ] } grep { !/Article/ } @$data;
                    
                          #$proj->dd(\%mpg);
                    
                          my @arr = map { { categ => $_, videodirectgroup => ($mpg{ $_ } || $mpg{ del_virt_pref($_) } || ['UNKNOWN']), virt => ( / _ / ? 'yes' : 'no' ), } } 
                              grep {! /^\./}
                              map { $_->{'CategoryName'} } 
                              @{ $proj->categories_dict->List( {Language => 'ru', }, ['CategoryName'] )};
                    
                          #Раскрываем массивы медиагрупп в плоский список
                          my @narr = ();
                          for my $pr (@arr){
                              for my $mg (@{$pr->{videodirectgroup}}){
                                  my %h = %$pr;
                                  $h{videodirectgroup} = $mg;
                                  push(@narr, \%h); 
                              }
                          }
                          @arr = @narr;
                    
                          #$proj->dd(\@arr);
                          #return;
                    
                          if(@arr > 1000){
                              $proj->Do_SQL('CREATE TABLE IF NOT EXISTS categs_videodirectgroups_old_data LIKE categs_videodirectgroups');
                              $proj->Do_SQL('INSERT INTO categs_videodirectgroups_old_data SELECT * FROM categs_videodirectgroups');
                              $proj->Do_SQL('DELETE FROM categs_videodirectgroups');
                              $proj->dbtable('categs_videodirectgroups')->Add(\@arr);
                          }
                          #$proj->dd('FFF'. @$data);
                    
                      },
                },
                { title => 'Выгрузить соответствие в XLS', url => '?cmd=videodirectgroups_xls', },
                { title => 'Список категорий с группами', url => '?cmd=videodirectgroups_categsinf', },
                { title => 'Подавление категорий', url => '?cmd=videodirectgroups_fix', },
            ] },
        ],
    };
}


sub videodirectgroups_r :CMDH {
    my ($proj, $vars) = @_;
    my $hh = videodirectgroups($proj, $vars);
    #delete($hh->{$_}) for qw(topmenu);
    delete($hh->{$_}) for qw(rights);
    $hh->{topmenu} = [
            { title => 'Данные', sublist => [
                { title => 'Выгрузить соответствие в XLS', url => '?cmd=videodirectgroups_xls', },
                { title => 'Список категорий с группами', url => '?cmd=videodirectgroups_categsinf_r', },
            ] },
    ];
    $hh->{extlists}[0]{cmd} = 'videodirectgroups_categs_r';
    return $hh;
}

sub videodirectgroups_categs :CMDH {
    #my ($proj, $vars) = @_;
    #$proj->dd($proj->form);
    return {
        table => 'categs_videodirectgroups',
        readonly => 1,
        rights => 'right_edit_videodirectgroups',
        idfield => 'ID',
        debug => 0,
        save_button => { title => 'Добавить категорию', right => 1, },
        #fix_sql_problem => 1,
        #group_by => 'Category',
        show_del => 1,
        delonly => 1,
        compact_inline_add => 1,
        default_field_params => { shlist => 1, },
        order_by => "SUBSTRING_INDEX(categ, ' _ ', -1), LENGTH(categ)",
        logchanges => 1,
#        show_sublist_inline_add => 1,
        fields => [
            #{ name => 'ID', }, 
            #{ name => 'UserState', show_good_bad => 1, ftype=>'hidden', disable_add => '1', addform => 1, },
            { name => 'videodirectgroup', addform => 1, shlist => 0, ftype=>'hidden', }, 
            { name => 'categ', title => 'Категория', edlist => 1, showmacro => 'catname2link', ftype => 'typeahead', 
                  typeahead => sub {
                      my ($proj, $text) = @_;
                      my $list = $proj->search_categs($text);
                      return [ map { $_->{'CategoryName'} } @$list ];
                  },
            }, 
            { name => 'virt', addform => 1,  title => 'Виртуальные категорий', edlist => 1, shlist => 0, dbtype => "varchar(255) DEFAULT ''",
                  autoedit => sub { my ($proj, $h) = @_; return $h->{ categ } =~ / _ / ? 'yes' : 'no' }, 
            }, 
            #{ title => 'EEEEE', extname => 'sss', shlist => 1, showmacroel => 'show_list_inline_checkbox', }, 
            #{ name => 'categ', manual_category => 1, },
        ],
        filters => [
               { field => 'virt', name => 'virt', },
        ],
        default_filter => { virt => '     ', },
        select_elems => { binary => 0, right => 0, },

#        bottom_actions => [
#            { title => 'Перенести категории', name => 'movecategs', action => sub {
#                    my ($self, $lst1, $lst2, $prmsh) = @_;
#                    my @ids = split ',', $lst1;
#                    if(@ids){
#                        $self->proj->dbtable('categs_videodirectgroups', 'ID')->Edit( \@ids, { videodirectgroup => $prmsh->{'Name'} } );
#                    }
#                },
#                inline => 1,
#                fields => [
#                    { name => "Name", title => 'Группа', edlist => 1, typeaheadfield => 'videodirectgroup', },
#                ],
#                confirm => 'Вы действительно хотите перенести категории?',
#            },
#        ],

        #select_elems => { buttons => {},  right => 1, },
        add_filter => { 'categ !=' => '' },
        #default_filter => { UserState => '', },
        pager => { name => 'p', cc => 20, },
    };
}

sub videodirectgroups_categs_r :CMDH {
    my ($proj, $vars) = @_;
    my $hh = videodirectgroups_categs($proj, $vars);
    delete($hh->{$_}) for qw(bottom_actions show_del delonly compact_inline_add select_elems rights);
    return $hh;
}

sub videodirectgroups_xls :CMD {
    my ($proj, $vars) = @_;

    my $list = $proj->List_SQL("select categ, videodirectgroup from categs_videodirectgroups order by videodirectgroup, categ");
    $list = [ map {[ $_->{categ}, $_->{videodirectgroup} ]} @$list ];
    
    $vars->{'_return_real_xls'} = 'd_catalogia_videodirectgroups_mapping_'.$proj->dates->cur_date('db').'.xls';
    $vars->{text} = array2xls($list); 
}

sub videodirectgroups_categsinf :CMDH {
    return {
        table => 'categs_videodirectgroups',
        title => 'Соответствие категорий и групп',
        rights => 'right_edit_videodirectgroups',
        readonly => 1,
        idfield => 'ID',
        order_by => "SUBSTRING_INDEX(categ, ' _ ', -1), LENGTH(categ)",
        logchanges => 1,
        default_inlinefilter_params => {
            group_by_add_fields => ['count(*) tt', ],
            fields => [
                { name => 'tt', title => 'count', shlist => 1,   inlinefilter => { },  },
            ],
        },
        default_field_params => { shlist => 1, },
        fields => [
            { name => 'categ', edlist => 1, showmacro => 'catname2link', inlinefilter => { group => 1 }, }, 
            { name => 'videodirectgroup', addform => 1, shlist => 1, ftype=>'hidden', inlinefilter => { group => 1 }, }, 
            { name => 'UpdateTime', inlinefilter => {}, },
            { name => 'virt', addform => 1,  title => 'Виртуальные категорий', edlist => 1, shlist => 0, dbtype => "varchar(255) DEFAULT ''",
                  autoedit => sub { my ($proj, $h) = @_; return $h->{ categ } =~ / _ / ? 'yes' : 'no' },
                  inlinefilter => {}, 
            }, 
        ],
        filters => [
               { field => 'categ', name => 'categ', like => 1, },
               { field => 'virt',  name => 'virt', grp => 1, selectnames => { 'yes' => 'виртуальные', 'no' => 'не виртульные' }, },
        ],
        pager => { name => 'p', cc => 50, },
        topmenu => [
            { title => 'Данные', sublist => [
                { title => 'Выгрузить соответствие в XLS', url => '?cmd=videodirectgroups_xls', },
                { title => 'Группы категорий', url => '?cmd=videodirectgroups', },
                { title => 'Подавление категорий', url => '?cmd=videodirectgroups_fix', },
            ] },
        ],
    };
}

sub videodirectgroups_categsinf_r :CMDH {
    my ($proj, $vars) = @_;
    my $hh = videodirectgroups_categsinf($proj, $vars);
    $hh->{topmenu} = [
            { title => 'Данные', sublist => [
                { title => 'Выгрузить соответствие в XLS', url => '?cmd=videodirectgroups_xls', },
                { title => 'Группы категорий', url => '?cmd=videodirectgroups_r', },
            ] },
    ];
    delete($hh->{$_}) for qw(rights);
    return $hh;
}

sub videodirectgroups_fix :CMDH {
    my ($proj, $vars) = @_;
    #$proj->dd($proj->get_videodirectgroups_fix); 

    return {
        table => 'videodirectgroups_fix',
        title => 'Соответствие категорий и групп',
        rights => 'right_edit_videodirectgroups',
        readonly => 0,
        idfield => 'ID',
        fix_sql_problem => 1,
        logchanges => 1,
        fields => [
            { name => 'title',  shlist => 1, }, 
            { name => 'rules',   edlist => 1, shlist => 0, ftype => 'bigtextarea' },
        ],
    };
}

sub videodirectgroups_second_level :CMDH {
    my ($proj, $vars) = @_;
    return {
        title => 'Второй уровень групп видеодиректа',
        table => 'videodirectgroups_second_level',
        readonly => 1,
        idfield => 'ID',
        debug => 0,
        rights => 'right_edit_videodirectgroups',
        #compact_inline_add => 1,
        fix_sql_problem => 1,
        logchanges => 1,
        #group_by => 'Category',
        delonly => 1,
        default_field_params => { shlist => 1, },
        group_by_add_fields => [ "max(UpdateTime) MaxUpdateTime" ],
        fields => [
            { name => 'level2', edlist => 1, dbtype => "varchar(255) DEFAULT ''", inlinefilter => {}, }, 
            { name => 'UpdateTime', dbtype => 'timestamp', shlist => 0, autoedit => sub { $proj->dates->cur_date('db_time') }, },
            { name => 'virt', title => 'Виртуальные категорий', edlist => 1, shlist => 0, dbtype => "varchar(255) DEFAULT ''",
                  autoedit => sub { my ($proj, $h) = @_; return $h->{ categ } =~ / _ / ? 'yes' : 'no' }, 
            }, 
            { extname => 'MaxUpdateTime', dbtype => 'timestamp', title => 'UpdateTime', autoedit => sub { $proj->dates->cur_date('db_time') }, inlinefilter => {}, },
            { extsql => ['select level2, count(*) cc from videodirectgroups_second_level where level2 in (?) group by level2', 'level2'],
              extname => 'cc',
            },
            { name => 'videodirectgroup', shlist => 0, wmanual_category => 1, edlist => 1, addform => 1, dbtype => "varchar(255) DEFAULT ''", },
            #{ name => 'UserState', show_good_bad => 1, dbtype => "varchar(255) DEFAULT ''", ftype=>'hidden', disable_add => '1', addform => 0, },
        ],
        filters => [
               { field => 'videodirectgroup',  name => 'Группа', use_other_filters => 1, like => 1, },
#              { field => 'virt', name => 'Виртуальные', grp => 1, selectnames => { 'yes' => 'виртуальные', 'no' => 'не виртульные' }, },
        ],
        group_by => 'level2',
        default_filter => { virt => 'no', },
        extlists => [
            { cmd => 'videodirectgroups_second_level_sublist', using => '', addelemparams => { 'level2' => 'level2', }, addfilterparams => { 'flt_virt' => 'virt', } },
        ],
        pager => { name => 'p', cc => 50, },
        topmenu => [
            { title => 'Данные', sublist => [
                { 
                      title => 'Залить новый маппинг', name => 'newmapping',
                      filefield => 'mappingfile',
                      action => sub {
                          my ($self, $lst1, $lst2, $prmsh) = @_;
                          my $proj = $self->proj;

                          my $crnt_table = 'videodirectgroups_second_level';
                    
                          my $data = $proj->xls2arr($prmsh->{'mappingfile'}, $prmsh->{'mappingfile_filename'});
                    
#$self->proj->dd($data, $prmsh->{'mappingfile'}, $prmsh->{'mappingfile_filename'});
$self->proj->dd($data,  $prmsh->{'mappingfile_filename'});
                          return unless $data && (@{$data->[0]} > 0);
                    
                          $data = $data->[0]; #берем данные только с первой страницы 

                          #my %mpg = map { $_->[0] => $_->[1] } map  { [ split( "\t", $_) ] } grep { !/Article/ } @$data;
                          #У одной категории может быть несколько групп
                          my %mpg = ();
                          push( @{$mpg{ $_->[0] } ||= []}, $_->[1] ) for map  { [ split( "\t", $_) ] } grep { !/Article/ } @$data;
                    
                          #$proj->dd(\%mpg);

                          sub clear_videodirectgroup_text { my $t = $_[0] ; $t =~ s/\s+\(РАЗНОЕ\)//; return $t;}  
                    
                          my @arr = map { { videodirectgroup => $_, level2 => ($mpg{ $_ } || $mpg{ del_virt_pref($_) } || $mpg{ clear_videodirectgroup_text($_) } || ['UNKNOWN']), virt => ( / _ / ? 'yes' : 'no' ), } } 
                              grep {! /^\./}
                              map { $_->{'videodirectgroup'} } 
                              @{ $proj->dbtable($videodirectgroups_table_name, 'ID')->List2( filter => {}, gfields => ['videodirectgroup'], group_by => 'videodirectgroup', )};

                          #$proj->dd(\@arr);
                    
                          #exit;
                    
                          #Раскрываем массивы групп в плоский список
                          my @narr = ();
                          for my $pr (@arr){
                              for my $mg (@{$pr->{level2}}){
                                  my %h = %$pr;
                                  $h{level2} = $mg;
                                  push(@narr, \%h); 
                              }
                          }
                          @arr = @narr;
                    
                          #$proj->dd(\@arr);
                          #return;
                    
                          if(@arr > 1){
                              $proj->Do_SQL('DROP TABLE '.$crnt_table.'_old_data');
                              $proj->Do_SQL('CREATE TABLE IF NOT EXISTS '.$crnt_table.'_old_data LIKE '.$crnt_table);
                              $proj->Do_SQL('INSERT INTO '.$crnt_table.'_old_data SELECT * FROM '.$crnt_table);
                              $proj->Do_SQL('DELETE FROM '.$crnt_table);
                              $proj->dbtable($crnt_table)->Add(\@arr);
                          }
                          #$proj->dd('FFF'. @$data);
                    
                      },
                },
                { title => 'Выгрузить соответствие в XLS', url => '?cmd=videodirectgroups_second_level_xls', },
#                { title => 'Плоский список брендов и групп', url => '?cmd=videodirectgroups_brandgroups_all' },
#                { title => 'Список категорий с группами', url => '?cmd=videodirectgroups_categsinf', },
#                { title => 'Подавление категорий', url => '?cmd=videodirectgroups_fix', },
            ] },
        ],
    };
}

sub videodirectgroups_second_level_sublist :CMDH {
    #my ($proj, $vars) = @_;
    #$proj->dd($proj->form);
    return {
        table => 'videodirectgroups_second_level',
        readonly => 1,
        rights => 'right_edit_videodirectgroups',
        idfield => 'ID',
        debug => 0,
        save_button => { title => 'Добавить группу', right => 1, },
        fix_sql_problem => 1,
        #group_by => 'Category',
        show_del => 1,
        delonly => 1,
        compact_inline_add => 1,
        default_field_params => { shlist => 1, },
        order_by => "SUBSTRING_INDEX(videodirectgroup, ' _ ', -1), LENGTH(videodirectgroup)",
        logchanges => 1,
#        show_sublist_inline_add => 1,
        fields => [
            #{ name => 'ID', }, 
            #{ name => 'UserState', show_good_bad => 1, ftype=>'hidden', disable_add => '1', addform => 1, },
            { name => 'level2', addform => 1, shlist => 0, ftype=>'hidden', }, 
            { name => 'videodirectgroup', edlist => 1, }, 
            { name => 'virt', addform => 1,  title => 'Виртуальные группы', edlist => 1, shlist => 0, dbtype => "varchar(255) DEFAULT ''",
                  autoedit => sub { my ($proj, $h) = @_; return $h->{ videodirectgroup } =~ / _ / ? 'yes' : 'no' }, 
            }, 
            #{ title => 'EEEEE', extname => 'sss', shlist => 1, showmacroel => 'show_list_inline_checkbox', }, 
            #{ name => 'categ', manual_category => 1, },
        ],
        filters => [
               { field => 'virt', name => 'virt', },
        ],
        default_filter => { virt => '     ', },
        select_elems => { binary => 0, right => 0, },
        bottom_actions => [
            { title => 'Перенести группы', name => 'movecategs', action => sub {
                    my ($self, $lst1, $lst2, $prmsh) = @_;
                    my @ids = split ',', $lst1;
                    if(@ids){
                        $self->proj->dbtable('videodirectgroups_second_level', 'ID')->Edit( \@ids, { level2 => $prmsh->{'Name'} } );
                    }
                },
                inline => 1,
                fields => [
                    { name => "Name", title => 'Группа', edlist => 1, typeaheadfield => 'level2', },
                ],
                confirm => 'Вы действительно хотите перенести группу?',
            },
        ],
        #select_elems => { buttons => {},  right => 1, },
        add_filter => { 'videodirectgroup !=' => '' },
        #default_filter => { UserState => '', },
        pager => { name => 'p', cc => 20, },
    };
}

sub videodirectgroups_second_level_xls :CMD {
    my ($proj, $vars) = @_;

    my $list = $proj->List_SQL("select videodirectgroup, level2 from videodirectgroups_second_level order by level2, videodirectgroup");
    $list = [ map {[ $_->{videodirectgroup}, $_->{level2} ]} @$list ];
    
    $vars->{'_return_real_xls'} = 'd_catalogia_videodirectgroups_second_level_mapping_'.$proj->dates->cur_date('db').'.xls';
    $vars->{text} = array2xlsx($list); 
}

1;
