package DBList;

use strict;

use utf8;

use base qw(ObjLib::ProjPart);

use Data::Dumper;
use URI::Escape;
use Cmds::Base;
use Storable qw(dclone);

use Digest::MD5;

use Time::HiRes qw/time/;
use Utils::XLS qw(array2xls array2xlsx xls2array xlsx2array xls_edit_line xls_lines_list);
use Utils::Funcs qw(
    prm_list_filter
);
use Utils::Sys qw(uniq);

use BM::DBFiles;

########################################################
# Служебные функции
########################################################

sub tinf2fields {
    my ($tinf) = @_;
    return ( map { $_->{'grp'} ? ($_, @{$_->{'grp'}}) : $_ } (@{$tinf->{'fields'}}, @{$tinf->{'default_inlinefilter_params'}{'fields'}}) );
}

#Получаем данные из входящей формы
sub _fields2hash {
    my ($self, $fields, $form, $undefflt) = @_;
    my $h = {};
    my @flds = grep { $_->{name} } grep {$_->{edlist}} @$fields;
    @flds = grep { defined $form->{$_->{'name'}} } @flds if $undefflt;
    $h->{$_} = $form->{$_} for map { $_->{name} } @flds;
    #Названия загруженных файлов
    for my $f ( grep { $_->{'ftype'} && ($_->{'ftype'} eq 'file') && $_->{filenamefield} } @$fields ){
        $h->{$f->{filenamefield}} = $form->{$f->{name}.'_filename'}; 
    }
    #Автоматические поля
    for my $f ( grep { $_->{autoedit} } @$fields ){
        my $vl = $f->{autoedit}->($self->proj, $h);
        $h->{$f->{name}} = $vl if defined $vl;
    }
    return $h;
}

#Получаем данные из входящей формы
sub fields2hash {
    my ($self, $act, $undefflt) = @_;
    my $tinf = $self->tinf;
    my $fields = [$self->all_fields];
    $fields = [ grep {! $_->{disable_edit}} @$fields] if ($act eq 'Edit') || ($act eq 'Update') || ($act eq 'MassUpdate');
    $fields = [ grep {! $_->{disable_add}} @$fields] if $act eq 'Add';
    my $form = $self->form;
    return $self->_fields2hash($fields, $form, $undefflt);
}

#Парсим строку с мета-информацией в хэш
sub meta2hash {
    my ($str) = @_;
    return { map { split('=', $_, 2) } split /\n/, $str }; 
}

#Парсим нужные поля с мета-информацией в списке полученных из базы данных
sub parse_meta {
    my ($fields, $lst) = @_;
    for my $f (@$fields){
        if($f->{meta}){
            $_->{$f->{name}.'_hash'} = meta2hash($_->{$f->{name}}) for @$lst;
        }
    }
}

sub showmacro2tmpl {
    my ($showmacro, $fld) = @_;
    if($showmacro =~ /\S\s\S/){ #Обрабатываем макросы с параметрами
        my @marr = split(/\s+/, $showmacro);
        $showmacro = shift @marr;
        my $res = $showmacro.'('.join(',', map { "el.$_" } @marr).')';
        $res = '[%'.$res.'%]';
        return $res;
    }else{
        return '[% '.$showmacro.'( el.'.$fld.' ) %]';
    }
}

sub field2sqlarr {
    my ($f, $pref) = @_;
    my @res = ();
    return () unless $f->{name};
    if(($f->{ftype} // '') eq 'file'){
        if($pref && @$pref){
            for my $pr (@$pref){
                push( @res, '    `'.$pr.$f->{name}.'` longblob' );
                push( @res, '    `'.$pr.$f->{filenamefield}.'` text' )  if $f->{filenamefield};
            }
        }else{
            push( @res, '    `'.$f->{name}.'` longblob' );
            push( @res, '    `'.$f->{filenamefield}.'` text' )  if $f->{filenamefield};
        }
    }elsif($f->{dbtype}){
        if($pref && @$pref){
            push( @res, '    `'.$_.$f->{name}.'` '.$f->{dbtype} ) for @$pref;
        }else{
            push( @res, '    `'.$f->{name}.'` '.$f->{dbtype} );
        }
    }elsif($f->{ftype} eq 'timestamp'){
        if($pref && @$pref){
            push( @res, '    `'.$_.$f->{name}.'` timestamp' ) for @$pref;
        }else{
            push( @res, '    `'.$f->{name}.'` timestamp' );
        }
    }elsif($f->{ftype} =~ /^(var)?char\(\s*\d+\s*\)\s*$/i){
        if($pref && @$pref){
            push( @res, '    `'.$_.$f->{name}.'` '.$f->{ftype}.' NOT NULL DEFAULT ""' ) for @$pref;
        }else{
            push( @res, '    `'.$f->{name}.'` '.$f->{ftype}.' NOT NULL DEFAULT ""' );
        }
    }elsif($f->{name} =~ /(_id|[_a-z]ID|Count)$/){
        if($pref && @$pref){
            push( @res, '    `'.$_.$f->{name}.'` bigint(22) NOT NULL DEFAULT 0' ) for @$pref;
        }else{
            push( @res, '    `'.$f->{name}.'` bigint(22) NOT NULL DEFAULT 0' );
        }
    }elsif($f->{name} =~ /^Lang$/i){
        if($pref && @$pref){
            push( @res, '    `'.$_.$f->{name}.'` char(20)' ) for @$pref;
        }else{
            push( @res, '    `'.$f->{name}.'` char(20)' );
        }
    }elsif($f->{name} =~ /^Login$/i){
        if($pref && @$pref){
            push( @res, '    `'.$_.$f->{name}.'` char(40)' ) for @$pref;
        }else{
            push( @res, '    `'.$f->{name}.'` char(40)' );
        }
    }elsif($f->{name} =~ /^date$/i){
        if($pref && @$pref){
            push( @res, '    `'.$_.$f->{name}.'` datetime' ) for @$pref;
        }else{
            push( @res, '    `'.$f->{name}.'` datetime' );
        }
    }else{
        if($pref && @$pref){
            push( @res, '    `'.$_.$f->{name}.'` text default ""' ) for @$pref;
        }else{
            push( @res, '    `'.$f->{name}.'` text default ""' );
        }
    }
    return @res;
}


sub create_sql {
    my ($self, $tinf) = @_;
    my @fields = tinf2fields($tinf);
    my $sql = 'CREATE TABLE `'.$tinf->{'table'}.'` ('."\n";
    #Проверяем настройки ключевого поля
    my @idflds = grep { $_->{name} eq $tinf->{'idfield'} } @fields; #Получаем поле, если есть
    @fields = ( { name => $tinf->{'idfield'}, dbtype => 'bigint(22) NOT NULL AUTO_INCREMENT'  }, @fields ) unless @idflds; #Если нет, добавляем ключевое поле в описание
    $idflds[0]{'dbtype'} = 'bigint(22) NOT NULL AUTO_INCREMENT' if @idflds && (! $idflds[0]{'dbtype'}) && (! $idflds[0]{'ftype'}); #Указываем тип поля, если не указан
    #/Проверяем настройки ключевого поля
    #$self->proj->dd(\@fields, \@idflds);
    my @fields_sql = map { field2sqlarr($_) } @fields;
    @fields_sql = uniq @fields_sql;
    $sql .=  join '', map { "$_,\n" } @fields_sql;
    $sql .= "    type char(255) NOT NULL DEFAULT '',\n" if $tinf->{'typeflt'};
    $sql .= '    PRIMARY KEY (`'.$tinf->{'idfield'}.'`)'."\n";
    $sql .= ") ENGINE=InnoDB CHARSET=utf8 ;\n";    
}

sub create_log_sql {
    my ($tinf) = @_;
    my $sql = 'CREATE TABLE `Log_'.$tinf->{'table'}.'` ('."\n";
    $sql .= "    ID bigint(22) NOT NULL AUTO_INCREMENT,\n";
    $sql .= "    login char(255) NOT NULL DEFAULT '',\n";
    $sql .= "    cmd char(255) NOT NULL DEFAULT '',\n";
    $sql .= "    act char(255) NOT NULL DEFAULT '',\n";
    $sql .= "    acttime timestamp,\n";
    $sql .= "    elemid bigint(22) DEFAULT 0,\n";
    my @fields = tinf2fields($tinf);
    @fields = grep { $_->{name} ne $tinf->{'idfield'} } @fields; #Удаляем поле ID
    @fields = ({ name => $tinf->{'idfield'} }, @fields); #Принудительно добавляем поле ID
    my @fields_sql = map { field2sqlarr($_, ['Old_', 'New_']) } @fields;
    @fields_sql = uniq @fields_sql;
    $sql .= join '', map { "$_,\n" } @fields_sql;
    $sql .= "    type char(255) DEFAULT '',\n" if $tinf->{'typeflt'};
    $sql .= '    PRIMARY KEY (`ID`)'."\n";
    $sql .= ") ENGINE=InnoDB CHARSET=utf8 ;\n";    

};


sub add_table_field_sql {
    my ($dbt, $tbl, $f, $pref) = @_;
    for my $sql ( field2sqlarr($f, $pref) ){
        $dbt->Do_SQL( 'alter table `'.$tbl.'` add column '.$sql );
    }
    #return 'alter table `'.$tbl.'` add column `'.$fld.'` text';    
}

########################################################
# Прототипы
########################################################

sub prt_h : CACHE {
    return Cmds::Base::_cmds_h_list();
}

sub prt_bs : CACHE {
    return Cmds::Base::_cmds_bs_list();
}

sub prt_fld : CACHE {
    return Cmds::Base::_cmds_fld_list();
}

########################################################
# Методы
########################################################

sub dbg :CACHE {
    my ($self) = @_;
    my $dbg = 0;
    $dbg = 1 if $self->form->{debug};
    return $dbg;
}

sub sqldbg :CACHE {
    my ($self) = @_;
    my $dbg = 0;
    $dbg = 1 if $self->form->{sqldebug};
    return $dbg;
}

sub dbglog {
    my ($self, $data) = @_;
    $self->proj->dd($data);
}

sub vars {
    my ($self) = @_;
    return $self->{'vars'};
}

sub form {
    my ($self) = @_;
    return $self->{'form'} if $self->{'form'};
    my $form = $self->proj->form;
    $self->{'form'} = $form;
    return $self->{'form'};
}

sub cmd {
    my ($self) = @_;
    return $self->form->{'cmd'};
}

sub act {
    my ($self) = @_;
    return $self->form->{'act'};
}

sub getlistflt {
    my ($self, @prms) = @_;
    my $fltk = 'getlistflt_cache'; #Кэшируем резальтат в зависимости от параметров
    return $self->{$fltk} if $self->{$fltk};
    my $list = $self->tinf->{'getlistflt'}($self, @prms);
    $self->{$fltk} = $list;
    return $list;
}

sub getlist {
    my ($self, @prms) = @_;
    my $fltk = 'getlist_cache'.join('//', @prms); #Кэшируем резальтат в зависимости от параметров
    return $self->{$fltk} if $self->{$fltk};
    my $list = $self->tinf->{'getlist'}($self, @prms);
    $self->{$fltk} = $list;
    return $list;
}

#Оборачиваем счетчики
sub dbt_count_old {
    my ($self, @prms) = @_;
    my $beg = time;
    my $res = $self->dbt->Count(@prms);
    my $end = time;
    $self->proj->dd(['dbt_count', $end - $beg, \@prms]) if $self->dbg;    
    return $res;
}

#Получаем соответствие полей и описаний для сложных полей
sub complicated_add_fields_hash {
    my ($self, @prms) = @_;
    my $tinf = $self->tinf;

    #Меняем формат настроек
    my %hprms = ();
    $hprms{filter} = $prms[0] if $prms[0];
    $hprms{gfields} = $prms[1] if $prms[1];

    my @cmplfld = ();
    
    #получаем использовавшиеся вычисляемые поля 
    @cmplfld = @{$tinf->{complicated_add_fields} || []}; 
#    @cmplfld = 
#        grep { my $t=$_; 
#               ($t =~ / $tinf->{group_by}$/) #как группировочное поле
#            || (( ref($prms[0]) eq 'HASH' ) &&  ( grep { $t =~ / $_$/ } keys %{$prms[0]} )) #как поле для фильтрации
#        }
#        grep {$_} map { ref($_) eq 'CODE' ? 
#            $_->( $self, 
#                ( $prms[0] ? ( filter  => $prms[0] )  : ()  ), #Фильтрация
#                ( $prms[1] ? ( gfields => $prms[1] )  : ()  ), #Список полей, если указан
#            ) : $_ }
#        @{$tinf->{complicated_add_fields}};
#    $self->proj->dd(\@cmplfld, $tinf->{complicated_add_fields}, );

    #Преобразуем вычисляемое поле в значение
    my $hh = { 
        map { @{$_}[1,0] }
        grep { @{$_} == 2 }   # Фильтруем пустые строки, которые получены из $_->( $self, )
        map { [ split / (?=\S+$)/, $_ ] }
        map { ref($_) eq 'CODE' ? $_->( $self, %hprms) : $_ } #Для полей, описанных как функции, получаем текстовые написания
        @cmplfld };
#    $self->proj->dd([ \@cmplfld, $hh,\@prms]);

    return $hh;
}

#Оборачиваем счетчики
sub dbt_count {
    my ($self, @prms) = @_;
    my $tinf = $self->tinf;

#$self->proj->dd(\@prms);
    my $grpfld = undef;
    if( $tinf->{group_by} ){ #Чтобы не получать данные тех полей, которых нет в группировке
        $prms[1] ||= [];
        push(@{$prms[1]}, $tinf->{group_by} !~ /\(/ ? split(/\s*,\s*/,$tinf->{group_by}) : $tinf->{group_by} ); #Если нет вызовов функций, разбиваем группировочную строку по полям
    }
    #Если используется вычисляемое поле, то добавляем его
    if( $tinf->{complicated_add_fields} ){

        my $hh = $self->complicated_add_fields_hash(@prms);

        #Заменяем в группировке вычисляемое поле на его значение
        if(ref($prms[1]) eq 'ARRAY'){
            $prms[1] = [ map { $hh->{$_} || $_ } @{$prms[1]}];
        }
  
        if(ref($prms[0]) eq 'HASH'){
            for my $k ( grep { $hh->{$_} } %{$prms[0]} ){
                #$prms[0]->{$hh->{$k}.' = '} = $prms[0]->{$k};
                my $newk = $hh->{$k};
                $newk .= ' = ' if ($newk =~ /\(/) && ($newk !~ /(LIKE|REGEXP|[=<>])\s*$/i); #После замены для вызовов функций не добавляется знак равенства
                $prms[0]->{$newk} = $prms[0]->{$k};
                delete($prms[0]->{$k});
            }
        }
        

#        if( @cmplfld ){ #Если группировка идёт по вычисляемому полю, добавляем его
#            push(@{$prms[1]}, map { s/ \S+$//; $_ } @cmplfld); 
#        }
    }
    #/Если используется вычисляемое поле, то добавляем его

#$self->proj->dd(\@prms);
    my $beg = time;
    my $res = 0;
    if($tinf->{'table'}){

        #Так как модерация может менять число строк, нужно получать полный список
        if($tinf->{'Moderate'} && $tinf->{'Moderate'}{'List'}){
            my %nprms = ( filter => $prms[0] ); #Получаем новый хэш настроек, так как часть настроек нужно отключить
            delete($nprms{order_by}); #Удаляем сортировку, так как она поменяется после добавления строк с модерации
            delete($nprms{limit}); #Удаляем ограничение на количество элементов, так как оно зависит от сортировки
 
            my $list = $self->dbt_list(%nprms); #Получаем полный список элементов
 
            my $gl = $tinf->{'Moderate'}{'List'}; 
            $list = $gl->($self, $list, \%nprms); #Доклеиваем новые строки и убираем удаленные
 
            #Накладываем поверх фильтрацию параметрами
            $list = prm_list_filter($list, \%nprms);

            $res = @$list;            
        }else{
            $res = $self->dbt->Count(@prms);
        }

    }elsif($tinf->{'getlist'}){
        my %prmh = ();
        $prmh{filter} = $prms[0] if $prms[0];
        my $list = $self->getlist(%prmh);
        $res = @$list;
    }
    my $end = time;
    $self->proj->dd(['dbt_count', $end - $beg, \@prms]) if $self->dbg;    
    return $res;
}

#Оборачиваем все селекты к таблице
sub dbt_list {
    my ($self, %prms) = @_;
    my $beg = time;
    #$self->dbt->{sql_dd_log} = 1;
    #$self->dbt->{sql_dd_log} = 1 if $self->dbg;
    $self->dbt->{sql_dd_log} = 1 if $self->sqldbg;
#    my $list = $self->dbt->List2(%prms);

    #Фикс значения NULL для пустой строки
    if($prms{filter}){
        for my $fn (keys %{$prms{filter}}){
            if( $prms{filter}{$fn} eq ''){
                $prms{filter}{$fn} = { $fn => '',  "$fn is NULL" => ''};
            }
        }
    }

    my $tinf = $self->tinf;

    my $list;
    if($tinf->{'table'}){
        #$self->dbt->{sql_dd_log} = 1;
        $self->dbglog(\%prms) if $self->dbg;
        $list = $self->dbt->List2(%prms);
#$self->proj->dd($list);
    }elsif($tinf->{'getlist'}){
        my $gl = $tinf->{'getlist'};  
        $list = $gl->($self, %prms);
    }

    my $end = time;
    $self->proj->dd(['dbt_list', $self->dbt->db_table, $end - $beg, \%prms]) if $self->dbg;    
    return $list;
}

#Получаем список элементов
#Не все запросы - прямые обращения к таблицам базы
sub dtact_list {
    my ($self, %prms) = @_;

    my $tinf = $self->tinf;

    if($tinf->{group_by}){
        if($prms{group_by}){
            $prms{group_by} .= ','.$tinf->{group_by};
        }else{
            $prms{group_by} = $tinf->{group_by};
        }
        if($tinf->{'group_by_count_field'}){
            if($prms{gfields}){
                push(@{$prms{gfields}}, 'count(*) '.$tinf->{'group_by_count_field'});
            }else{
                $prms{gfields} = ['*', 'count(*) '.$tinf->{'group_by_count_field'}];
            }
        }
        if($tinf->{'group_by_add_fields'}){
            my @gfarr = grep {$_} map { ref($_) eq 'CODE' ? $_->( $self, %prms ) : $_ } #некоторые поля могут зависеть от текущих фильтров и задаются функцией
                @{ $tinf->{'group_by_add_fields'} };
            if($prms{gfields}){
                push(@{$prms{gfields}}, @gfarr );
            }else{
                $prms{gfields} = ['*', @gfarr ];
            }
        }
    }else{
        if($tinf->{'complicated_add_fields'}){
            my @cfarr = grep {$_} map { ref($_) eq 'CODE' ? $_->( $self, %prms ) : $_ } #некоторые поля могут зависеть от текущих фильтров и задаются функцией
                @{ $tinf->{'complicated_add_fields'} };
            if($prms{gfields}){
                push(@{$prms{gfields}}, @cfarr );
            }else{
                $prms{gfields} = ['*', @cfarr ];
            }
            
        }
    }

    my $list;
    if($tinf->{'Moderate'} && $tinf->{'Moderate'}{'List'}){
        my %nprms = %prms; #Получаем новый хэш настроек, так как часть настроек нужно отключить
        delete($nprms{order_by}); #Удаляем сортировку, так как она поменяется после добавления строк с модерации
        delete($nprms{limit}); #Удаляем ограничение на количество элементов, так как оно зависит от сортировки

        $list = $self->dbt_list(%nprms); #Получаем полный список элементов

        my $gl = $tinf->{'Moderate'}{'List'}; 
        $list = $gl->($self, $list, \%prms); #Доклеиваем новые строки и убираем удаленные

        #Накладываем поверх фильтрацию параметрами
        $list = prm_list_filter($list, \%prms);
    }else{
        $list = $self->dbt_list(%prms);
    }

    #Перезаписываем часть полей на значения из суммарных полей
    if($prms{group_by} && $tinf->{group_by_rewrite_rules}){
        for my $rnm ( keys %{$tinf->{group_by_rewrite_rules}} ){
            my $nm = $tinf->{group_by_rewrite_rules}{$rnm};
            $_->{$rnm} = $_->{$nm} for @$list;
        }
    }
#$self->proj->dd(\%prms, $tinf->{fields}, $list);

    $self->get_extfields_inf($list); #Доклеиваем данные из внешних таблиц

    if($tinf->{'action_onlist'}){
        my $f = $tinf->{'action_onlist'};
        $f->($self->proj, $_) for @$list;
    }

    if(1){
        for my $l (@$list){ 
            #Добавляем уникальный идентификатор для всех строк
            $l->{'uniq_elem_id'} = substr( Digest::MD5::md5_hex( (1000000 * rand()) . join('/',keys(%$l)) ), 0, 8 );
        }
    }

    if($tinf->{'grfield'}){
        my @flds = grep {$_} split /,| +/, $tinf->{'grfield'};
        my %h = ();
        $_->{'grfield_curval'} = join ', ', grep {$_} @{$_}{ @flds } for @$list;
        push( @{$h{$_->{'grfield_curval'}} ||= []}, $_ ) for @$list;
        $list = [ map { @{$h{$_}} } sort keys %h ];
        $list = [ reverse @$list ] if $tinf->{grfield_reverse};
    }

    return $list;
}

#Не все запросы - прямые обращения к таблицам базы
sub dtact_get {
    my ($self, $id )  = @_;

    my $tinf = $self->tinf;

    my $h = {};
    if($tinf->{'Moderate'} && $tinf->{'Moderate'}{'Get'}){
        my $gl = $tinf->{'Moderate'}{'Get'}; 
        $h = $gl->($self, $id);
    }elsif($tinf->{'table'}){
        $h = $self->dbt->Get($id);
    }elsif($tinf->{'getlistelem'}){
        my $gl = $tinf->{'getlistelem'};  
        $h = $gl->($self->proj, $id);
    }

    if($tinf->{'action_onget'}){
        $tinf->{'action_onget'}->($self->proj, $id, $h);
    }
    return $h;
}

#Не все запросы - прямые обращения к таблицам базы
sub dtact_edit {
    my ($self, $id, $h) = @_;

    my $tinf = $self->tinf;

    #Специальное редактирование полей
    if($tinf->{exteditfld}){
        for my $k (keys %$h){
            if( $tinf->{exteditfld}{$k} ){
                $tinf->{exteditfld}{$k}->($self, $id, $k, $h->{$k});
                delete($h->{$k});
            }
        }
    }
    #/Специальное редактирование полей

    if($tinf->{'action_before_edit'}){
        $tinf->{'action_before_edit'}->($self->proj, $id, $h);
    }

    if($tinf->{'Moderate'} && $tinf->{'Moderate'}{'Edit'}){
        my $gl = $tinf->{'Moderate'}{'Edit'};
        $id = $gl->($self, $id, $h);
    }elsif($tinf->{'table'}){
        $self->dbt->Edit($id, $h);
    }elsif($tinf->{'editlistelem'}){
        my $gl = $tinf->{'editlistelem'};  
        $gl->($self->proj, $id, $h);
    }

    if($tinf->{'action_onedit'}){
        $tinf->{'action_onedit'}->($self->proj, $id, $h);
    }
}

sub dtact_multiedit {
    my ($self, $arr) = @_;

    my $tinf = $self->tinf;

    #Специальное редактирование полей
    if($tinf->{exteditfld}){
        for my $l (@$arr){ #Перебираем пары [ ключ, хэш изменений ]
            my ($id, $h) = @$l;
            for my $k (keys %$h){
                if( $tinf->{exteditfld}{$k} ){
                    $tinf->{exteditfld}{$k}->($self, $id, $k, $h->{$k});
                    delete($h->{$k});
                }
            }
        }
        #Удаляем те, для которых не осталось полей на изменение
        $arr = [ grep { keys %{$_->[1]} } @$arr ];
    }
    #/Специальное редактирование полей

    if($tinf->{'action_before_edit'}){
        for my $l (@$arr){
            my ($id, $h) = @$l;
            $tinf->{'action_before_edit'}->($self->proj, $id, $h);
        }
    }

    if($tinf->{'Moderate'} && $tinf->{'Moderate'}{'Edit'}){
        my $gl = $tinf->{'Moderate'}{'Edit'};
        for my $l (@$arr){
            my ($id, $h) = @$l;
            $gl->($self, $id, $h);
        }
    }elsif($tinf->{'table'}){
        my @narr = ();
        for my $l (@$arr){
            my ($id, $h) = @$l;
            my %nh = %$h;
            $nh{$self->dbt->id_field} = $id;
            push(@narr, \%nh);
        }
        #$self->proj->dd(\@narr);
        $self->dbt->Add_multi(\@narr, {update => 1});
    }elsif($tinf->{'editlistelem'}){
        my $gl = $tinf->{'editlistelem'}; 
        for my $l (@$arr){
            my ($id, $h) = @$l;
            $gl->($self->proj, $id, $h);
        }
    }

    if($tinf->{'action_onedit'}){
        for my $l (@$arr){
            my ($id, $h) = @$l;
            $tinf->{'action_onedit'}->($self->proj, $id, $h);
        }
    }
}

#Не все запросы - прямые обращения к таблицам базы
sub dtact_add {
    my ($self, $h) = @_;

    my $tinf = $self->tinf;

    if($tinf->{'action_before_add'}){
        $tinf->{'action_before_add'}->($self->proj, $h);
    }

    #Специальное редактирование полей
    #Удаляем внешние поля из общего хэша
    my %origh = %$h; #Сохраняем оригинальный хэш
    if($tinf->{exteditfld}){
        delete($h->{$_}) for grep { $tinf->{exteditfld}{$_} } %$h;
    }
    #/Специальное редактирование полей

    my $id = undef;
    if($tinf->{'Moderate'} && $tinf->{'Moderate'}{'Add'}){
        my $gl = $tinf->{'Moderate'}{'Add'};
        $id = $gl->($self, $id, $h);
    }elsif($tinf->{'table'}){
        my $opts = {};
        $opts->{ignore} = $tinf->{ignore_on_duplicate_key};
        $id = $self->dbt->Add($h, $opts);
    }elsif($tinf->{'addlistelem'}){
        my $gl = $tinf->{'addlistelem'};  
        $id = $gl->($self->proj, $id, $h);
    }

    #Специальное редактирование полей
    #Выполняем действия
    if($tinf->{exteditfld}){
        $tinf->{exteditfld}{$_}->($self, $id, $_, $origh{$_}) for grep { $tinf->{exteditfld}{$_} } %origh;
    }
    #/Специальное редактирование полей

    if($tinf->{'action_onadd'}){
        $tinf->{'action_onadd'}->($self->proj, $id, $h);
    }
    
    return $id;
}

sub dtact_del {
    my ($self, $id) = @_;

    my $tinf = $self->tinf;

    if($tinf->{'Moderate'} && $tinf->{'Moderate'}{'Del'}){
        my $gl = $tinf->{'Moderate'}{'Del'};
        $id = $gl->($self, $id);
    } elsif ($tinf->{dellistelem}) {
        my $gl = $tinf->{dellistelem};
        $id = $gl->($self->proj, $id);
    } else {
        $self->dbt->Del($id);
    }
}

sub add_log_inf {
    my ($self, $id, $newh) = @_;
    my $proj = $self->proj;
    my $table = $self->tinf->{'table'};
    my ($cmd, $act) = ($self->cmd, $self->act);
    my $logdbtable = $self->dbt_log;
    my $h = { 
        login => $proj->{'login'},
        cmd => $cmd,
        act => $act,
        elemid => $id,
    };
    #Берём только описанные поля
    my %fh = map { $_->{name} => 1 } grep {$_->{name}} $self->fields;
    my $oldh = $id ? $self->dbt->Get($id) : {};
    if($oldh){
        for my $k ( grep {$fh{$_}} keys %$oldh ){
            $h->{'Old_'.$k} = $oldh->{$k};
            $h->{'New_'.$k} = $oldh->{$k}; #Записываем предыдущие поля, так как могут редактироваться не все
        }
    }
    if($newh){
        $h->{'New_'.$_} = $newh->{$_} for keys %$newh;
    }
    #Для удаления заменяем все значения на пустые - нужно для правильного отображения лога
    if( $act eq 'Del' ){
        $h->{'New_'.$_} = '' for keys %$oldh;
    }
#$proj->dd([$table, $act, $id, $newh], $h);
    $logdbtable->Add($h);
}

sub fields {
    my ($self) = @_;
    return @{ $self->tinf->{'fields'} };
}

#Возвращает поля с учётом сгруппированных
sub all_fields {
    my ($self) = @_;
    return tinf2fields($self->tinf);
}

sub get_base_tinf {
    my ($self, $tinf) = @_;

    my $proj = $self->proj;
    my $vars = $self->vars;

    #Используем прототипы
    #my $hbase = {
    #    'dirs'       => \&get_dir_hash,
    #    'dirslist'   => \&get_dirlist_hash,
    #    'list'       => \&get_list_hash,
    #    'loglist'    => \&get_log_hash,
    #};
    if($tinf->{'base'} && ($self->prt_bs->{$tinf->{'base'}} || $self->prt_h->{$tinf->{'base'}} )){
        #my $ntinf = $hbase->{$tinf->{'base'}}->($proj, $vars);
        my $bsf = $self->prt_bs->{$tinf->{'base'}} || $self->prt_h->{$tinf->{'base'}};
        my $ntinf = $bsf->($proj, $vars);
        $ntinf = $self->get_base_tinf($ntinf);
        my @addlistlogic = qw{ fields filters }; #Списковые параметры, которые мы не перезаписываем, а добавляем в существующий
        for my $k (keys %$tinf){
            if( grep { $k eq $_ } @addlistlogic){
                my @baselist = @{ $ntinf->{$k} || [] };
                my @newlist = @{ $tinf->{$k} || [] };
                for my $f ( grep { $_->{'redefine_base'} || $_->{'delete_base'} } @newlist ){ #Фильтруем переопределяемые поля
                    @baselist =
                        grep {!(defined $_->{'name'}    && defined $f->{name}    &&  ($_->{'name'}    eq $f->{'name'}   ) )}
                        grep {!(defined $_->{'extname'} && defined $f->{name}    &&  ($_->{'extname'} eq $f->{'name'}   ) )}
                        grep {!(defined $_->{'name'}    && defined $f->{extname} &&  ($_->{'name'}    eq $f->{'extname'}) )}
                        grep {!(defined $_->{'extname'} && defined $f->{extname} &&  ($_->{'extname'} eq $f->{'extname'}) )}
                        grep {!(defined $_->{'field'}   && defined $f->{'field'} &&  ($_->{'field'}   eq $f->{'field'}  ) )}    # Для filters
                        @baselist;
                }
                for my $f ( grep { $_->{'update_base'} } @newlist ){ #Обновляем данные в полях
                    my @chbsd =
                        grep {
                              (defined $_->{'name'}    && defined $f->{'name'}    && ($_->{'name'}    eq $f->{'name'}    ))
                           || (defined $_->{'extname'} && defined $f->{'name'}    && ($_->{'extname'} eq $f->{'name'}    ))
                           || (defined $_->{'name'}    && defined $f->{'extname'} && ($_->{'name'}    eq $f->{'extname'} ))
                           || (defined $_->{'extname'} && defined $f->{'extname'} && ($_->{'extname'} eq $f->{'extname'} ))
                           || (defined $_->{'field'}   && defined $f->{'field'}   && ($_->{'field'}   eq $f->{'field'}   ))    # Для filters
                        }
                        @baselist;
                    for my $of (@chbsd){
                        $of->{$_} = $f->{$_} for keys %$f;
                    }
                }
                @newlist = grep { ! ( $_->{'update_base'} || $_->{'delete_base'} ) } @newlist;
                $ntinf->{$k} = [ @baselist, @newlist ];
            }elsif($k eq 'alter_field_titles'){ #Перезаписываем добавленные поля
                $ntinf->{'alter_field_titles'} ||= {};
                $ntinf->{'alter_field_titles'}{$_} = $tinf->{'alter_field_titles'}{$_} for keys %{$tinf->{'alter_field_titles'}};
            }else{
                $ntinf->{$k} = $tinf->{$k};
            }
        }
        $tinf = $ntinf;
    }

    return $tinf;
}





#Применение всех настроек
#Накладываем прототипы и дефолтные значения
#Проверяем таблицы в базе на корректность, если указана таблица
sub tinf {
    my ($self) = @_;

    return $self->{'tinf'} if $self->{'tinf'};

    my $vars = $self->vars;
    my $proj = $self->proj;
    my $tinf = $vars->{tinf};

    my $cmd = $self->cmd;
    my $act = $self->act;
    my $id = $self->form->{'id'} || '-1';

    $self->dbglog($vars->{tinf}) if $self->dbg;

=h
    #Используем прототипы
    #my $hbase = {
    #    'dirs'       => \&get_dir_hash,
    #    'dirslist'   => \&get_dirlist_hash,
    #    'list'       => \&get_list_hash,
    #    'loglist'    => \&get_log_hash,
    #};
    if($tinf->{'base'} && ($self->prt_bs->{$tinf->{'base'}} || $self->prt_h->{$tinf->{'base'}} )){
        #my $ntinf = $hbase->{$tinf->{'base'}}->($proj, $vars);
        my $bsf = $self->prt_bs->{$tinf->{'base'}} || $self->prt_h->{$tinf->{'base'}};
        my $ntinf = $bsf->($proj, $vars);
        for my $k (keys %$tinf){
            if($k eq 'fields'){
                my @baselist = @{ $ntinf->{'fields'} };
                my @newlist = @{ $tinf->{'fields'} };
                for my $f ( grep { $_->{'redefine_base'} } @newlist ){ #Фильтруем переопределяемые поля
                    @baselist =
                        grep {!($_->{'name'}    && ( ($_->{'name'}    eq $f->{'name'}) || ($_->{'name'}    eq $f->{'extname'})  ))}
                        grep {!($_->{'extname'} && ( ($_->{'extname'} eq $f->{'name'}) || ($_->{'extname'} eq $f->{'extname'})  ))}
                        @baselist;
                }
                $ntinf->{'fields'} = [ @baselist, @newlist ];
            }elsif($k eq 'alter_field_titles'){ #Перезаписываем добавленные поля
                $ntinf->{'alter_field_titles'} ||= {};
                $ntinf->{'alter_field_titles'}{$_} = $tinf->{'alter_field_titles'}{$_} for keys %{$tinf->{'alter_field_titles'}};
            }else{
                $ntinf->{$k} = $tinf->{$k};
            }
        }
        $tinf = $ntinf;
        $vars->{tinf} = $tinf;
    }
=cut
    
    $tinf = $self->get_base_tinf($tinf);
    $vars->{tinf} = $tinf;

    $tinf->{'fields'} ||= []; #Создаём список полей, если не было

    if ($tinf->{norm_params}) {
        # Добавляем нормированные значения. Данные будут храниться в таблице.
        $proj->log("norm_params ...");

        $tinf->{cache_getlistflt} //= {};  # Включаем кэширование данных, если еще не включено

        # Вместо использования $tinf->{table} создаем $tinf->{getlistflt} и кэшируем данные в таблице 
        if ($tinf->{table}) {
            $tinf->{getlistflt} = sub {
                my ($self, %prm) = @_;
                my $proj = $self->proj;
                # $tinf->{table}, $tinf->{dbhname} были удалены. Их значения были сохранены в $tinf->{table_init}, $tinf->{dbhname_init}
                my $dbt = $proj->dbtable( $tinf->{table_init}, '', $tinf->{dbhname_init});
                my $list = $dbt->List();
                return $list;
            };
            # Удаляем $tinf->{table}, $tinf->{dbhname}. Их исходные значения сохраняем в $tinf->{table_init}, $tinf->{dbhname_init}
            ($tinf->{table_init}, $tinf->{dbhname_init}) = ($tinf->{table}, $tinf->{dbhname});
            ($tinf->{table}, $tinf->{dbhname}) = ();
            ($self->{'dbt'}, $self->{'dbt_log'}) = ();  # Обновляем $self->dbt, $self->dbt_log, т.к. поменялись table и dbhname   TODO
        };

        if ($tinf->{getlistflt}) {
            # Переписываем $tinf->{getlistflt} - добавляем данные для нормировки
            $tinf->{getlistflt_old} = $tinf->{getlistflt};  # Сохраняем исходный $tinf->{getlistflt}
            $tinf->{getlistflt} = sub {
                my ($self, %prm) = @_;
                my $list = $tinf->{getlistflt_old}->($self, %prm);

                my $norm_params = $tinf->{norm_params};
                return $list if (not $norm_params);

                my $add_norm_filter = $norm_params->{add_norm_filter} // {};
                my $norm_keys = $norm_params->{norm_keys} // [];
                my $norm_fields_names = [ map { ref($_) eq 'HASH' ? $_->{name} : $_}  @{ $norm_params->{norm_fields} // [] } ]; # Поля, для которых нужна нормировка

                # Получаем значения "Base"
                my %prm_base = (
                    %prm,
                    %$add_norm_filter,
                );
                my $list_base = $tinf->{getlistflt_old}->($self, %prm_base);

                sub gen_key { 
                    # Склеивает перечисленные в @$keys поля хэша $el в строку через "\t". Если задано add_filter => {}, то вместо $el используется {%$el, %$add_filter}
                    my ($el, $keys, %prm) = @_;
                    my $add_filter = $prm{add_filter} || {};
                    return join("\t", @{ { %$el, %$add_filter } }{ @$keys });
                };
                my %base = map { gen_key($_, $norm_keys) => $_ } @$list_base;
                # Дописываем поля "Base" в $list
                for my $el (@$list) {
                    my $el_base = $base{gen_key($el, $norm_keys, add_filter => $add_norm_filter)};
                    $el->{"DBListBase_$_"} = $el_base->{$_}    for @$norm_fields_names;
                }  # TODO что делать с полями, для которых в таблице нет соответствующего Base ?
                return $list;
            }; 
        }
        
        $tinf->{stat_fields} //= [];
        my $norm_fields = [ map { (ref($_) eq 'HASH' ? $_ : {name => $_}) }  @{ $tinf->{norm_params}{norm_fields} // [] }  ];   # Поля, для которых нужна нормировка. Преобразуем каждое поле в хэш.

        my $norm_default_field_params = $tinf->{norm_params}{default_field_params} // {};   # Заданные дефолтные настройки для полей stat_fields

        #  Собираем stat_fields, необходимые для нормировки
        my $stat_fields = [];
        # Дописываем в stat_fields поля из norm_fields 
        for my $fld (@$norm_fields) {
            my $name = $fld->{name} // '';
            my %h = (
                %$norm_default_field_params,
                name => "$name",
                stattype => "$name",
                shlist => 0,
                %$fld,
            );
            push @{$stat_fields}, {%h};
        };

        # Дописываем в stat_fields поля DBListBase* (они будут сохранены в таблицу при кэшировании) 
        for my $fld (@$norm_fields) {
            my $name = $fld->{name} // '';
            my %h = (
                %{ $norm_default_field_params },
                name => "DBListBase_$name",
                stattype => "DBListBase_$name",
                shlist => 0,
                #(map {$_ => $fld->{$_}}  grep {not /^(name|stattype)$/} keys %$fld),
            );
            push @{$stat_fields}, {%h};
        };

        # Дописываем в stat_fields поля DBListNorm* (они будут вычисляться из полей DBListBase*, сохраненных в таблице)
        for my $fld (@$norm_fields) {
            my $name = $fld->{name} // '';
            my $is_percent = ($fld->{unit} // $norm_default_field_params->{unit} // '') eq 'percent';  # Нужно ли вычислять значение в процентах
            my %h = (
                %$norm_default_field_params,
                name => "DBListNorm_$name"."_r",
                stgrptype => "#$name#/#DBListBase_$name#"  .  ($is_percent ? " * 100" : ""),
                stattype => "DBListNorm_$name"."_r",
                showmacro => 'format_number_3',
                title => "$name"."_r" . ($is_percent ? "(%)" : ""),
                shlist => 1,
                #(map {$_ => $fld->{$_}}  grep {not /^(name|stattype)$/} keys %$fld),
            );
            push @{$stat_fields}, {%h};
        };
        #$self->dbglog([norm_fields => $norm_fields, stat_fields => $stat_fields]);

        # В $tinf->{stat_fields} уже могли быть поля; преобразуем каждое поле в хэш
        $_ = {name => $_}  for grep {ref($_) eq ''}  @{$tinf->{stat_fields}};
        # Поля, которые уже есть в stat_fields
        my %stfnames = map { (ref($_) eq 'HASH'  ?  ($_->{name} // '')  :  $_) => 1 }   @{$tinf->{stat_fields}};
        # Дописываем в $tinf->{stat_fields} поля из $stat_fields, если их там еще нет; если уже есть - переопределяем
        for my $fld (@{$stat_fields}) {
            if ($stfnames{$fld->{name}}) {
                # Если поле уже есть в $tinf->{stat_fields}, то перезаписываем его.
                # Если для него в $tinf->{stat_fields} не было задано shlist => 0, то делаем для него shlist => 1
                $_ = { %{$fld}, shlist => 1, %{$_} }  for grep {$_->{name} eq $fld->{name}}  @{$tinf->{stat_fields}};
            } else {
                push @{$tinf->{stat_fields}}, $fld;
            }
        }

        $proj->log("norm_params done");
    }

    #Важно, чтобы обращение шло после get_base_tinf
    #иначе теряется название таблицы, если она была определена только в предке
    my $dbt  = $self->dbt; 

    #Добавляем поля из текстового формата в общий список
    if( $tinf->{'txtfields'} ){
        my @arr = grep {$_} split /\s+/, $tinf->{'txtfields'}; #Получаем название полей
        my $defmacro = 'cuttext';
        if( $tinf->{'default_field_params'} && $tinf->{'default_field_params'}{'showmacro'} ){
            $defmacro = $tinf->{'default_field_params'}{'showmacro'};
        }
        for my $nf (@arr){
            push(@{$tinf->{'fields'}}, { name => $nf, showmacro => $defmacro, });
        }
    }
    #/Добавляем поля из текстового формата в общий список

    #Проверка таблицы и динамическое подключение полей
    if($tinf->{table}){ #Если есть таблица
        #Проверка существования таблицы
        my ($tbl_db, $tbl_name) = $tinf->{table} =~ /(?:(\S+)\.)?(\S+)/; #Выделяем префикс базы перед проверкой
        my $chtbl = $dbt->List_SQL("show tables ".( $tbl_db ? " in $tbl_db " : '')." like ".$dbt->dbh->quote($tbl_name));
        #$proj->dd("show tables like ".$dbt->dbh->quote($tinf->{table}), $tbl_db, $tbl_name);
        if( $tinf->{'fix_sql_problem'} ){ #Убираем несовместимость с базой
            unless(@$chtbl){ #Создаём таблицу, если не было
                my $SQL = $self->create_sql($tinf);
                $dbt->Do_SQL($SQL);
            }else{ #Проверяем актуальность и наличие полей
                my $dsc = $dbt->List_SQL("desc ".$tinf->{table});
                my $hfld = { map { $_->{'Field'} => 1 } @$dsc };
                my @newfields = grep { ! $hfld->{ $_->{'name'} // '' } } tinf2fields($tinf);
                for my $f ( @newfields ){
                    add_table_field_sql($dbt, $tinf->{'table'}, $f);
                    #my $SQL = add_field_sql( $tinf->{'table'},  $f->{'name'} );
                    #$dbt->Do_SQL($SQL);
                }
            }
        }else{
            unless(@$chtbl){ #Вываливаемся и выводим создание нужной таблицы
                my $SQL = $self->create_sql($tinf);
                $proj->dd($dbt->{dbhname});
                $proj->dd($SQL);
                exit;
            }
        }
        if($tinf->{'logchanges'}){ #Создаём таблицу для логирования
            #Проверка существования таблицы
            my $logtable = "Log_".$tinf->{table};
            my $chtbl = $dbt->List_SQL("show tables like ".$dbt->dbh->quote($logtable));
            #if( $tinf->{'fix_sql_problem'} ){ #Убираем несовместимость с базой
            #Всегда проверяем изменения в таблице логов, так как могут быть описаны не все поля
            if( 1 ){ #Убираем несовместимость с базой
                unless(@$chtbl){ #Создаём таблицу, если не было
                    my $SQL = create_log_sql($tinf);
#$proj->dd($SQL);
                    $dbt->Do_SQL($SQL);
                }else{ #Проверяем актуальность и наличие полей
                    my $dsc = $dbt->List_SQL("desc ".$logtable);
                    my $hfld = { map { $_->{'Field'} => 1 } @$dsc };
#$proj->dd($hfld);
                    my @newfields = 
                        grep { (! $hfld->{ 'Old_'.$_->{'name'} }) || (! $hfld->{ 'New_'.$_->{'name'} }) } 
                        grep { $_->{name} }
                        tinf2fields($tinf);
#$proj->dd(\@newfields);
#exit;
                    for my $f ( @newfields ){
                        add_table_field_sql( $dbt, $logtable, $f, ['Old_', 'New_'] );
                    }
                }
            }else{
                unless(@$chtbl){ #Вываливаемся и выводим создание нужной таблицы
                    my $SQL = create_log_sql($tinf);
                    $proj->dd($SQL);
                    exit;
                }
            }
        }

        #Для страницы просмотра логов - подключаем поля данных логов
        #Это нужно для отрисовки списка изменений
        if($tinf->{'add_log_fields'}){
            #Описание таблицы
            my $dsc = $dbt->List_SQL("desc ".$tinf->{'table'});
            my @arr = ();
            for my $f (@$dsc){
                next unless $f->{'Field'} =~ /^New_(.+)/;
                my $realfield = $1;
                push( @arr,
                    {  
                       name => 'New_'.$realfield, 
                       title => $realfield, 
                       shlist => 1, 
                       ftype => 'text', 
                       logfield => 1,
                       showmacro => 'cuttext',
                       old_field => { 
                           name => 'Old_'.$realfield,
                           title => $realfield,
                           shlist => 1,
                           ftype => 'text',
                           logfield => 1,
                           showmacro => 'cuttext',
                       }, 
                    },
                );
            } 
            push( @{$tinf->{'fields'}},
                { 
                    title => 'Изменения', shlist => 1,
                    grp => \@arr,
                    logstyle => 1,
                },
            );            
#$proj->dd(\@arr);
        }
 
        #Если нет данных о полях, берём из из базы
        unless(@{$tinf->{'fields'}}){
            #Описание таблицы
            my $dsc = $dbt->List_SQL("desc ".$tinf->{'table'});
            $tinf->{'fields'} = [ map { 
                {  name => $_->{'Field'}, title => $_->{'Field'}, shlist => 1, ftype => 'text' },
              } @$dsc ];
        }
    }
    #/Проверка таблицы и динамическое подключение полей

    #Статистические поля
    our $defparam = { 
         Shows  => { title => 'Показы', showmacro => 'format_number',   stattype => 'Shows',  },
         Clicks => { title => 'Клики',  showmacro => 'format_number',   stattype => 'Clicks', },
         Cost   => { title => 'Деньги', showmacro => 'bscost',          stattype => 'Cost',   },
         CTR    => { title => 'CTR',    showmacro => 'format_number_3', stattype => 'CTR',    },
         CPM    => { title => 'CPM',    showmacro => 'bscost',          stattype => 'CPM',    },
         CPC    => { title => 'CPC',    showmacro => 'bscost',          stattype => 'CPC',    },
    };
    our $defparamre = join('|', keys %$defparam);
    my $defshowmacro = { Shows => 'format_number', Clicks => 'format_number', Cost => 'bscost', };
    if($tinf->{ stat_fields }){

        $tinf->{default_inlinefilter_params} ||= {};
        $tinf->{default_inlinefilter_params}{$_} ||= [] for qw{group_by_add_fields complicated_add_fields fields};

        sub stfld2h { #Накладываем на статистические поля настройки
            my ($f) = @_;
            my $fh = ref($f) ? $f : { name => $f, };

            #Накладывает дефолтные значения, если они прописаны для поля
            my $defh = undef;
            my $pref = '';
            #$proj->dd($f);
            if( ($fh->{stattype} // '') =~ /(.*)($defparamre)$/i) { #Определяем, является ли это типовым полем с префиксом - используем $fh->{stattype}
                $pref = $1; #Получаем префикс stattype
                $defh = $defparam->{$2};
            } elsif( ($fh->{name} // '') =~ /(.*)($defparamre)$/i ){ #Определяем, является ли это типовым полем с префиксом - используем $fh->{name}
                $pref = $1; #Получаем префикс поля
                $defh = $defparam->{$2};
            }
            #$self->dbglog([ fh => $fh, defh => $defh ]);
            $fh->{title} //= $fh->{name}; #Если нет заголовка, добавляем
            if($defh){
                $fh->{$_} //= $defh->{$_} for keys %$defh;
            }
            $fh->{align} //= 'right'; #Если не указано иначе, прижимаем к правому краю
            $fh->{showmacro} //= 'format_number'; #Если не указано иначе, считаем всё числами
            $fh->{stgrptype} //= ''; #
            #/Накладывает дефолтные значения, если они прописаны для поля

            return $fh;
        }

        #Получаем массив префиксов у статистических данных
        my @statpref = map { s/^(.*)(shows|clicks|cost)$/$1/i; $_ } map { "$_" } grep { /(shows|clicks|cost)$/i } map { ref($_) eq 'HASH' ? $_->{name} : $_ } @{$tinf->{ stat_fields } };
        #Нужно удалить дубли, сохраняя порядок следования
        my $stff = {};
        @statpref = grep { $stff->{$_}++; ! ($stff->{$_}-1) } @statpref;
        #$proj->dd(\@statpref);
            
        my @stfields = map { stfld2h($_) } @{$tinf->{ stat_fields }}; #Превращаем массив полей в массив настроек
        #$proj->dd(\@stfields);
        my $sttypes = { map { $_->{stattype} => $_ } grep { $_->{stattype} } @stfields }; #Получаем поля, которые можно использовать для производных метрик
        my @aggrmtr = ();
#        my @aggfldlist = [
#            { name => 'CTR', stgrptype => '#Clicks#/#Shows#*100', },
#            { name => 'CPM', stgrptype => '#Cost#/#Shows#*1000', },
#            { name => 'CPC', stgrptype => 'IF(#Clicks#, #Cost#/#Clicks#, 0)', },
#        ];
        #Для каждого префикса добавляем соответствующие производные поля
        for my $prf (@statpref){ 
            for my $st ( 
                { name => "CTR", flds => [qw(Clicks Shows)], stgrptype => "#${prf}Clicks#/#${prf}Shows#*100", }, 
                { name => "CPM", flds => [qw(Cost Shows)],   stgrptype => "#${prf}Cost#/#${prf}Shows#*1000", }, 
                { name => "CPC", flds => [qw(Clicks Cost)],  stgrptype => "IF(#${prf}Clicks#, #${prf}Cost#/#${prf}Clicks#, 0)", }, 
            ) { 
                my @flds = map { ${prf} . $_ } @{$st->{flds}}; 
                next  if (scalar grep {not $_} @{$sttypes}{ @flds }) != 0; # Проверяем, что в $sttypes есть все необходимые поля 
                my $shlist = (grep {not ($_->{shlist} // 1)} @{$sttypes}{ @flds })  ?  0 : 1;    # Если для хотя бы одного из @flds указано shlist => 0, то и производное поле не будет отображаться. Если shlist для поля не задано, то считаем shlist => 1 
                push(@aggrmtr, { name => ${prf}.$st->{name}, stgrptype => $st->{stgrptype} , shlist => $shlist }); 
            } 
        }
#        push(@aggrmtr, { name => 'CTR', stgrptype => '#Clicks#/#Shows#*100', }) if $sttypes->{Shows} && $sttypes->{Clicks};
#        push(@aggrmtr, { name => 'CPM', stgrptype => '#Cost#/#Shows#*1000', }) if $sttypes->{Shows} && $sttypes->{Cost};
#        push(@aggrmtr, { name => 'CPC', stgrptype => 'IF(#Clicks#, #Cost#/#Clicks#, 0)', }) if $sttypes->{Cost} && $sttypes->{Clicks};
        push(@stfields, map { stfld2h($_) } @aggrmtr);
        
        #$proj->dd($sttypes);
        for my $fh (@stfields){
            my $rname = $fh->{name}; #Название поля в базе
            my $gfld = 'gfld'.$rname; #Название группировочного поля
            delete($fh->{name}); #Удаляем поле name, чтобы оно не конфликтовало с указанным

            #$fh->{group_by_rewrite_field} = $rname if $rname; #Поле, в которое будет переписываться значение при группировках

            #Поле для группирововк
            my $grpdfld = $fh->{stgrptype} || '#XXX#';
            $grpdfld =~ s/#XXX#/sum($rname)/g;
            $grpdfld =~ s/#$_#/$sttypes->{$_}{grpdfld}/ge for keys %$sttypes; #Заменяем поля на выражения для них
            $fh->{grpdfld} = $grpdfld;

            #Поле без группировки
            my $origfld = $fh->{stgrptype} || '#XXX#';
            $origfld =~ s/#XXX#/$rname/g;
            $origfld =~ s/#$_#/$sttypes->{$_}{origfld}/ge for keys %$sttypes; #Заменяем поля на выражения для них
            #$self->proj->dd("grpdfld: $grpdfld     origfld: $origfld ");
            $fh->{origfld} = $origfld;
            
            #Добавляем суммарное значение при группировках
            push(@{$tinf->{group_by_add_fields}}, "$grpdfld $gfld");
            #Если это сложное выражение, то добавляем его в список полей для случая без группировки
            push(@{$tinf->{complicated_add_fields}}, "$origfld $rname") if $fh->{stgrptype};
            #Правила перезаписывания группировочных полей
            $tinf->{group_by_rewrite_rules}{ $rname } = $gfld;
            #Добавляем группировочное поле
            push(@{$tinf->{default_inlinefilter_params}{fields}}, { name => $gfld, title => $fh->{title}, shlist => 1, %$fh, inlinefilter => { kvcnt => 1, }, },);
            #Если нет такого поля, добавляем его к списку полей
            push(@{$tinf->{fields}}, { extname => $rname, title => $fh->{title}, shlist => 1, %$fh, inlinefilter => { kvcnt => 1, }, },) 
                unless grep { (defined $_->{name} && $_->{name} eq $rname) || (defined $_->{extname} && $_->{extname} eq $rname) } @{$tinf->{fields}};
        }
    }
    #/Статистические поля

    #Загрузка и выгрузка данных в XLS
    if($tinf->{ data_import_export }){
        #$tinf->{bottom_buttons} ||= [];
        #push(@{$tinf->{bottom_buttons}}, { title => 'Выгрузить в XLS', url => "?cmd=$cmd&act=xls", }, ); 
        #$tinf->{bottom_actions} ||= [];
        our @dnlflds = @{$tinf->{data_import_export}{list}};
        our $tbl = $tinf->{'table'};

        #Находим нужный пункт в меню для добавления
        $tinf->{topmenu} ||= [];
        my @fileitemarr  = grep {$_->{title} eq 'Файлы'} @{$tinf->{topmenu}};
        my $menuitem = $fileitemarr[0]; #Получаем первый элемент меню с заголовком "Файлы"
        if (not $menuitem  and  not  $tinf->{data_import_export}{no_menu}){ #Если не находим такого, то создаём его, если не задан флаг no_menu
            $menuitem = { title => 'Файлы', sublist => [], };
            $tinf->{topmenu} = [ $menuitem, @{$tinf->{topmenu}} ];
        }
         
        if (not $tinf->{data_import_export}{no_import}) {
            #push(@{$tinf->{bottom_actions}},
            push( @{ $menuitem->{sublist} },
                { title => 'Залить новые данные', name => 'newdata', filefield => 'datafile', 
                    action => sub {
                        my ($self, $lst1, $lst2, $prmsh) = @_;

                        #$proj->dd($prmsh);

                        my $proj = $self->proj;
                        my $data = [];
                        if($prmsh->{'datafile_filename'} =~ /\.xlsx?$/){
                            $data = $proj->xls2arr($prmsh->{'datafile'}, $prmsh->{'datafile_filename'});

                            return unless $data && (@{$data->[0]} > 0);
                            $data = $data->[0]; #берем данные только с первой страницы 
                        }else{
                            #Ожидаем, что текстовый файл
                            $data = [ split( /\r?\n/, $prmsh->{'datafile'} ) ];
                        }

                        #$proj->dd('cc:'.@$data);

                        return unless $data && (@$data > 0);

                        my @arr = map { my $t = {}; @{$t}{ @dnlflds } = @$_; $t } map  { [ split( "\t", $_) ] } @$data;

                        if($tinf->{data_import_export}{load_prefilter}){
                            my $prf = $tinf->{data_import_export}{load_prefilter};
                            @arr = map { $prf->($self, $_) } @arr;
                        }

                        if(@arr > 2){
                            $dbt->Do_SQL("CREATE TABLE IF NOT EXISTS ${tbl}_old_data LIKE ${tbl}");
                            $dbt->Do_SQL("INSERT INTO ${tbl}_old_data SELECT * FROM ${tbl}");
                            $dbt->Do_SQL("DELETE FROM ${tbl}");
                            $proj->dbtable($tbl, undef, $dbt->{dbhname})->Add(\@arr);
                        }
                    },
                    fields => [
                        { name => "datafile", title => 'Файл', ftype => 'file', },
                    ],
                },
            );
        };

        my $url;
        if ($tinf->{data_import_export}{export}{use_grp} or $tinf->{data_import_export}{export}{filtered}) {
            $url = $ENV{REQUEST_URI};
            $url .= "&use_grp=1"  if $tinf->{data_import_export}{export}{use_grp};      # TODO нужен ли флаг use_grp ?
            $url .= "&filtered=1"  if $tinf->{data_import_export}{export}{filtered};
        } else {
            $url = '?cmd='.$cmd;
        }
        $url =~ s/&?\bact=[A-Za-z0-9_]+\b//g;
        push( @{ $menuitem->{sublist} },
            { title => 'Выгрузить в XLS', url => $url . '&act=xls' },
            { title => 'Выгрузить в TXT', url => $url . '&act=txt' },
        ); 
    }

    #Дополнительная обработка для верхнего меню
    if($tinf->{topmenu}||$tinf->{bottom_menu}||$tinf->{edittopmenu}){
        #Получаем список действий в виде массива
        my @arr = ();
        my @curarr = map {@{ $tinf->{$_} }}  grep { $tinf->{$_} } qw{ topmenu bottom_menu edittopmenu};
        while(@curarr){
            push(@arr, @curarr);
            my @nextarr = (); #Массив для дальнейшей обработки
            for my $el (@curarr){
                push(@nextarr, @{$el->{sublist}}) if $el->{sublist}; 
            }
            @curarr = @nextarr;
        }
        $tinf->{topmenu_actions} = \@arr;
        $tinf->{menu_actions} = \@arr;
        for my $el (@arr){
            $el->{type} ||= 'action' if $el->{'action'} || $el->{'redir_action'};
        }

        #Добавляем действия из меню в общий список действий
        $tinf->{spacts} ||= [];
        push(@{$tinf->{spacts}}, @{$tinf->{menu_actions}});
        #$proj->dd( \@arr );
        #/Получаем список действий в виде массива
    }

    #Маркируем сгруппированные поля
    $_->{'grp_el'} = 1 for map { $_->{'grp'} ? @{$_->{'grp'}} : () } @{$tinf->{'fields'}};

    #Список специальных полей из дополнительных действий
    $tinf->{'spec_actions_list'} = [ map { @{$_->{'fields'} || []} } @{$tinf->{'bottom_actions'} || []}  ];
    $_->{edlist} //= 1 for @{$tinf->{'spec_actions_list'}}; #Делаем все поля для специальньх действий отображаемыми

#$proj->dd($tinf->{'bottom_actions'});
#$proj->dd(map { @{$_->{'fields'} || []} } @{$tinf->{'bottom_actions'} || []});

    #Дополнительная модификация информации о полях
    #for my $f ( tinf2fields( $tinf ), (map { @{$_->{'fields'} || []} } ($tinf->{'bottom_actions'} || []))  ){
    for my $f ( 
         tinf2fields( $tinf ),  #Изменение данных полей
         @{$tinf->{'spec_actions_list'}}, #Изменение данных полей действий
    ){
        $f->{'name'} =~ s/\s+$//g  if defined $f->{'name'}; #Удаляем пробелы из названий
        if(defined $f->{'showmacro'}  &&  $f->{'showmacro'} =~ /\S\s\S/){ #Обрабатываем макросы с параметрами
            my @marr = split(/\s+/, $f->{'showmacro'});
            $f->{'showmacro'} = shift @marr;
            $f->{'showmacroprmstr'} = $f->{'showmacro'}.'('.join(',', map { "el.$_" } @marr).')';
            $f->{'showmacroprmstr'} = '[%'.$f->{'showmacroprmstr'}.'%]';
        }


        $f->{'addform'} = 1 if $f->{'forced_addform'}; #Если принудительное добавление значение из урла, то включает и простое

        #Включаем опции, необходимые для инлайновой фильтрации
        if($f->{inlinefilter}){
            $f->{addform} = 1;

            if( $f->{inlinefilter}{kvcnt} ){
                $tinf->{$_} ||= [] for qw{ group_by_add_fields complicated_add_fields }; #Проверяем, существуют ли нужные поля

                my $mdnfld = $f->{'name'} || $f->{'extname'};
                my $crntf = 'kvcnt'.$mdnfld; 

                #Проверяем, используется ли поле в запросе к базе. Если нет - не добавляем его.
                sub check_prms_for_field_using {
                    my ($fld, %prm) = @_;
                    return 1 if $prm{gfields} && ( grep {$_ eq $fld} @{$prm{gfields}} );
                    return 1 if $prm{order_by} && ($prm{order_by} eq $fld);
                    return 1 if $prm{group_by} && ($prm{group_by} eq $fld);
                    return 1 if ref($prm{filter}) && ( grep {$_ eq $fld} keys %{ $prm{filter} } );
                    return 0;
                }


                my $fnc = sub {
                    my ($self, %prm) = @_;

                    #Если поле не встречалось в запросе - ничего не делаем
                    return '' unless check_prms_for_field_using($crntf, %prm);

                    #Получаем данные для поля
                    $prm{limit} = '';
                    $prm{order_by} = $mdnfld;
                    $prm{group_by} = '' if $prm{group_by} && ( $prm{group_by} eq  $crntf); #Удаляем само поле, если по нему же идёт группировка
                    $prm{gfields} = [ $mdnfld ];
                    if($prm{filter} && (defined $prm{filter}{$crntf})){
                        my $newfilter = { %{$prm{filter}} };
                        delete($newfilter->{$crntf});
                        $prm{filter} = $newfilter;
                    }
                    my $lst = $self->dbt_list(%prm);
                    my @arr = sort { $a <=> $b } map {$_->{$mdnfld}} @$lst;

                    #Считаем пороги
                    my $cc = @arr;
                    my @mdns = @arr[ map { int( ($_ - 1) * $cc / 10 - 0.5 ) } 1 .. 10];
#$proj->dd(\@mdns);
         
                    #Формируем описание порогов для поля
                    my $msql = "0";
                    my $i = @mdns;
                    $msql = "IF( $mdnfld >= $_, '".(--$i)."0% - ".($i+1)."0%', $msql )" for @mdns;
                    return "$msql $crntf";  
                };

                push( @{$tinf->{$_}}, $fnc ) for qw{ group_by_add_fields complicated_add_fields };

                #Получаем настройки оригинального поля
                my %prntprms = map { my $t=$_; map { $_ => $t->{$_} } qw(wwshowmacro align) } grep { (defined $_->{name} && $_->{name} eq $mdnfld )||(defined $_->{extname} && $_->{extname} eq $mdnfld ) } @{$tinf->{fields}};

                push(@{$tinf->{fields}}, { name => $crntf, title => '10%', shlist => 0, addform => 1, edlist => 0, inlinefilter => { }, %prntprms },) 
                    unless grep { (defined $_->{name} && $_->{name} eq $crntf) || (defined $_->{extname} && $_->{extname} eq $crntf) } @{$tinf->{fields}};
            }

        }

        #Вариант записи хэшом приводим к массиву
        if($f->{selectlist} && (ref($f->{selectlist}) eq 'CODE')){
            $f->{selectlist} = $f->{selectlist}->($self);
        }
        if($f->{selectlist} && (ref($f->{selectlist}) eq 'HASH')){
            my @arr = map { { 'name' => $f->{'selectlist'}{$_} , 'value' => $_, } } keys %{$f->{selectlist}};
            $f->{selectlist} = \@arr;
        }

        #Фильтруем пункты правами
        if($f->{selectlist}){
            $f->{selectlist} = [ grep { $_->{rights} ? $self->check_rights($_->{rights}) : 1  } @{ $f->{selectlist} } ];
        }


        if( $f->{'selectlist'} ){
            $f->{'selectlisthash'} = { map { $_->{'value'} => $_->{'name'} } @{$f->{'selectlist'}} }; 
        }

        $f->{'title'} //= $f->{'name'} || $f->{'extname'} if (! $f->{'title'} ) && (! $f->{'grp_el'});
        #Для автоматических полей ставим правильный тип поля
        if( $f->{'autoedit'} ){
            $f->{'ftype'} = 'view';
            $f->{'edlist'} = 0 unless defined $f->{'edlist'};
        }
        if( $f->{'extname'} ){
            $f->{'name'} = $f->{'extname'};
            #$f->{'title'} //= $f->{'extname'};
            $f->{'edlist'} //= 0;
        }

        if( $f->{'typeaheadfield'} ){
            $f->{'edlist'} = 1;
            $f->{'shlist'} = 1;
            $f->{'ftype'} = 'typeahead';
            my $field = $f->{'typeaheadfield'};
            $f->{'typeahead'} = sub {
                              my ($proj, $text, $self) = @_;
                              #return ['wwwwwwwwwwww','RRRRRRRRRRRR',];
                              my $res = $self->dbt_list( group_by => $field, gfields => [$field, 'count(*) cc'], filter => { "$field LIKE" => '%'.$text.'%', } );
                              $res = [ map { $_->{$field} } @$res ];
                              return $res; 
                          };
            #$f->{'showmacroel'} = 'show_list_inline_edit_field';
        }

        #Получение данных для отрисовки баннеров
        if( $f->{'show_campaign_inf'} ){
            my $camp_field = $f->{'show_campaign_inf'};
            $f->{'extsql'} = ['select cid '.$camp_field.', name camp_name, statusActive, autobudget, broad_match_limit, broad_match_flag from Campaigns where (cid) in (?)', [$camp_field]];
            $f->{'dbhname'} //= 'catalogia_media_dbh';
            #$f->{'title'} //= 'CampaignInf';
            $f->{'compact_grp'} //= 1;
            $f->{'shlist'} //= 1;
            $f->{'name'} //= 'camp_name'; 
            $f->{'showmacro'} //= 'cuttext';
            $f->{'grp'} = [
                     { title => 'Активна', name => 'statusActive', shlist => 1, },
                     { title => 'Автобюджет', name => 'statusActive', shlist => 1, },
                     { title => 'ДРФ', name => 'broad_match_flag', shlist => 1, },
                     { title => 'ДРФ limit', name => 'broad_match_limit', shlist => 1, },
                 ];
        }
        if( $f->{'show_banner_inf'} ){
            $f->{'fieldmacro'} = 'banner_field '.$f->{'show_banner_inf'};
        }
        if( $f->{'show_banner_current_categs'} ){
            $f->{'fieldmacro'} = 'banner_current_categs_showinf';
        }
        if( $f->{'manual_category'} ){
            $f->{'edlist'} = 1;
            $f->{'shlist'} = 1;
            $f->{'ftype'} = 'typeahead';
            $f->{'typeahead'} = sub {
                              my ($proj, $text) = @_;
                              my $list = $proj->search_categs($text, $proj->viewoptions->{lang});
                              return [ map { $_->{'CategoryName'} } @$list ];
                              #return ['aaaaaa', 'bbbbbb'] 
                          };
            $f->{'showmacroel'} = 'show_list_inline_edit_field';
        }
        if( $f->{'show_banner_saved_inf'} ){
            my $ctgfield = $f->{'show_banner_saved_inf'};
            $f->{'deserial'} = $ctgfield;
            $f->{'fieldmacro'} ='banner_field_showinf';
        }
        if( $f->{'show_banner_saved_categs'} ){
            my $ctgfield = $f->{'show_banner_saved_categs'};
            $f->{'multi'} = $ctgfield.'_list';
            $f->{'name'}  = $f->{'multi'};
            $f->{'title'} //= 'Categories';
            $f->{'showsubprojel'} = sub {
               my ($proj, $el, $f) = @_;
               return $proj->deserial($el->{ $ctgfield });
            };
            $f->{'shlist'} //= 1;
            $f->{'multigrp'} = [ 
                      { name => 'category', shlist => 1, ftype => 'category', showmacro => 'catname2link', }, 
                      { name => 'phrase',   shlist => 1, }, 
                  ];
        }
        if( $f->{'show_good_bad'} ){ #Переключалка плохих и хороших состояний
            my ($good, $bad, $goodvl, $badvl) = ('good', 'bad', undef, undef);
            if(ref($f->{'show_good_bad'}) eq 'ARRAY'){
                ($good, $bad) = @{$f->{'show_good_bad'}};
            }else{
                ($good, $bad) = split '/', $f->{'show_good_bad'} if $f->{'show_good_bad'} =~ /\//;
            }
            $goodvl //= '';
            $badvl  //= 'bad';
            $f->{gb} = { good => $good, goodvl => $goodvl, bad => $bad, badvl => $badvl, };
            $f->{fieldmacro} = 'good_bad';
#=h
            $f->{'ftype'} = 'select';
            $f->{'dbtype'} = "varchar(40) NOT NULL DEFAULT ''";
            $f->{'width'} = 70;
            $f->{'selectlist'} = [
                          { name => $good,      value => '',   default => 1,  color => '#00FF00', },
                          { name => $bad,       value => 'bad', color => '#cd261b', textcolor => '#FFFFFF', },
                      ];
            $f->{'inline'}  = 1;
            $f->{'edlist'}  = 1;
#=cut
        }
        if( $f->{'show_good_bad_readonly'} ){ #Переключалка плохих и хороших состояний
            my ($good, $bad, $goodvl, $badvl) = ('good', 'bad', undef, undef);
            if(ref($f->{'show_good_bad_readonly'}) eq 'ARRAY'){
                ($good, $bad, $goodvl, $badvl) = @{$f->{'show_good_bad_readonly'}};
            }else{
                ($good, $bad, $goodvl, $badvl) = split '/', $f->{'show_good_bad_readonly'} if $f->{'show_good_bad_readonly'} =~ /\//;
            }
            $goodvl //= '';
            $badvl  //= 'bad';
            $f->{gb} = { good => $good, goodvl => $goodvl, bad => $bad, badvl => $badvl, };
            $f->{fieldmacro} = 'good_bad_readonly';
        }

        if( $f->{'fieldmacro'} ){
            $f->{'fieldmacros'} ||= [];
            push( @{$f->{'fieldmacros'}}, $f->{'fieldmacro'}, );
        }

        #Макросы для описания полей
        if( $f->{'fieldmacros'} ){
            for my $mcr (@{$f->{'fieldmacros'}}){
                my ($fldmcr, @prms) = split(/\s+/, $f->{'fieldmacro'});
                if( $self->prt_fld->{$fldmcr} ){
                    my @lst = $self->prt_fld->{$fldmcr}->($proj, $f, \@prms );
                    for my $nwh (@lst){
                        $f->{$_} //= $nwh->{$_} for keys %$nwh;
                    }
                }
            }
        }

        #Прописываем урлы для полей typeahead
        if( $f->{'typeahead'} ){
            $f->{'typeaheadurl'} = '?cmd='.$cmd."&act=typeahead_".$f->{'name'}."&viewoptionsstr=".$proj->_join_viewoptions($proj->viewoptions)."&text=" unless defined $f->{'typeaheadurl'};
        }
        if( (! $tinf->{'readonly'}) && (! $f->{'showmacroel'} ) ){ #Если указан адрес, убираем ссылку на редактирование
            $f->{'editlink'} = 1 unless defined $f->{'editlink'};
        }
        if($f->{'inline'}){
            if(($f->{ftype} // '') eq 'select'){
                $f->{showmacroel} //= 'show_list_inline_select_field';
            }elsif (($f->{ftype} // '') eq 'dropdown'){
                $f->{showmacroel} //= 'show_drop_down_list_inline_edit_field';
            }elsif (($f->{ftype} // '') eq 'radio'){
                $f->{showmacroel} //= 'show_radio_list_inline_edit_field';
            }else{
                $f->{showmacroel} //= 'show_list_inline_edit_field';
            }
        } 

        #Регистрируем специальное редактирование полей
        if( $f->{exteditfld} ){
            $tinf->{exteditfld}{ $f->{name} || $f->{extname} } = $f->{exteditfld};
        }
    }
    #/Дополнительная модификация информации о полях

    #Модифицируем фильтры
    if($tinf->{filters}){
        for my $flt ( @{$tinf->{filters}} ){
            #$flt->{list} = 1 if $flt->{multi};
        }
    }
    #/Модифицируем фильтры

    #Накладываем дефолтные значения для полей
    if($tinf->{default_field_params}){
        my $dp = $tinf->{default_field_params};
        for my $f (@{$tinf->{'fields'}}){
            for my $k (keys %$dp){
                $f->{$k} = $dp->{$k} unless defined $f->{$k};
            }
        }
    }

    #Все поля изначально редактируемые
    for my $f (@{$tinf->{fields}}){
        $f->{'edlist'} = 1 unless defined $f->{'edlist'};
    }

    #Авторизация для данных
    if(defined $tinf->{auth} && $tinf->{auth} eq 'login'){
        my $lf = { name => 'Login', shlist => 0, disable_edit => 1, autoedit => sub { my ($proj) = @_; return $proj->{login} }, };
        my $df = { name => 'create_date',  shlist => 0, disable_edit => 1, autoedit => sub { $proj->dates->cur_date('db_time') }, showmacro => 'space2nbsp', };
        push(@{$tinf->{fields}}, $lf, $df);
    }

    #Дополнительная логика настроек

    # show_del - кнопка удаления
    # show_add - кнопка добавления
    # show_inlineadd - форма добавления перед списком
    # show_compact_inlineadd - спрятанная форма добавления перед списком
    # onclick - реакция на клик по строке
    unless(defined $tinf->{'show_compact_inline_add'}){
        $tinf->{'show_compact_inline_add'} = 1 if $tinf->{compact_inline_add};
    }
    unless(defined $tinf->{'show_inline_add'}){
        $tinf->{'show_inline_add'} = 1 if $tinf->{inline_add};
        $tinf->{'show_inline_add'} = 0 if $tinf->{compact_inline_add};
    }
    unless(defined $tinf->{'show_add'}){
        $tinf->{'show_add'} = 1 unless $tinf->{readonly};
        $tinf->{'show_add'} = 0 if $tinf->{'show_inline_add'} || $tinf->{show_compact_inline_add};;
        $tinf->{'show_add'} = 0 if $tinf->{'disable_add'};
    }
    unless(defined $tinf->{'show_del'}){ 
        $tinf->{'show_del'} = 1 unless $tinf->{readonly};
        $tinf->{'show_del'} = 0 if $tinf->{'disable_del'};
    }
    unless(defined $tinf->{'disable_del'}){ 
        $tinf->{'disable_del'} = 1 if ! $tinf->{'show_del'};
    }
    unless(defined $tinf->{'show_search'}){ 
        $tinf->{'show_search'} = 1 if $tinf->{search} || $tinf->{filters};
    }
    unless(defined $tinf->{'show_title_list_br'}){
        $tinf->{'show_title_list_br'} = 1 unless 
            $tinf->{'show_inline_add'} || $tinf->{show_compact_inline_add}
            || $tinf->{'show_add'} || $tinf->{'show_search'};
    }
    unless(defined $tinf->{'onclick'}){ 
        $tinf->{'onclick'} = 'show';
        if(! $tinf->{'readonly'}){
            $tinf->{'onclick'} = 'edit';
            $tinf->{'onclick'} = 'inline_edit' if $tinf->{'inline_edit'};
        }
    }

    if( $tinf->{'pager'} ){
        $tinf->{'pager'}{'name'} ||= 'p'; #Дефолтное название поля листалки
    }    

    #Изменение порядка полей
    my %fldind = map { $_->{name} => 1 }  grep { $_->{name} }  @{$tinf->{'fields'}}; #Индекс названий полей
    my @after_fields = grep { $_->{'after'} && $fldind{ $_->{'after'} }} @{$tinf->{'fields'}}; #Поля, которые долны поменять порядок
    my @before_fields = grep { $_->{'before'} && $fldind{ $_->{'before'} }} @{$tinf->{'fields'}}; #Поля, которые долны поменять порядок
    if(@after_fields || @before_fields){ #Есть поля, которые нужно переставить
        my @other_fields = grep { 
                ! ( $_->{'after'} && $fldind{ $_->{'after'} }) 
                && ! ( $_->{'before'} && $fldind{ $_->{'before'} }) 
            } @{$tinf->{'fields'}}; #Поля, которые останутся на своих местах
        my %ins_aft = (); #Индекс полей для вставки
        push(@{$ins_aft{$_->{'after'}}||=[]}, $_ ) for @after_fields;   
        my %ins_bf = (); #Индекс полей для вставки
        push(@{$ins_bf{$_->{'before'}}||=[]}, $_ ) for @before_fields;   
        #$tinf->{'fields'} = [ map { $_, @{$insh{$_->{name}} || [] } } @other_fields ];
        my $sb;
        $sb = sub { my ($f) = @_; return ( 
               (map { $sb->($_) } @{$ins_bf{$f->{name}} || []}), 
               $f, 
               (map { $sb->($_) } @{$ins_aft{$f->{name}} || []}) 
             ) 
        };
        $tinf->{'fields'} = [ map { $sb->($_) } @other_fields ];
    }

    #Проверяем применен ли фильтр dblist_fldorder_mode. Если применен, расставляем поля в нужном порядке.
    if (my $selected_order_name =  $proj->form->{flt_dblist_fldorder_mode}) {

        my $selected_orders = [grep {$_->{name} eq $selected_order_name} @{$tinf->{fld_orders}->{orders}}];

        my $fields_for_view;
        if ($selected_orders) {
            if (scalar @{$selected_orders} == 1) {
                $fields_for_view = $selected_orders->[0]->{order};
            }
        }

        if (defined $fields_for_view) {

            #Перезаписываем поля в хеш, чтобы удобнее искать
            my %names2fields;
            for my $field (@{$tinf->{fields}}) {
                my $name = $field->{name} // $field->{extname};
                $names2fields{$name} = $field if $name;
            }

            #Создаем список полей, которые мы будем отображать, нужно чтобы избавляться от повторов и полей, которых нет в таблице.
            #Также создаем хеш с именами полей для отображения, чтобы удобнее проверять те поля, которые отображать не нужно.
            my $new_fields = [];
            my %names_for_view;
            for my $name (@{$fields_for_view}) {
                next if exists $names_for_view{$name}; # Пропускаем повторы
                next unless exists $names2fields{$name}; # Пропускаем поля, которых нет в $tinf->{fields}
                push @{$new_fields}, $names2fields{$name};
                $names_for_view{$name} = 1;
            }

            #Добавляем поля, которые не отображаем
            for my $field (@{$tinf->{fields}}) {
                my $field_name = $field->{name} // $field->{extname};

                if (($field_name) and (! $names_for_view{$field_name})) {
                    $field->{shlist} = 0;
                    $field->{fldslcthide} = 1;
                    push @{$new_fields}, $field;
                }
            }

            $tinf->{'fields'} = $new_fields;
        }
    }

    #Список с последующей фильтрацией - пишем соответствующий getlist
    if($tinf->{'getlistflt'}){
        $tinf->{'getlist'} = sub {
            my ($self, %prm) = @_;
            my $list = $self->getlistflt(%prm); #Получаем список
            return prm_list_filter($list, \%prm); #Фильтруем список
        };
    } 

    #Замена части полей на значения из настроек
    if($tinf->{extparams}){
        our $extp = $tinf->{extparams};
        our $re = join '|', %$extp;
        sub extp_repl { my ($t) = @_; $t =~ s/($re)/$extp->{$1}/ge; return $t; } #Замена значений по хэшу параметров
        if($tinf->{fields}){
            for my $f (@{$tinf->{fields}}){
                if($f->{extsql}){ #Внешний SQL с заменой параметров в нём
                    $f->{extsql}[0] = extp_repl($f->{extsql}[0]);
                }
            }
        }
        if($tinf->{extlists}){
            $_->{cmd} =  extp_repl($_->{cmd}) for grep { $_->{'cmd'} } @{$tinf->{extlists}};
        }
    }

    $self->{'tinf'} = $tinf;

    $self->dbglog($self->{'tinf'}) if $self->dbg;

    #Обработка формата прав
    if($tinf->{rights}){ #Права на вызов
        $tinf->{rights} = $self->rights2hash($tinf->{rights}); #Приводим права к стандартному виду
    }
    my @fields = tinf2fields($tinf);
    for my $f ( grep { $_->{rights} } @fields){ #Права на поля
        $f->{rights} = $self->rights2hash($f->{rights});
    }
    for my $tp (qw{ filters bottom_buttons bottom_actions bottom_views top_views }){
        if($tinf->{$tp}){ #Права на фильтры
            for my $flt ( grep { $_->{rights} } @{$tinf->{$tp}} ){
                $flt->{rights} = $self->rights2hash($flt->{rights});
            }
        }
    }
    #/Обработка формата прав


    return $self->{'tinf'};
}

sub dbhname {
    my ($self) = @_;
    my $tinf = $self->vars->{'tinf'};
    return $tinf->{'dbhname'} if $tinf->{'dbhname'};
    if($tinf->{'extdbhname'}){
        my $dbhname = $self->form->{$tinf->{'extdbhname'}};
        return $dbhname if $dbhname;
    }
    return undef; 
}

#Нужна только для работы с кэшированием данных
#Сбрасывает настроки таблицы и устанавливает новую основную таблицу
sub _set_table {
    my ($self, $tblname) = @_;
    my $tinf = $self->vars->{'tinf'};
    $self->{'dbt'} = undef;
    $tinf->{'table'} = $tblname;
}

sub dbt {
    my ($self) = @_;
    return $self->{'dbt'} if $self->{'dbt'};
    my $tinf = $self->vars->{'tinf'};
    $self->{'dbt'} = $self->proj->dbtable($tinf->{'table'}, $tinf->{'idfield'}, $self->dbhname);
    return $self->{'dbt'};
}

sub dbt_log {
    my ($self) = @_;
    return $self->{'dbt_log'} if $self->{'dbt_log'};
    my $tinf = $self->vars->{'tinf'};
    $self->{'dbt_log'} = $self->proj->dbtable('Log_'.$tinf->{'table'}, undef, $tinf->{'dbhname'});
    return $self->{'dbt_log'};
}

#Получает данные из внешних таблиц
sub get_extfields_inf {
    my ($self, $list) = @_;

    my $proj = $self->proj;
    my $tinf = $self->tinf;

    #Добавляем поля, записанные SQL
    for my $f ($self->all_fields) {
        if ($f->{extsql}) {
            my ($sql, $fld) = @{$f->{extsql}};

            $fld = [ $fld ] unless ref($fld);

            #Получаем массив ключей, так как джойн может быть по нескольким полям
            my @arr = map { [@{$_}{@$fld}] } @$list; #Объединение может быть по нескольким ключам

            last unless @arr;

            for my $el (@arr) {
                s/"/\\"/g for @$el;
                $el = [ map { '"'.$_.'"' } @$el ];
            }

            my $txtlst = join(',', map { '('.join( ',', @$_ ).')' } @arr);
            $sql =~ s/\?/$txtlst/g;

            #Данные могут быть из другой базы
            my $curtbl = $f->{dbhname} ? $self->proj->dbtable(undef,undef,$f->{dbhname}) : $self->dbt;
            my $extlst = $curtbl->List_SQL($sql);

            next unless @$extlst; #

            if ($f->{multi}) {  #Ожидаем много значений
                my $h = {};
                for (@{$extlst}) {
                    my $k = join(' / ', @{$_}{@$fld});
                    $h->{$k} ||= [];
                    push( @{$h->{$k }}, $_ );
                }
                for my $el (@$list) {
                    my $k = join(' / ', @{$el}{@$fld});
                    my $nel = $h->{ $k };
                    $el->{ $f->{multi} } = $nel;
                }
            } else { #Ожидаем только одно значение и дописываем его ключи к исходному хэшу
                my $h = { map { join(' / ', @{$_}{@$fld}) => $_ } @{$extlst} };
                for my $el (@$list) {
                    my $k = join(' / ', @{$el}{@$fld});
                    my $nel = $h->{ $k };
                    $el->{$_} = $nel->{$_} for keys %$nel;
                }
            }

        }

        #Функция, которая пополняет данные произвольными полями
        if ($f->{extsub}) {
            my $extended_list = $f->{extsub}->(dclone $list);
            die "extsub returned incorrect result" if scalar(@$list) != scalar(@$extended_list);

            for my $el (@$list) {
                #Надеемся, что в $extended_list автор вернул данные в том же порядке, что были ему переданы в $list
                #Изменения данных не принимаем, только новые колонки
                %$el = (%{ shift @$extended_list }, %$el);
            }
        }

        #Распаковываем сериализованные данные
        if ($f->{deserial}) {
            my $fld = $f->{deserial};
            for my $el ( @$list ) {
                my $data = $proj->deserial($el->{$fld});
                next unless $data && (ref($data) eq 'ARRAY') && @$data;
                my $h = $data->[0];
                next unless ref($h) eq 'HASH';
                $el->{$_} = $h->{$_} for keys %$h;
            }
        }
    }

    #Список элементов, для которых нужны дополнительные данные
    my @lstid = defined $tinf->{idfield}  ?  (map { $_->{$tinf->{idfield}} } @$list)  :  ();

    return unless @lstid;       #Нет элементов

    for my $f (@{$tinf->{fields}}) {
        if ( $f->{tb} && ! $f->{'table'} ) {
            ($f->{'table'}, $f->{'using'}, $f->{'value'}) = split(' ', $f->{tb}, 3);
        }
    }

    my $exttbls = {};
    for my $f (@{$tinf->{fields}}) {
        next unless $f->{'extname'} && $f->{table} && $f->{using};
        my $kk = $f->{table}.' / '.$f->{using};
        $exttbls->{$kk} ||= [];
        push(@{ $exttbls->{$kk} }, $f);
    }

    return unless keys %$exttbls; #Нет подключений внешних таблиц

    for my $tk (keys %$exttbls) {
        my $arr = $exttbls->{$tk};
        my ($table, $using, $dbhname) = split ' / ', $tk;
        my $extdbt = $self->proj->dbtable($table, undef, $dbhname);
        my @getfields = map { $_->{'value'}.' AS '.$_->{'extname'} } @$arr;
        my $extlst = $extdbt->List2( filter => { $using => \@lstid }, group_by => $using, gfields => [ $using, @getfields ], );

        next unless @$extlst;   #
        my $h = { map { $_->{$using} => $_ } @{$extlst} };
        for my $el (@$list) {
            my $nel = $h->{ $el->{$tinf->{idfield}} };
            $el->{$_} = $nel->{$_} for keys %$nel;
        }
    }  
}

sub htmlsmbl2text {
    my ($text) = @_;
    $text =~ s/\&amp;/&/gi;
    return $text;
}


sub cache_getlistflt_tablename :CACHE {
    my ($self) = @_;
    my $cmd = $self->cmd;
    my $prf = (ref($self->tinf->{cache_getlistflt}) eq 'HASH' and $self->tinf->{cache_getlistflt}{table_prefix})  ?
            $self->tinf->{cache_getlistflt}{table_prefix}  :  '';   # Берем из tinf->{cache_getlistflt}{table_prefix}, если он определен
    my $prf_host = (split /\./, ($ENV{HTTP_HOST} // ''))[-4] // ''; # Разные таблицы для интерфейса на бетах и на продакшне
    my $table_name = join("_", "dblist", $prf_host, $cmd, $prf); # Имя таблицы, в которую кэшируем
    $table_name =~ s/\W/_/g;  # Оставляем только допустимые символы
    # TODO проверять длину строки $table_name ?
    return $table_name;
}

#Кладём кэш данных из функции getlistflt в базу
#Перегенерируем кэш данных для getlistflt в таблице в базе данных
sub cache_getlistflt {
    my ($self) = @_;

    my $proj = $self->proj;
    my $tinf = $self->tinf;
    my $cmd = $self->cmd;

    #$proj->dd('run cache_getlistflt');
   
    my $tablename = $self->cache_getlistflt_tablename; #Имя таблицы, в которую кэшируем
    my $tablenametmp = $tablename.'_tmp_'.int(10000000 * rand()); #Имя временной таблицы, не повторяется, чтобы не пересеклись параллельные запросы
    $self->_set_table($tablenametmp); #Удаляем закэшированную таблицу, если она была
    $proj->log("cache_getlistflt ...  $tablename $tablenametmp");

    #Добавляем поле с частотой, если его нет с списке полей
    #Нужно для правильного отображения иерархий (например, категорий)
    if( $tinf->{extlists_count_field} ){
        unless( grep {$_->{name} eq $tinf->{extlists_count_field}} @{$tinf->{fields}} ){
            push( @{$tinf->{fields}}, { name => $tinf->{extlists_count_field}, dbtype => 'bigint(22) NOT NULL', shlist => 0, });
        }
    }

    #Получаем список активных полей (которые были добавлены в таблицу)
    my @fields = tinf2fields($tinf);
    my %fldh = map { $_ => 1 } grep { $_ } map { $_->{'name'} } @fields; #Хэш хороших полей
    if( $tinf->{idfield} and not $fldh{ $tinf->{idfield} } ){ #Если ключевое поле задано, но отсутствует в списке полей
        $fldh{ $tinf->{idfield} } = 1;
        my $idh = { shlist => 0, name => $tinf->{idfield}, }; #Хэш настроек для ключевого поля
        unshift(@{$tinf->{fields}||=[]}, $idh); #Нужно, чтобы поле появилось в таблице
        push(@fields, $idh); #Нужно, чтобы правильно определился тип
    }

    #Получаем массив хэшей с активными полями
    $proj->log("get list ...");
    my @list = map { my $t = $_; my $h = { map { $_ => $t->{$_} } grep {$fldh{$_}} keys %$t }; $h } #Убираем из массива хэшей все лишние ключи хэшей
#         grep {$_->{CategoryName}} #Убираем первый корневой элемент
         @{ $self->getlistflt }; #Получаем сырые данные
    $proj->log("get list done");

    if (not $tinf->{idfield}) {
        $proj->log("idfield ...");
        # Если idfield не определено, то добавляем его. Название поля не должно совпадать с существующими.
        my %keys = map { map {$_ => 1} keys %$_ }  @list; # Список ключей, которые уже есть в данных
        my $idfield = 'ID';
        $idfield .= "_"  while $keys{ $idfield }; # Приписываем "_", пока не получим подходящий ключ
        $tinf->{idfield} = $idfield;
        $fldh{ $tinf->{idfield} } = 1;
        my $idh = { shlist => 0, name => $tinf->{idfield}, dbtype => "bigint(22) NOT NULL AUTO_INCREMENT"}; #Хэш настроек для ключевого поля
        unshift(@{$tinf->{fields}||=[]}, $idh); #Нужно, чтобы поле появилось в таблице
        push(@fields, $idh); #Нужно, чтобы правильно определился тип
        $proj->log("idfield done");
    }

    #@list = grep { $_->{ParentID} eq '0' } @list;
    #@list = @list[0 .. 500];

    #$proj->dd([ grep { $_->{ParentID} eq '0' } @list ]);
    #$proj->dd([ grep { $_->{CatID} eq 'g0000' } @list ]);

    #Получаем параметры полей
    for my $f (@fields){
        my $fn = $f->{name};
        my $prm = { max => 0 };
        for my $el ( @list ){
            my $val = $el->{$fn};
            unless(defined($val)){
                $el->{$fn} = ''; #Добавляем ключ, чтобы присутстовали все поля
                next;
            }
            $prm->{d}++ if $val =~ /\d/;             
            $prm->{t}++ if $val =~ /\D/;
            my $l = length($val);
            $prm->{max} = $l if $l > $prm->{max};
        }
        next if $f->{dbtype}; #Если тип уже указан - не проверяем
        if($prm->{d} && ! $prm->{t}){
            $f->{dbtype} = 'bigint(22) NOT NULL';   
            #$f->{dbtype} = 'varchar(256)';   
        }elsif( $prm->{max} < 256 ){
            $f->{dbtype} = 'varchar('.$prm->{max}.')';
        }else{
            $f->{dbtype} = 'text default ""';
        }
#$proj->dd('DDD',$f ,  $prm);
    }
    
#    for  @list; 
   
    #$proj->dd(\@list);

    #Создание временной таблицы
    $self->dbt->Do_SQL("drop table if exists ".$tinf->{table});
    my $SQL = $self->create_sql($tinf); #Используем стандартный механизм создания таблицы
#$proj->dd($SQL, \@fields);
#exit;
    $self->dbt->Do_SQL($SQL);
    if($tinf->{default_filter} || $tinf->{add_filter}){
        my %fldtypes = map { ($_->{name} // '') => ($_->{dbtype} // '')} @{$tinf->{fields} // []};   # Типы полей для mysql
        my @fltrs = map { keys %$_ } $tinf->{default_filter}, $tinf->{add_filter};
        @fltrs = uniq map { s/^(from|to)_//; $_ } @fltrs;     #  Для фильтров типа from_EventsDate и to_EventsDate
        @fltrs = grep {$fldtypes{$_} !~ /^varchar/}  @fltrs;   # Не будем добавлять ключи для полей типа varchar
        $self->dbt->Do_SQL("alter table ".$tinf->{table}." add key (`".$_."`)") for @fltrs;
        $self->dbt->Do_SQL("alter table ".$tinf->{table}." add key (". join(',', map {"`$_`"} @fltrs )  .")") if @fltrs > 1;
    }

    #Заливаем данные в таблицу 
    $proj->log("Add ...");
    $self->dbt->Add(\@list);
    #$self->dbt->Add($_) for @list;
    $proj->log("Add done");

    $self->dbt->Do_SQL("drop table if exists $tablename");
    $self->dbt->Do_SQL("rename table $tablenametmp to $tablename");

    $self->_set_table( $tablename ); #Ставим результирующую таблицу как основную
    $proj->log("cache_getlistflt done");
}

#Проверяем, нужно ли обновлять кэш
sub cache_getlistflt_check {
    my ($self) = @_;

    my $proj = $self->proj;
    my $tinf = $self->tinf;
    my $cmd = $self->cmd;
   
    my $tablename = $self->cache_getlistflt_tablename; #Имя таблицы, в которую кэшируем
    my $lst = $self->dbt->List_SQL("SHOW TABLE STATUS LIKE '$tablename'");

    return 1 unless @$lst; #Если нет таблицы

    #Сколько прошло минут от прошлой генерации
    my $dlt = $proj->dates->delta_time($lst->[0]{Update_time}, $proj->dates->cur_date('db_time'), 'db_time', 'minutes');

    #$proj->dd("TIME $dlt");
    # Берем время из $tinf->{cache_getlistflt}{cache_time}, если оно не задано - то 10 минут
    my $dlt_max = (ref ($tinf->{cache_getlistflt}) eq 'HASH')  ?  ($tinf->{cache_getlistflt}{cache_time} // 10)  :  10;
    return 1 if $dlt > $dlt_max;

    return 0;
}

#Приводим описание прав к единому формату - хэшу
sub rights2hash {
    my ($self, $rghts) = @_;
    if(ref($rghts) eq 'HASH'){
        return $rghts;
    }elsif(ref($rghts) eq 'ARRAY'){
        return { map {$_=>1} @$rghts };
    }else{
        my @arr = grep {$_} split(/,|\s+/, $rghts);
        return { map {$_=>1} @arr };
    }
}

#Проверка прав
sub check_rights {
    my ($self, $rights) = @_;
    $rights = $self->rights2hash($rights) unless ref($rights) eq 'HASH';
    my $user_rights = $self->proj->user->rights;
    if($user_rights){
        return 1 if grep { $rights->{$_} } keys %$user_rights;
    }
    return 0; 
}

sub make {
    my ($self) = @_;

    my $proj = $self->proj;
    my $vars = $self->vars;

    my $begtime = time;

    my $tinf = $self->tinf;

    #Проверка прав
    if($tinf->{rights}){ #Права на вызов
        return '' unless $self->check_rights($tinf->{rights}); #Проверяем, есть ли права на cmd
    }
    my @fields = tinf2fields($tinf);
    for my $f ( grep { $_->{rights} } @fields){ #Права на поля
        $f->{shlist} = 0 unless $self->check_rights($f->{rights});
    }
    for my $tp (qw{ filters bottom_buttons bottom_actions bottom_views top_views }){
        if($tinf->{$tp}){ #Права на фильтры
            #Проверяем права
            $tinf->{$tp} = [ grep { (! $_->{rights} ) || $self->check_rights($_->{rights}) } @{$tinf->{$tp}} ];
        }
    }
    #/Проверка прав

    #Настройки языка
    if( $tinf->{'lang_field'} ){
        $tinf->{'add_filter'} ||= {};
        $tinf->{'add_filter'}{ $tinf->{'lang_field'} } = $proj->viewoptions->{lang}; #Добавляем фильтр с установленным языком
        #Добавляем поле, если нет
        my @fields = tinf2fields($tinf);
        push(@{$tinf->{'fields'}}, { name => $tinf->{'lang_field'}, shlist => 0, }) unless grep { ($_->{name}||$_->{extname}) eq $tinf->{'lang_field'} } @fields;
    }

    #Кэшируем данные getlistflt в таблице, если выбрана опция
    if( $tinf->{'cache_getlistflt'} && $tinf->{'getlistflt'} ){
         $self->cache_getlistflt if $self->cache_getlistflt_check; 
         $self->_set_table( $self->cache_getlistflt_tablename );
    }

    my $form = $self->form;
    my $dbt = $self->dbt;

    my $cmd = $self->cmd;
    my $act = $self->act;
    my $id = $form->{'id'} || '-1';
    my $ids = $form->{'ids'} // '';


    #Получаем дополнительные опции отображения, если есть
    my $optname = 'viewdblistoptsstr'; 
    my $vopts = {};
    my $optnamestr = $form->{$optname} || '';
    if( $optnamestr ){
        $optnamestr =~ s/[^-_A-Za-z0-9;,\|]//g; #Удаляем потенциально опасные символы, оставляем только допустимые
        $vopts = $proj->_parse_viewoptions($optnamestr);
        $vars->{$optname} = $form->{$optname};
        $vars->{viewdblistopts} = $vopts;
        #$proj->dd($vopts);

        if($vopts->{charts}){ #Сортировка
#            $tinf->{'group_by'} .= ',' if $tinf->{'group_by'};
#            $tinf->{'group_by'} .= $tinf->{'charts'}{'date_field'};
#            $tinf->{'order_by'} = $tinf->{'charts'}{'date_field'};
             #$vopts->{'grpd'} = $tinf->{'charts'}{'date_field'};
             $vopts->{'grpslct'} = $tinf->{'charts'}{'date_field'};
             $vopts->{'grpslct'} .= ','.$tinf->{'charts'}{'split_field'}; 
             $tinf->{'order_by'} = $tinf->{'charts'}{'date_field'};
        }

        #Выбиралка полей
        if($vopts->{'fldslct'}){ #Включение и отключение показа полей
            my $slflds = $vopts->{'fldslct'};
            #$proj->dd($slflds);
            $slflds =~ s/;/,/g;  

            my $slfldh = { map { $_ => 1 } split(',', $slflds) };

            #$proj->dd($slfldh);
            if(keys %$slfldh){
                for my $ff ( grep {$_->{name} || $_->{extname}} @{$tinf->{'fields'}} ){
                    $ff->{hide_by_fldslct} = 1 if $ff->{shlist} && !$slfldh->{$ff->{name} || $ff->{extname}};
                    $ff->{shlist} = $slfldh->{$ff->{name} || $ff->{extname}} ? 1 : 0;
                }
            }
        }

        #Если есть выбиралка полей, то заполняем включенные поля
        if($tinf->{fldselection}){
            my $curactive = {};
            for my $ff ( grep {  $_->{shlist} } @{$tinf->{'fields'}} ){
                $curactive->{$ff->{name} || $ff->{extname}} = 1;
            }
            $vars->{'fldslct_curactive'} = $curactive;
        }

        my $showspecgrpfields = ''; #Показывать ли дополнительные поля при группировке, значение - группировочное поле

        #Множественная группировка полей
        if($vopts->{'grpslct'}){
            my %nform = %$form;
            #for my $flt (grep { /^flt_/ } keys %{$form->{__arrayref} // {}}) {  # Заменяем параметр вида  ('flt_FuncType' => 'footer, header, minuswords')  на  ('flt_FuncType' => ['footer','header','minuswords'])
            #    $nform{$flt} = $form->{__arrayref}{$flt}    if (scalar @{$form->{__arrayref}{$flt}} >= 2);
            #}  # TODO - ?  См. if($vopts->{grpd})
            delete($nform{$_}) for qw{ cmd __arrayref act viewoptionsstr viewoptions };
            #delete($nform{$optname});  #Сбрасываем опции отображения
            delete($nform{ $tinf->{pager}{name} || 'p' }) if $tinf->{pager}; #Сбрасываем листалку, так как это будет уже другой список

            my $grpflds = $vopts->{'grpslct'};
            $grpflds =~ s/;/,/g;

            my $grph = { map { $_ => 1 } split(',', $grpflds) };

            my $cmplfldh = $self->complicated_add_fields_hash;
            # TODO  Зачем нужен CONCAT('_' ...) ?   Сделать  "CONCAT(". join( ", '_', ", map { $cmplfldh->{$_} || $_ } split ',', $grpflds ) .")"    и убрать флаг  use_simple_grfld ?
            # kostyl:  Если стоит флаг $tinf->{use_simple_grfld}, то объединяем поля через '_'
            my $grfld = $tinf->{use_simple_grfld}  ? 
                      "CONCAT(". join( ", '_', ", map { $cmplfldh->{$_} || $_ } split ',', $grpflds ) .")"
                    : "CONCAT('_', ". join( ',', map { $cmplfldh->{$_} || $_ } split ',', $grpflds ).')';
#            my $grfld = "grpslct_count";
            #Добавляем объединённое поле, так как по нему будет и группировка, и фильтрация подсписков
            push(@{ $tinf->{group_by_add_fields} ||= [] }, "count(*) grpslct_count", "$grfld grpslct_fld", );
            #push(@{ $tinf->{fields} ||= [] }, 
            #    { name => "grpslct_fld", title => 'Count', shlist => 0, addform => 1, },
            #);

#            push(@{ $tinf->{fields} }, 
#                { name => "grpslct", title => 'Count', shlist => 0, inlinefilter => { }, showmacro => 'format_number', align => 'right', },
#            );

            if($form->{'grpslctlist'}){ #Не группировать, так как это отражение подсписка
                $tinf->{add_filter} ||= {};
                $tinf->{add_filter}{$grfld} = $form->{grpslct_fld};
                $vopts->{sort} = '' if $vopts->{sort} eq 'grpslct_count'; #Сбрасываем сортировку по полю частоты сгруппированной выборки
                $vopts->{sort} = '' if $vopts->{sort} =~ /^gfld'/; #Сбрасываем сортировку по группировочным полям
            }else{
                $tinf->{'group_by'} = $grfld; #Включаем группировку по полю
                $tinf->{'idfield'}  = 'grpslct_fld'; #Делаем группировочное поле основным
 
                $tinf->{'disable_del'} = 1; #Отключаем отображение удаления строк для группировок
 
                #$showspecgrpfields = $grfld;
 
                #Прячем другие поля
                for my $ff ( grep {!( $grph->{$_->{name}} || $grph->{$_->{extname}} )} @{$tinf->{'fields'}} ){
                    $ff->{hide_by_grpslct} = 1 if $ff->{shlist};
                    $ff->{shlist} = 0;
                }
 
                #Включаем отображение дополнительной информации по группировке
                if(1){ #Всегда подключаем количество элементов при группировке
                    #Добавляем агрегированные значения для группировочного поля
                    push(@{ $tinf->{group_by_add_fields} ||= [] }, "count(*) grpslct_count", );
                    push(@{ $tinf->{fields} ||= [] }, 
                        { name => "grpslct_count", title => 'Count', shlist => 1, inlinefilter => { }, showmacro => 'format_number', align => 'right', },
                    );
                }
 
                #Добавляем раскрытие списка
                $tinf->{'extlists'} = []; #Отключаем другие вложенные списки
                $nform{grpslctlist} = 1; #Ставим флаг, что это будет список, а не группировка
                push( @{ $tinf->{'extlists'} }, { cmd => $cmd, using => 'grpslct_fld', addparams => \%nform, });
                #$proj->dd($tinf->{'extlists'});

                #Добавляем дополнительные настройки
                my $inflopts = $tinf->{default_inlinefilter_params} || {};
                #$proj->dd($inflopts);
                if($inflopts->{group_by_add_fields}){
                    $tinf->{group_by_add_fields} ||= [];
                    push( @{$tinf->{group_by_add_fields}},  @{$inflopts->{group_by_add_fields}});
                }
                if($inflopts->{'fields'}){
                    push(@{$tinf->{'fields'}}, @{$inflopts->{'fields'}});
                }
            }

        } 
        #/Множественная группировка полей

        #Корректируем настройки в зависимости от опций отображения
        if($vopts->{sort}){ #Сортировка
            $tinf->{'order_by'} = $vopts->{sort};
            $tinf->{'order_by'} .= ' DESC' if $vopts->{r};
        }
        if($vopts->{kvcnt}){ #Разбаваем на чанки по количеству
            my $fld = $vopts->{kvcnt};
            my $grfld = 'kvcnt'.$fld;
            #Включаем видимость для группировочного поля
            #Оно добавляется автоматически
            $_->{shlist} = 1 for grep { ($_->{name} eq $grfld)||($_->{extname} eq $grfld) } @{$tinf->{fields}};

            $showspecgrpfields = $fld;

            $vopts->{grpd}= $grfld; #Включаем группировку по полю
        }


        if($vopts->{grpd}){ #Группировка
            my $grfld = $vopts->{grpd};
            my %nform = %$form;
            for my $flt (grep { /^flt_/ } keys %{$form->{__arrayref} // {}}) {  # Заменяем параметр вида  ('flt_FuncType' => 'footer, header, minuswords')  на  ('flt_FuncType' => ['footer','header','minuswords']). Нужно для корректной работы multiselect-фильтров при группировках
                $nform{$flt} = $form->{__arrayref}{$flt}    if (scalar @{$form->{__arrayref}{$flt}} >= 2);
            }
            delete($nform{$_}) for qw{ cmd __arrayref act viewoptionsstr viewoptions };
            delete($nform{ $tinf->{pager}{name} || 'p' }) if $tinf->{pager}; #Сбрасываем листалку, так как это будет уже другой список

            if ($grfld =~ m/,/) {
                # Вложенные группировки вида   viewdblistoptsstr=grpd_Date,Domain,BannerIDs
                my $grfld_new;
                ($grfld, $grfld_new) = split /,/, $grfld, 2;
                $nform{$optname} = "grpd_$grfld_new";
            } else {
                delete($nform{$optname});  #Сбрасываем опции отображения
            }

            $tinf->{'group_by'} = $grfld; #Включаем группировку по полю
            $tinf->{'idfield'}  = $grfld; #Делаем группировочное поле основным

            $tinf->{'disable_del'} = 1; #Отключаем отображение удаления строк для группировок

            #$showspecgrpfields = $grfld;

            #Включаем отображение дополнительной информации по группировке
            if(1){ #Всегда подключаем количество элементов при группировке
                #Добавляем агрегированные значения для группировочного поля
                $tinf->{default_inlinefilter_params}{group_by_add_fields} ||= [];
                push(@{ $tinf->{default_inlinefilter_params}{group_by_add_fields} }, "count(*) grpcnt_$grfld", );
                $tinf->{default_inlinefilter_params}{fields} ||= [];
                push(@{ $tinf->{default_inlinefilter_params}{fields} }, 
                    { name => "grpcnt_$grfld",  title => 'Count', shlist => 1, inlinefilter => { }, },
                );
            }
            if($showspecgrpfields){
                my $fld = $showspecgrpfields;
 
                #Получаем настройки оригинального поля
                my %prntprms = map { my $t=$_; map { $_ => $t->{$_} } qw(showmacro align) } grep { ($_->{name} eq $fld)||($_->{extname} eq $fld) } @{$tinf->{fields}};
                #$proj->dd(\%prntprms, [  grep { ($_->{name} eq $grfld)||($_->{extname} eq $grfld) } @{$tinf->{fields}} ]);
 
                #Добавляем агрегированные значения для группировочного поля
                $tinf->{default_inlinefilter_params}{group_by_add_fields} ||= [];
                push(@{ $tinf->{default_inlinefilter_params}{group_by_add_fields} }, "MAX( $fld ) kvmax$fld", "MIN( $fld ) kvmin$fld", );
                $tinf->{default_inlinefilter_params}{fields} ||= [];
                push(@{ $tinf->{default_inlinefilter_params}{fields} }, 
                    { name => "kvmin$fld", title => 'Min',   shlist => 1, inlinefilter => { }, %prntprms }, 
                    { name => "kvmax$fld", title => 'Max',   shlist => 1, inlinefilter => { }, %prntprms }, 
                #    @{$tinf->{default_inlinefilter_params}{fields}},
                );
                #/Добавляем агрегированные значения для группировочного поля
            }
            #/Включаем отображение дополнительной информации по группировке

            for my $f (@{$tinf->{'fields'}}) {
                if( (($f->{name} // '') eq $grfld) or (($f->{extname} // '') eq $grfld) ) {
                    # Это поле, по которому группируем
                    #$f->{shlist} = 1   if $f->{shlist_if_grpd};
                    $f->{$_} = $f->{if_grpd}{$_}   for keys %{$f->{if_grpd} // {}};
                } else {
                    $f->{shlist} = 0    #Прячем другие поля
                }
            }

            #Добавляем раскрытие списка
            $tinf->{'extlists'} = []; #Отключаем другие вложенные списки
            push( @{ $tinf->{'extlists'} }, { cmd => $cmd, using => $grfld, addparams => \%nform, });
            #$proj->dd($tinf->{'extlists'});

            #Добавляем дополнительные настройки
            my $inflopts = $tinf->{default_inlinefilter_params} || {};
            #$proj->dd($inflopts);
            if($inflopts->{group_by_add_fields}){
                $tinf->{group_by_add_fields} ||= [];
                push( @{$tinf->{group_by_add_fields}},  @{$inflopts->{group_by_add_fields}});
            }
            if($inflopts->{'fields'}){
                push(@{$tinf->{'fields'}}, @{$inflopts->{'fields'}});
            }
        }

        $vars->{$optname} = $proj->_join_viewoptions($vopts).'|';
    }
    #/Получаем дополнительные опции отображения, если есть

    #Ещё раз выводим в лог после преобразований от опций отображения (группировки, сортировки  и т.д.)
    $self->dbglog($vars->{tinf}) if $self->dbg;

    #Действие по умолчанию
    unless($act){
        $act = $tinf->{default_act} || 'List';
    }

    #Список специальных обработчиков
    #Нужны для добавлений дополнительных действий, например - typeahead
    my $specacts = {};

    #Урл отображения списка
    my $listurl = "?cmd=$cmd&act=List&viewoptionsstr=" . ($form->{viewoptionsstr} // '');
    if(($form->{'liststyle'} // '') eq 'tree'){
        $listurl = "?cmd=$cmd&act=Tree&viewoptionsstr=" . ($form->{viewoptionsstr} // '');
    }

    my $ajaxlisturl = "?cmd=$cmd&act=AjaxSearch&viewoptionsstr=" . ($form->{viewoptionsstr} // '');

    $vars->{cmd} = $cmd;
    $vars->{cmd_without_underlines} = $cmd;
    $vars->{cmd_without_underlines} =~ s/_/-/g;   # для использования в viewoptionsstr (где параметры будут разделяться по знакам '_')
    $vars->{title} = ref( $tinf->{title} ) eq 'CODE' ? $tinf->{title}->() : $tinf->{title};
    $vars->{pagercc_name} = "pagercc-" . $vars->{cmd_without_underlines}; # В url в viewoptionsstr можно указывать количество элементов на странице для данного cmd, например: &viewoptionsstr=lang_ru|pagercc-direct-campaigns-lst_10

    #Обрабатываем поля перед выводом
    if($tinf->{filters}){
        for my $flt ( @{$tinf->{filters}} ){
            if( $flt->{'typeahead'} ){
                $flt->{'typeaheadurl'} = '?cmd='.$cmd."&act=typeaheadflt_".$flt->{'field'}."&viewoptionsstr=".$proj->_join_viewoptions($proj->viewoptions)."&text=" unless defined $flt->{'typeaheadurl'};
                $specacts->{'typeaheadflt_'.$flt->{'field'}} = sub { join "\n", @{$flt->{'typeahead'}->(@_)} };
            }
        }
    }
    for my $f (@{$tinf->{fields}}, @{$tinf->{spec_actions_list}}){
        #Получаем поля с дополнительными вызовами (типа typeahead)
        if( $f->{'typeahead'} ){
            $specacts->{'typeahead_'.$f->{'name'}} = sub { join "\n", @{$f->{'typeahead'}->(@_)} };
        }
        #Уникальный идентификатор для поля
        $f->{'uniq_field_id'} = substr( Digest::MD5::md5_hex( (1000000 * rand()) . ($f->{'name'} // '')), 0, 7 );  
    }

    #Прерываем работу, если дополнительное действие
    if($specacts->{$act}){
        $vars->{'_return_text'} = 1;
        $vars->{'text'} = $specacts->{$act}->($proj, $form->{'text'}, $self);
        return;
    }

    my $tree_types = {
        'dategrp' => sub { 'DATE_FORMAT('. $_[0] .',"%x%v")+0' },
        'datemnthgrp' => sub { 'LEFT('. $_[0] .', 7)' },
    };
    my $tree_macros = {
        'dategrp' => 'tree_weekel2text',
        'catid'   => 'tree_catid2caturl',
        #'catid'   => 'italictext',
    };

    #Нужно ли считать группировки для фильтров
    my $usefilters = 1;
    $usefilters = 0 if grep { $_ eq $act } qw{ Update Add Edit MassUpdate Del }; #Отключаем полйчение данных для инлайнового редактирования

    delete($tinf->{filters}) unless $usefilters; #Сбрасываем все настройки фильтрации для редактирующих действий, чтобы не считать группировки
   

    #Дополнительные фильтры, выбранные в интерфейсе
    my $addflt = {}; #Хэш дополнительной фильтрации
    my $filtersoptions = $tinf->{'default_filtersoptions'} || ''; #Строка для вставки в урлы
    my $use_tree_pager = 0; #Определяет, нужно ли переключаться на листалку для дерева
    my $dont_use_filter = {}; #Отключение фильтров

    #!!!
    #Отключаем обработку фильтров для этих вызовов
    $tinf->{filters} = [] if $act =~ /^inlacts_|^Update$/;

    #Проверяем есть ли параметр fld_ordes. Если есть, то добавляем новый фильтр, который отвечает за порядок полей
    if ($tinf->{fld_orders}) {
        my $name_filter = $tinf->{fld_orders}->{title};
        my $view_filter = {
            name => $name_filter, field => 'dblist_fldorder_mode', grp => 1, disable_deselect => 1, hide_count => 1, order_by_count => 1,
            extgrp => sub {
                my @names = map {$_->{name}} @{$tinf->{fld_orders}->{orders}};
                @names = map {{'dblist_fldorder_mode' => $_}} @names;
                return [@names];
            },
            extfilter => sub {
                my ($proj, $text) = @_;
                return {};
            },
            selectnames => { map {$_->{name} => $_->{title} } @{$tinf->{fld_orders}->{orders}}},
        };
        unshift @{$tinf->{filters}}, $view_filter;
    }

    if( $tinf->{filters} ){
        for my $ff (@{$tinf->{filters}}){
            next if not defined $ff->{'field'};   #  Например, фильтр с cmdslc    { name => 'mode',  cmdslc => { 'Last values' => 'monitor_indicators_last', 'Set time range' => 'monitor_indicators_range', }, }

            #Находим соответствующее фильтру поле
            my @fldarr = grep { $ff->{'field'} eq $_->{'name'} }  grep { $_->{name} }  @{$tinf->{fields}};
            if(@fldarr){
                my $cfld = $fldarr[0]; 
                #Если выбиралка для поля типа select, то получаем названия значений
                if($cfld->{'selectlist'}){
                    my $hk = { map { $_->{'value'} => $_->{'name'} } @{$cfld->{'selectlist'}} };
                    $ff->{'selectnames'} = $hk;
                }
            }
            #/Находим соответствующее фильтру поле


            #my $fval = $form->{'flt_'.$ff->{field}};
            #Обрабатываем значения
            my $fval = undef;
            if( $ff->{multi} ){
                $fval = join(';', @{$form->getfldlist('flt_'.$ff->{field})} ) if defined( $form->getlast('flt_'.$ff->{field}) );
            }else{
                $fval = $form->getlast('flt_'.$ff->{field});
            }
            
            #Не нужно использовать фильтр
            $dont_use_filter->{$ff->{field}} = ((defined $fval && $fval =~ /^     $/) ? 1 : 0);

            #Фильтр использовать не нужно, но прокинуть этот параметр дальше имеет смысл
            if($dont_use_filter->{$ff->{field}}){
                $filtersoptions .= '&'.'flt_'.$ff->{field}.'=+++++';
            }

            my $defval = undef;
            $defval = $tinf->{default_filter}->{$ff->{field}} if defined $tinf->{default_filter}->{$ff->{field}};
            if($vopts->{charts} && $tinf->{charts} && $tinf->{charts}{default_filter}){ #Дефолтное значение для графиков
                $defval = $tinf->{charts}{default_filter}->{$ff->{field}};
            }

            $fval //= $defval if (defined $defval) && ! $dont_use_filter->{$ff->{field}};
            $fval =~ s/^\s+|\s+$//g   if ($ff->{ignore_boundary_spaces});   # Удаляем пробелы в начале и в конце 
            if( defined( $fval ) && ! $dont_use_filter->{$ff->{field}} ){
                if( ( $ff->{grp} || ( defined($defval) ) ) #Для сгруппированных фильтров
                    || ($fval && !$ff->{grp})                              #Для текстовых фильтров
                    ){
                    if($ff->{'extfilter'}){
                        my $nf = $ff->{'extfilter'}->($proj, $fval);
                        $addflt->{$_} = $nf->{$_} for keys %$nf;
                    }else{
                        if($ff->{'like'}){
                            $addflt->{$ff->{field}.' LIKE '} = '%'.$fval.'%';
                        }elsif($ff->{'multi'}){
                            my @arr = split(/\s*;\s*/, $fval);
                            @arr = ('') if $fval eq '';
                            push( @arr, '')  if $fval =~ /;$/;
                            $addflt->{$ff->{field}} = \@arr if @arr;
                        }elsif($ff->{'list'}){
                            my @arr = split(/\s*,\s*/, $fval);
                            $addflt->{$ff->{field}} = \@arr;
                        }else{
                            $addflt->{$ff->{field}} = $fval;
                        }
                    }
                    #$proj->dd($addflt, $fval, [split(/\s*;\s*/, $fval)], split(/\s*;\s*/, ''));
                    $ff->{'curval'} = $fval;
                    $ff->{'curval_defined'} = 1;
                    $filtersoptions .= '&flt_'.$ff->{field}.'='.uri_escape_utf8($fval);
                }
            }

            #Обрабатываем значения больше
            my $fvalfrom = $form->getlast('flt_from_'.$ff->{field});
            $fvalfrom ||= $tinf->{default_filter}->{'from_'.$ff->{field}};
            if( $fvalfrom ){
                $addflt->{$ff->{field}.' >= '} = $fvalfrom;
                $filtersoptions .= '&flt_from_'.$ff->{field}.'='.uri_escape_utf8($fvalfrom);
                $ff->{'curval_from'} = $fvalfrom;
                $ff->{'curval_from_defined'} = 1;
            }

            #Обрабатываем значения меньше
            my $fvalto = $form->getlast('flt_to_'.$ff->{field});
            $fvalto ||= $tinf->{default_filter}->{'to_'.$ff->{field}};
            if( $fvalto ){
                $addflt->{$ff->{field}.' <= '} = $fvalto;
                #Исправляем фильтрацию датами
                $addflt->{$ff->{field}.' <= '} = $fvalto.' 23:59:59' if $ff->{type} eq 'date2';
                $filtersoptions .= '&flt_to_'.$ff->{field}.'='.uri_escape_utf8($fvalto);
                $ff->{'curval_to'} = $fvalto;
                $ff->{'curval_to_defined'} = 1;
            }

            #Добавляем сгруппированные значения для выбора
            if($ff->{grp} && ! $ff->{use_other_filters}){
                if($ff->{extgrp}){
                    $ff->{ grplist } ||= $ff->{extgrp}->($proj, $tinf);
                }else{
                    $ff->{ grplist } ||= $self->dbt_list( filter => '', group_by => $ff->{field}, gfields => [$ff->{field}, ($ff->{textfield} ? $ff->{textfield} : ()), 'count(*) cc'] );
                }
            }
        }
    }
    #$proj->dd(filters => $tinf->{filters});

    # Параметры, которые нужно дописывать в url
    my $transmitted_url_params = '';
    if($tinf->{transmit_url_params}){
        for my $p (@{$tinf->{transmit_url_params}}){
            next if not defined $form->{$p};
            $transmitted_url_params .= '&'.$p.'='.uri_escape_utf8($form->{$p});
        }
    }

    if( $tinf->{tree} ){
        #$proj->dd('FRM:', $form);
        for my $ff (@{$tinf->{tree}{grpfields}}){
            my $fval = $form->{'trflt_'.$ff->{field}};
            #    $proj->dd('FF1:', $ff, $fval);
            #if( $fval ){
            if( defined $fval ){ #Пустое значение - тоже значение
                if($ff->{type} && $tree_types->{$ff->{type}} ){
                    $addflt->{ $tree_types->{$ff->{type}}->($ff->{field}) } = $fval;
                }else{
                    $addflt->{$ff->{prnt_field} || $ff->{field}} = $fval;
                }
                #$proj->dd('FF2:', $ff);i
                #Доклеиваем параметры фильтрации
                unless( $ff->{prnt_field} ){ #Не доклеиваем, если это рекурсивное поле
                    $filtersoptions .= '&trflt_'.$ff->{field}.'='.uri_escape($fval);
                    # TODO  для работы с кириллицей? $filtersoptions .= '&trflt_'.$ff->{field}.'='.uri_escape_utf8($fval);
                }
                $ff->{'curval'} = $fval;
                $use_tree_pager = 1;
            }
            #if($ff->{grp}){
            #    $ff->{ grplist } = $self->dbt_list( filter => '', group_by => $ff->{field}, gfields => [$ff->{field}, 'count(*) cc'] );
            #}
        }
    }
    #Фильтр по умолчанию
    if($tinf->{default_filter}){
        my $flt = $tinf->{default_filter};
        for my $df (grep {! defined $addflt->{$_}} grep { ! $dont_use_filter->{ $_ } } grep {!/^(?:from|to)_/} keys %$flt){
            $addflt->{$df} = $flt->{$df};
        }
    }
    #Фильтр по умолчанию для графиков
    if($vopts->{charts} && $tinf->{charts} && $tinf->{charts}{default_filter}){
        my $flt = $tinf->{charts}{default_filter};
        for my $df (grep {! defined $addflt->{$_}} grep { ! $dont_use_filter->{ $_ } } grep {!/^(?:from|to)_/} keys %$flt){
            $addflt->{$df} = $flt->{$df};
        }
    }
    #Фильтр принудительный
    if($tinf->{add_filter}){
        my $flt = $tinf->{add_filter};
        $addflt->{$_} = $flt->{$_} for keys %$flt;
    }
            
    #Данные о текущих значениях фильтров для шаблонов, используется для прокидывания фильтрации
    my $filters_values = $vars->{'filters_values'} ||= {};
    $filters_values->{$_} = '     ' for grep { $dont_use_filter->{$_} } keys %$dont_use_filter;
    for my $k ( keys %$addflt ){
        $filters_values->{$k} = $addflt->{$k};
    }
    #$proj->dd( $filters_values, $addflt, $form, $dont_use_filter );

    #Часть полей могут иметь дефолтные значения при вызове
    #if(($act eq 'AjaxSearch')||($act eq 'List')){
    #if(1){ #Используем это всегда
    my $addform_filter = { map { $_ => 1 } qw( Update Add Edit MassUpdate Del ) };
    if(! $addform_filter->{$act} ){ #Используем только для нередактируемых полей
        for my $f (@{$tinf->{fields}}){
            #Дефолтные значения для инлайновых добавлений            
            if(defined($f->{default}) && $f->{default} ne "" && ! defined $vars->{'data'}{$f->{'name'}} ){ #Часть полей могут иметь дефолтные значения
                $vars->{'data'}{$f->{'name'}} = $f->{default};
            }
            my $kk = $f->{'name'};
            next unless $kk;
            #my $vv = $form->{$f->{'name'}};
            my $vv = $form->getlast($f->{'name'});
            next unless defined $vv;
            if($f->{addform}){ #Часть полей могут иметь дефолтные значения при вызове
                $vv =~ s/\&quot;/"/g; #Убираем экранирование кавычек
                $addflt->{$kk} = $vv;
                $filtersoptions .= '&'.$kk.'='.uri_escape_utf8($vv);
                $f->{addformval} = $vv;
            }
            #$proj->dd($form,$f);
        }
    }

    #Сохраняем указанные значения полей даже для форм добавления и редактирования
    if($tinf->{fields} && ( grep { $act eq $_ } qw (Add Edit AjaxSearch) )){
        my $addformvals = '';
        $addformvals .= '&'.$_->{name}.'='.uri_escape_utf8( $form->getlast( $_->{name} ) ) for grep { $_->{forced_addform} && defined( $form->getlast( $_->{name} )  ) } @{ $tinf->{fields} };
        #$vars->{'addformvals'} = $addformvals; #Нужно для ссылок редактирования, добавления и возврата к списку
        $filtersoptions .= $addformvals;
    }

    
    #Для части фильтров проверяем возможные значения с использованием текущего фильтра
    if( $tinf->{filters} ){
        for my $ff (@{$tinf->{filters}}){
            #Добавляем сгруппированные значения для выбора
            if($ff->{grp} && $ff->{use_other_filters}){
                #Исключаем текущее поле из фильтра
                my $re = '^'.$ff->{field}.'( |$)';
                my $nflt = { map { $_ => $addflt->{$_} } grep { $_ !~ /$re/ } keys %$addflt };
                if($act ne 'AjaxSearch'){ #Для аякса не нужно получать значения группировок для фильтров (иначе падают группировки на вычисляемых полях)
                    if($ff->{extgrp}){
                        $ff->{ grplist } ||= $ff->{extgrp}->($proj, $tinf);
                    }else{
                        $ff->{ grplist } ||= $self->dbt_list( filter => $nflt, group_by => $ff->{field}, gfields => [$ff->{field}, 'count(*) cc'] );
                    }
                }
            }
        }
    }

    #Добавляем текущее значение фильтра (с нулевой частотой), если среди текущей группировки нет этого значения
    if( $tinf->{filters} ){
        for my $ff (@{$tinf->{filters}}){
            #Добавляем сгруппированные значения для выбора
            if($ff->{grp} && $ff->{curval_defined}){
                if( $ff->{multi} ){
                    push( @{$ff->{ grplist }}, {$ff->{field} => $_, cc => 0, }) for grep { my $cv = $_;! grep { $cv eq $_->{$ff->{field}} } @{$ff->{ grplist }} } split ';', $ff->{curval};
                }else{
                    push( @{$ff->{ grplist }}, {$ff->{field} => $ff->{curval}, cc => 0, }) unless grep { $ff->{curval} eq $_->{$ff->{field}} } @{$ff->{ grplist }};
                }
            }
        }
    }

    #Накладываем сортировку ключей и изменение названий для некоторых фильтров 
    if( $tinf->{filters} ){
        for my $ff (@{$tinf->{filters}}){
            $ff->{ grplist } = [ sort { $b->{cc} <=> $a->{cc} } @{$ff->{ grplist }} ] if $ff->{order_by_count} && $ff->{ grplist };
            if( $ff->{textmacro} ){ #Важно делать замену названий до сортировки
                 $ff->{textfield} = 'textmacrofield';
                 for my $e (@{$ff->{ grplist }}){
                     $e->{'textmacrofield'} = $ff->{textmacro}($proj, $e->{ $ff->{field} });
                 }
            } 
            if( (! $ff->{order_by_count} )  && $ff->{ grplist } ){ #Если не было ортировки по частоте, сортируем по алфавиту
                my $fld = $ff->{textfield} || $ff->{field};
                $ff->{ grplist } = [ sort { $a->{ $fld } cmp $b->{ $fld } } @{$ff->{ grplist }} ];
            }
        }
    }

    #Формируем урлы для кнопок
    #Модификация урлов для кнопок под списком и контекстного меню
    if($tinf->{bottom_buttons} || $tinf->{menu_actions}){
        for my $btn ( map { @{ $tinf->{$_} } } grep { $tinf->{$_} } qw{ menu_actions bottom_buttons }){
            if ($btn->{url}) {
                $btn->{url} .= $transmitted_url_params;
            }
            if($btn->{addformparams} && $btn->{url}){
                $btn->{url} .= '&'.$_.'='.$form->{$btn->{addformparams}{$_}} for keys %{$btn->{addformparams}}; 
            }
            if($btn->{addfilters} && $btn->{url}){
                $btn->{url} .= $filtersoptions;
            }
            if($btn->{add_prm} && $btn->{url}){
                # Удаляем из url предыдущие значения параметров и дописываем заданные в add_prm   TODO переименовать названия опций?
                for my $key (sort keys %{ $btn->{add_prm} || {} }) {
                    $btn->{url} =~ s/&$key=[^&]*//g;
                    $btn->{url} .= "&$key=" . $btn->{add_prm}{$key};
                }
            }
        }
    }

    #Eсли было полe dirid, то сохраняем его, так как это используется во вложенных листалках
    if($form->{'dirid'}){
        my @arr = reverse split ',', $form->{'dirid'};
        my $dirid = shift @arr;
        $dirid =~ s/\s//g;
        $filtersoptions .= '&dirid='.$dirid;
        $vars->{'dirid'} = $dirid;
        $vars->{'prntdirid'} = $dirid;
    }

    #Если параметр базы берётся извне, сохраняем его для остальных запросов
    if( $tinf->{extdbhname} ){
        $filtersoptions .= '&'.$tinf->{extdbhname}.'='.$self->dbhname;
        $tinf->{extdbhname_curvalue} = $self->dbhname;
    }

    # Доклеиваем в url специальные параметры
    for my $key (qw( debug sqldebug )) {
        $listurl .= "&$key=$form->{$key}"   if defined $form->{$key};
    }

#$proj->dd($addflt, $form);
    $vars->{'filtersoptions'} = $filtersoptions . $transmitted_url_params; #Строка для вставки в урлы
    $listurl .= $filtersoptions . $transmitted_url_params; #Доклеиваем пользовательский фильтр
    $ajaxlisturl .= $filtersoptions . $transmitted_url_params; #Доклеиваем пользовательский фильтр
#    $ajaxlisturl .= '&viewdblistoptsstr='.$vars->{$optname} if $vars->{$optname}; #Доклеиваем настройки отображения
#$proj->dd([$ajaxlisturl, $filtersoptions]);

    
    $vars->{listurl} = $listurl;
    $vars->{ajaxlisturl} = $ajaxlisturl;

    if($act eq 'Edit'){ #Редактирование элемента
        $proj->do_redirect($listurl) if $tinf->{readonlytable}; #Только если разрешено редактирование
        $_->{edlist} = 0 for grep {$_->{disable_edit}} @{$tinf->{fields}}; #Отключаем часть полей
        my $h = $self->fields2hash('Edit');
        $self->add_log_inf($id, $h) if $tinf->{'logchanges'};
        $self->dtact_edit($id, $h);
        if( $tinf->{'keep_edit_form_after_saving'} ){
            my $editformurl = "?cmd=$cmd&act=EditForm&id=$id&viewoptionsstr=" . ($form->{viewoptionsstr} // '');
            $proj->do_redirect($editformurl);
        }
        $proj->do_redirect($tinf->{redir_url_after_add_and_edit_actions}) if $tinf->{redir_url_after_add_and_edit_actions};
        $proj->do_redirect($listurl);
    }elsif($act eq 'Update'){ #Меняем только те поля, которые пришли в форме
        $proj->do_redirect($listurl) if $tinf->{readonlytable}; #Только если разрешено редактирование
        my $h = $self->fields2hash('Update', 1);
        $self->add_log_inf($id, $h) if $tinf->{'logchanges'};
        $self->dtact_edit($id, $h);
        #$proj->do_redirect($listurl);     
        $proj->do_redirect('?cmd=ok'); #Так как это поле не используется без аякса     
    }elsif($act eq 'MassUpdate'){ #Меняем только те поля, которые пришли в форме
        $proj->do_redirect($listurl) if $tinf->{readonlytable}; #Только если разрешено редактирование
        my $h = $self->fields2hash('MassUpdate', 1);
        my @arr = split / \/n\/ /, $ids;
        for my $k (keys %$h){
            $h->{$k} = [split / \/n\/ /, $h->{$k}];
        }
        my @chres = ();
        for my $i (0 .. (@arr-1)){
            my $id = $arr[$i];
            my $curh = { map { $_ => $h->{$_}[$i] } keys %$h };
            push(@chres, [ $id, $curh ]);
            #$self->add_log_inf($id, $curh) if $tinf->{'logchanges'};
            #$self->dtact_edit($id, $curh);
            #$self->proj->dd([$id, $curh]);
        }
        $self->dtact_multiedit(\@chres);
        if( $tinf->{'logchanges'} ){
            for my $l (@chres){
                my ($id, $h) = @$l;
                $self->add_log_inf($id, $h);
            }
        }
        $proj->do_redirect('?cmd=ok'); #Так как это поле не используется без аякса     
    }elsif($act eq 'Add'){
        $proj->do_redirect($listurl) if $tinf->{readonlytable}; #Только если разрешено редактирование
        $_->{edlist} = 0 for grep {$_->{disable_add}} @{$tinf->{fields}}; #Отключаем часть полей
        my $h = $self->fields2hash('Add');
        $self->add_log_inf(undef, $h) if $tinf->{'logchanges'};
#die(Dumper($h, $form));
        if($tinf->{multi_add_by_field}){ #Добавить не один элемент, а несколько
            my ($mfld, $dlm) = @{$tinf->{multi_add_by_field}}{qw{ field delim }};
            for my $nv ( grep {$_} split /$dlm/, $h->{$mfld} ){
                my %nh = %$h;
                $nh{$mfld} = $nv;
                $self->dtact_add(\%nh);
            }
        }else{
            $self->dtact_add($h);
        }
        #$dbt->Add($h);
        $proj->do_redirect($tinf->{redir_url_after_add_and_edit_actions}) if $tinf->{redir_url_after_add_and_edit_actions};
        $proj->do_redirect($listurl);     
    }elsif($act eq 'Del'){
        $proj->do_redirect($listurl) if $tinf->{readonlytable}; #Только если разрешено редактирование
        $self->add_log_inf($id, undef) if $tinf->{'logchanges'};
        $self->dtact_del($id);
        $proj->do_redirect($listurl);     
    }elsif($act eq 'MoveElem'){
        
        $proj->do_redirect($listurl) if $tinf->{readonlytable}; #Только если разрешено редактирование

        my $pf = $form->{'prntfield'};
        $pf =~ s/['"`\.\\]//g;
        my $h = { $pf => $form->{'mvid'} };
        $self->add_log_inf($id, $h) if $tinf->{'logchanges'};
        $self->dtact_edit($id, $h);     
        $proj->do_redirect($listurl);     
    }elsif($act eq 'EditForm'){
        if ($tinf->{create_on_edit_if_not_exists}) {
            if (not defined $dbt->Get($id)) {
                $self->dtact_add({ $tinf->{idfield} => $id });   
            };   
        };

        $vars->{act} = 'Edit';
        $vars->{id} = $id;
        $vars->{data} = $self->dtact_get($id);
        $_->{edlist} = 0 for grep {$_->{disable_edit}} @{$tinf->{fields}}; #Отключаем часть полей
        $vars->{AjaxForm} = $form->{AjaxForm};
        $vars->{AjaxFormReload} = $form->{AjaxFormReload};
        $vars->{template} = 'Lists/edit.tmpl';
        $vars->{title} = ref($tinf->{edittitle}) eq 'CODE' ? $tinf->{edittitle}->($self, $vars->{data}) : $tinf->{edittitle};
    }elsif($act eq 'View'){
        if ($tinf->{create_on_view_if_not_exists}) {
            if (not defined $dbt->Get($id)) {
                $self->dtact_add({ $tinf->{idfield} => $id });   
            };   
        };

        $vars->{act} = 'View';
        $vars->{id} = $id;
        $vars->{data} = $self->dtact_get($id);
        $_->{edlist} = 0 for grep {$_->{disable_edit}} @{$tinf->{fields}}; #Отключаем часть полей
        $vars->{AjaxForm} = $form->{AjaxForm};
        $vars->{AjaxFormReload} = $form->{AjaxFormReload};
        $vars->{template} = 'Lists/view.tmpl';
    }elsif($act eq 'AddForm'){
        $vars->{act} = 'Add';
        $vars->{data} = {};
        #Если добавление через деревья, то подхватываем часть полей
        for my $ff (@{$tinf->{tree}{grpfields}}){
            if(defined $ff->{'curval'}){
                $vars->{'data'}{$ff->{'prnt_field'} || $ff->{'field'}} = $ff->{'curval'};
            }
        }
        for my $f (@{$tinf->{fields}}){
            if($f->{default} && ! defined $vars->{'data'}{$f->{'name'}} ){ #Часть полей могут иметь дефолтные значения
                $vars->{'data'}{$f->{'name'}} = $f->{default};
            }
            if($f->{addform} && $form->{$f->{'name'}}){ #Часть полей могут иметь дефолтные значения при вызове
                $vars->{'data'}{$f->{'name'}} = $form->{$f->{'name'}};
            }
            if($f->{disable_add}){
                $f->{edlist} = 0;
            }            
        }
        $vars->{AjaxForm} = $form->{AjaxForm};
        $vars->{AjaxFormReload} = $form->{AjaxFormReload};
        $vars->{template} = 'Lists/edit.tmpl'
    }elsif($act eq 'AjaxSearch'){
        my $sinf = $tinf->{search}; 
        $vars->{act} = 'AjaxSearch';
        my $search_text = $sinf->{name} ? $form->{$sinf->{name}} : undef;
        $vars->{current_search_text} = $search_text;
        my $ajaxlisturl_search_opt = '&'.$sinf->{name}.'='.uri_escape_utf8($search_text); #Фрагмент урла с параметрами поиска
        $vars->{ajaxlisturl_search_opt} = $ajaxlisturl_search_opt . $transmitted_url_params;
        $vars->{ajaxlisturl} .= $ajaxlisturl_search_opt;

        #my @arr = $sinf ? @{$sinf->{'fields'}} : ();
       # $addflt->{ 'search_hash' } = { map { "$_ LIKE" => $search_text } @{$sinf->{'fields'}} }; 

        if($search_text){
            $addflt->{ 'search_hash' } = { map { ( "$_ LIKE" => '%'.$search_text.'%' ) } @{$sinf->{'fields'}} };
        }

        my $flt = $addflt;

=h
        my $flt = '';
        if($search_text){
            $vars->{searchtext} = $search_text;
            $search_text = $dbt->dbh->quote($search_text);
            $search_text =~ s/^'|'$//g;
            $flt = join ' OR ', map { " $_ LIKE '%".$search_text."%' " } @{$sinf->{fields}};
            $flt = " ( $flt ) ";
        }
#die Dumper([$flt, $search_text, $form->{$sinf->{name}}]);

        if( keys %$addflt ){
            my $addfltstr = join( ' AND ', map { ( /LIKE|REGEXP/ ? "$_ " : $_.'=').$dbt->dbh->quote($addflt->{$_}) } keys %$addflt);
            $flt =  $flt ? " $flt AND $addfltstr " : $addfltstr;
        }
=cut

        my $prm = { filter => $flt };

        #Сортировка
        $prm->{order_by} = $tinf->{order_by} if $tinf->{order_by};

        #Определяем, рисуются ли графики или таблица
#        my $charts = $vars->{viewdblistopts}{charts};

        #Листалка
#        if(!$charts){
            my $tree_pager = $use_tree_pager && $tinf->{tree} && $tinf->{tree}{pager}; #Переключаемся ли на настройки для дерева
            if($tinf->{pager} || $tree_pager){
                my $pi = $tinf->{pager};
                $pi = $tinf->{tree}{pager} if $tree_pager; 
                my $curp = $form->{$pi->{name}} || 1;
                my $cc = $proj->viewoptions->{ $vars->{pagercc_name} } || $pi->{cc} || 50;
                my $list_count = $self->dbt_count($flt);
                $prm->{limit} = ( ($curp - 1) * $cc ).' , '.$cc;   
                $vars->{pages} = int($list_count / $cc);
                $vars->{pages}++ if $list_count % $cc;
                $vars->{curpage} = $curp;
            } 
#        } 

        #$proj->dd( $form, $addflt, $prm);

        #$dbt->{sql_dd_log} = 1;
        #$dbt->{sql_log} = 1;
        #my $list = $self->dbt_list(%$prm);
        my $list = $self->dtact_list( %$prm );
        #$proj->dd($list);
        parse_meta($tinf->{fields}, $list);
        $vars->{list} = $list;

#        if($charts){ #Отрисовываем графики
#            $list = [@{$list}[1..10]];
#            $vars->{list} = $list;
#            $vars->{template} = 'Lists/chart.tmpl';
#        }else{
            $vars->{template} = 'Lists/list_elems.tmpl';
#        }
    }elsif($act eq 'Tree'){
        my $tr = $tinf->{'tree'};

        my $treedbg = 0;

        #$proj->dd('Данные дерева', $tr) if $treedbg;
        my $bd_grpfields = [ grep { $_->{'curval'} } @{$tr->{'grpfields'}} ]; #Уже использованные поля группировки
        #Поля группировки, которые ещё не были использованы
        #Если указывалось родительское поле, то даже при текущем значении оставляем
        my $gd_grpfields = [ grep { (! $_->{'curval'}) || $_->{'prnt_field'} } @{$tr->{'grpfields'}} ];

        #Текущее значение
        #Если поле рекурсивное (есть prnt_field), то не убираем элемент из списка оставшихся полей
        my $trl = $gd_grpfields->[0]{'prnt_field'} ? $gd_grpfields->[0] : shift @$gd_grpfields;
        $proj->dd('Текущее группируемое поле', $trl) if $treedbg;

        $vars->{firstgrplvl} = @$bd_grpfields ? 0 : 1; #Первый ли это уровень группировки
        $vars->{lastgrplvl} = @$gd_grpfields ? 0 : 1; #Последний ли это уровень группировки

        #Накладываем дефолтный фильтр для первого уровня
        if($vars->{firstgrplvl} && $tr->{first_level_filter} ){
            my $flflt = $tr->{first_level_filter};
            $addflt->{$_} = $flflt->{$_} for keys %$flflt;
        }

        if( $tr->{all_level_filter} ){
            my $flflt = $tr->{all_level_filter};
            $addflt->{$_} = $flflt->{$_} for keys %$flflt;
        }

        $proj->dd('Фильтр для группировки', $addflt) if $treedbg;

#        my $flt = '';
#        if( keys %$addflt ){
#            my $addfltstr = join( ' AND ', map { $_.'='.$dbt->dbh->quote($addflt->{$_}) } keys %$addflt);
#            $flt =  $flt ? " $flt AND $addfltstr " : $addfltstr;
#        }

        #Получение списка разделов текущего уровня
        #Обработка специальных типов полей
        my $order_by = $tinf->{'order_by'};
        if($trl->{type} && $tree_types->{$trl->{type}} ){
            $order_by ||= 'datagrpfield desc';
            my $trltype = $tree_types->{$trl->{type}};
            $vars->{ treelist } = $self->dbt_list( filter => $addflt, group_by => 'datagrpfield', 
                gfields => [$trltype->($trl->{field}).' datagrpfield', 'count(*) cc'], order_by => $order_by );
            
            $_->{name} = $_->{'datagrpfield'} for @{$vars->{ treelist }}; #Даём тексту единообразное название
            #$vars->{mcr} = 'weekel2text'; #Макрос для отображения пунктов
        }else{
            $order_by ||= $trl->{field};
            if( $trl->{'prnt_field'} ){ #Если рекурсивное поле, то иначе считаем количество элементов
                $proj->dd('Рекурсивное поле') if $treedbg;

                $vars->{'prntfield'} = $trl->{'prnt_field'};

                if($vars->{firstgrplvl} && defined( $trl->{first_level_prnt} )){
                    $addflt->{$trl->{'prnt_field'}} = $trl->{first_level_prnt};
                }

                #Получаем список детей
                #$dbt->{sql_dd_log} = 1;
                $vars->{ treelist } = $self->dbt_list( filter => $addflt, group_by => $trl->{field}, 
                    gfields => [$trl->{field}, 'count(*) cc'], order_by => $order_by, );

                $proj->dd('Список детей', $addflt, $vars->{ treelist }) if $treedbg;

                #Получаем для них количество их детей
                #Изменяем фильтр
                $addflt->{$trl->{'prnt_field'}} = [ map { $_->{$trl->{field}} } @{$vars->{ treelist }} ];
#$proj->dd($addflt);
#$dbt->{sql_dd_log} = 1;
                $vars->{ treelist_prnt } = $self->dbt_list( filter => $addflt, group_by => $trl->{'prnt_field'},
                    gfields => [$trl->{'prnt_field'}, 'count(*) cc'], order_by => $order_by, );
                my $cldr = { map { $_->{$trl->{'prnt_field'}} => $_->{cc} } @{ $vars->{ treelist_prnt } } };

                for my $el ( @{$vars->{ treelist }} ){ 
                    $el->{name} = $el->{$trl->{'field'}}; #Даём тексту единообразное название
                    $el->{cc} = $cldr->{ $el->{name} };
                }
            }else{ #Обычная группировка
                $vars->{ treelist } = $self->dbt_list( filter => $addflt, group_by => $trl->{field}, 
                    gfields => [$trl->{field}, 'count(*) cc'], order_by => $order_by, ); 
                $_->{name} = $_->{$trl->{field}} for @{$vars->{ treelist }}; #Даём тексту единообразное название
            }
        }
        #/Получение списка разделов текущего уровня

        #Добавляем информацию из других таблиц
        if( $trl->{ 'add_fields' } ){
            my @vls = map { $_->{name} } @{$vars->{ treelist }};
            for my $ff ( @{ $trl->{ 'add_fields' } } ){
                #Если таблица не указана, используем текущую                
                my $ff_tbl = $ff->{'table'} ? $proj->dbtable($ff->{'table'}, undef, $ff->{'dbhname'}) : $dbt;
                #Если поле внешней таблицы не указано, считаем, что оно совпадает с idfield 
                my $ff_fld = $ff->{'using'} || $tinf->{'idfield'};
                my $ff_fltr = { $ff_fld => \@vls };
                if( $ff->{add_filter} ){
                    $ff_fltr->{$_} = $ff->{add_filter}{$_} for keys %{$ff->{add_filter}};
                }
                my $ff_lst = $ff_tbl->List2( filter => $ff_fltr, gfields => [ $ff_fld, $ff->{'name'} ] );
                my $hh = { map { $_->{ $ff_fld } => $_->{ $ff->{'name'} } } @$ff_lst };
#$proj->dd($hh);
                $_->{ $ff->{'name'} } = $hh->{ $_->{'name'} } for @{$vars->{ treelist }};
            }
#$proj->dd($vars->{ treelist });
        }

        $proj->dd('Список детей с данными', $vars->{ treelist }) if $treedbg;


        #Если редактирование, то заполняем дефолтные поля
        if( $tr->{'edit_elms'} ){
            $vars->{'data'} = {};
            #Если добавление через деревья, то подхватываем часть полей
            for my $ff (@{$tinf->{tree}{grpfields}}){
                if(defined $ff->{'curval'}){
                    $vars->{'data'}{$ff->{'field'}} = $ff->{'curval'};
                }
            }
            #Если это рекурсивное поле, то нужно указать название поля предка
            if($trl->{'prnt_field'}){
                $vars->{'tree_prnt_field'} = $trl->{'prnt_field'};
            }
        }

        $vars->{mcr} = $tree_macros->{$trl->{type}}; #Макрос для отображения пунктов

        if( $trl->{showmacro} ){
            $vars->{showmacro} = showmacro2tmpl( $trl->{showmacro}, 'name' );
            $vars->{mcr} = 'tree_showmacro';
        }

#$proj->dd([],[],$vars->{showmacro});

        $tr->{'grpfield'} = $trl->{'field'};
        $vars->{'grpfield'} = $trl->{'field'};

        $vars->{'liststyle'} = 'tree'; #тип списка
        $vars->{template} = 'Lists/tree.tmpl';
    }elsif($act eq 'TreeVln'){
        my $tr = $tinf->{'tree_vln'};
        $vars->{ treelist } = $self->dbt_list( filter => '', group_by => $tr->{grpfield}, gfields => [$tr->{grpfield}, 'count(*) cc'] );
        $_->{name} = $_->{$tr->{grpfield}} for @{$vars->{ treelist }}; #Даём тексту единообразное название
        $vars->{template} = 'Lists/tree.tmpl';
    }elsif($act eq 'CheckForm'){
        if( $tinf->{checkform} ){
            $vars->{'_return_text'} = 1;
            my $h = $self->fields2hash('Add');
            $vars->{text} = $tinf->{checkform}{action}->($self, $h); 
        }
    }elsif(($act eq 'xls')||($act eq 'txt')||($act eq 'edit_phrase_list')||($act eq 'send_xls')||($act eq 'send_txt')){ #Выгрузка данных
        my $flds = $tinf->{'data_import_export'}{'list'};
        my $headers = [ @$flds ];
        
        my $flt = '';

        if($form->{filtered}){
            my $sinf = $tinf->{search}; 
            my $search_text = $sinf->{name} ? $form->{$sinf->{name}} : undef;
            $vars->{ajaxlisturl} .= '&'.$sinf->{name}.'='.uri_escape_utf8($search_text);
 
            if($search_text){
                $addflt->{ 'search_hash' } = { map { ( "$_ LIKE" => '%'.$search_text.'%' ) } @{$sinf->{'fields'}} };
            }
 
            $flt = $addflt;
        }
        #$proj->dd($form, $flt);

        my $list = '';
        if($tinf->{getlist}){ #Если получение не через базу, ходим через обобщающий вызов (будет подхватываться group_by)
            $list = $self->dtact_list( filter => $flt, gfields => $flds );
        }elsif($form->{use_grp} || $tinf->{data_import_export}{export}{use_grp}){  # Данные из базы; используем dtact_list
            #my $prm = { filter => $flt, gfields => $flds };
            my $prm = { filter => $flt };

            $prm->{order_by} = $tinf->{order_by} if $tinf->{order_by};  #Сортировка

            #$proj->dd($prm, $list);
            $list = $self->dtact_list( %$prm );
        }else{ # Данные из базы; просто выгружаем данные из таблицы (не использует group_by и т.д.)
            $list = $self->dbt_list( filter => $flt, gfields => $flds );
        }

        #$proj->dd($form, $flt, $list);
        # Если сет на турецком или английском, писать ли категории на выбранном языке или на русском 
        if ($tinf->{data_import_export}{export}{lang_for_categs}) {
            my $lang = $proj->viewoptions->{lang};
            if ($lang ne 'ru') {
                $list = [
                    map{
                        my $inp = $_;
                        # перевод на нужный язык CategoriesString
                        my @old_cats = split '/', $inp->{CategoriesString};
                        my @new_cats = ();
                        for my $old_cat (@old_cats) {
                            my $new_cat = $proj->get_category_by_name($old_cat, $lang);
                            push @new_cats, $new_cat->{CategoryName}; 
                        }
                        $inp->{CategoriesString} = join '/', @new_cats;
                       
                        # перевод на нужный язык CategPhrases
                        my @ctg_phrs = ($inp->{CategPhrases} =~ /"category":"(.*?)"/gi);
                        # для фраз в CategPhrases уже написаны категории на нужном языке, с ними ничего не нужно делать
                        @ctg_phrs = grep { not ($_ =~ /[=>]/) } @ctg_phrs;
                        for my $ctg (@ctg_phrs) {
                            my $new_cat = $proj->get_category_by_name($ctg, $lang);
                            $inp->{CategPhrases} =~ s/"category":"$ctg"/"category":"$new_cat->{CategoryName}"/g; 
                        }
                        $inp
                    } @$list]; 
            }
        }
 
        if (($tinf->{data_import_export}{export}{split_banner_data_field}) and (grep { $_ eq 'Data' } @$flds)) {
            my ($index) = grep { @$flds[$_] eq 'Data' } (0..(@$flds-1));
            my @detailed_fields = qw(body title title_extension url phrases);
            #$proj->dd( "fields before\n", Dumper($flds) );
            my @flds_arr = @$flds;
            splice @flds_arr, $index, 1, @detailed_fields;
            $flds = \@flds_arr;
            $headers = $flds;
            #$proj->dd( "fields after\n", Dumper($flds) );
        }

        if ($tinf->{data_import_export}{export}{readable_CategPhrases}) {
            my @flds_to_process = @{$tinf->{data_import_export}{export}{readable_CategPhrases}};
            for my $fld (@flds_to_process) {
                for my $item (@$list) {
                    next unless (exists $item->{$fld});
                    my @total_res = ();
                    for my $h (@{$proj->deserial($item->{$fld})}) {
                        my $res;
                        if ($h->{'phrase'} eq '') {
                            $res = "\'$h->{'category'}\'";
                        }
                        else {
                            $res = "\'$h->{'phrase'}\' => \'$h->{'category'}\'";
                        }
                        push @total_res, $res;
                    }
                    $item->{$fld} = join " / ", @total_res;
                }
            }
        }

        if ($tinf->{data_import_export}{export}{readable_tagging_mode} and (grep {$_ eq 'Mode'} @$flds)) {
            my %mode_to_str = ('' => 'Нет разметки',
                        'good' => 'Правильная категория',
                        'bad' => 'Неправильная категория',
                        'badlang' => 'Неправильный язык',
                        'strange' => 'Странный',
                        'uncat' => 'Нет категории');
            for my $item (@$list) {
                $item->{Mode} = $mode_to_str{$item->{Mode}};
            }
        }

        if ($tinf->{data_import_export}{export}{readable_checked_state} ) {
            for my $item (@$list) {
                # определение состояния (good/bad), (checked/not checked), жутко неочевидная логика
                if ($item->{Checked} eq '') {
                    $item->{Checked} = 'not checked';
                }elsif ($item->{Checked} eq 'bad') {
                    $item->{Checked} = 'checked';
                }
                
                if ($item->{Checked} eq 'checked') {
                    if ($item->{UserState} eq 'bad') {
                        $item->{Checked} = 'bad';
                    }
                    elsif ($item->{UserState} eq '') {
                        $item->{Checked} = 'good';
                    }
                }
            }
        }

        if ($tinf->{data_import_export}{export}{readable_diff_categs} ) {
            for my $item (@$list) {
                # доставание категорий из хешей - работает только для случая, когда в этих полях лежат ссылки на массив хешей:
                # в старой версии категории хранятся как ссылки на массив хешей, в новой версии - как строк, поэтому для новой версии дополнительная обработка не нужна
                for my $fld (qw(new_categs old_categs)) {
                    if (ref $item->{$fld} eq 'ARRAY') {
                        $item->{$fld} = join "/", (map { $_->{'categ'} } @{$item->{$fld}});
                    }
                }
            }
        }

        #Сортируем список, если нужно        
        if (my $sort = $tinf->{'data_import_export'}{export}{sort}) {
            $list = [ sort { $a->{ $sort } cmp $b->{ $sort }} @$list ];
        }

        if ($tinf->{data_import_export}{export}{use_selectlist}) {
            # Для каждого из полей, для которых задано selectlist, заменяем значения поля на названия, указанные в selectlist
            for my $fld (grep {$_->{selectlisthash}}  @{ $tinf->{fields} }) {
                my $name = $fld->{name} // $fld->{extname};
                my $selectlisthash = $fld->{selectlisthash};
                #$proj->dd([ $name, $selectlisthash ]);
                $_->{$name} = $selectlisthash->{ $_->{$name} } // $_->{$name}   for @$list;
            }
        }

        $list = [ map {[ map { htmlsmbl2text($_) } @{$_}{ @$flds } ]} @$list ];

        unshift @$list, $headers   if $tinf->{'data_import_export'}{export}{headers};   # Заголовки столбцов

        my $file_name = $tinf->{'data_import_export'}{export}{file_name} // 'd_' . ($tinf->{table} // $self->form->{'cmd'} ) . '_' . $proj->dates->cur_date('db');

        if($act eq 'xls'){
            $vars->{'_return_real_xls'} = "$file_name.xlsx";
            $vars->{text} = array2xlsx($list);
        }elsif($act eq 'txt'){
            $vars->{'_return_textfile'} = "$file_name.txt";
            $vars->{text} = join '', map { join("\t", @$_)."\n" } @$list; 
        } elsif ($act eq 'send_xls' or $act eq 'send_txt') {
            my $type = $act eq 'send_xls'  ?  'xls'  :  'txt';
            my $content = BM::DBFiles::array2file($proj, list => $list, type => $type,);
            # TODO сохранять в json, конвертировать в нужный формат при выгрузке
            my $login = $proj->user  ?  $proj->user->user_inf->{Login}  :  '';
            my $error;

            my $file_id = BM::DBFiles::upload_file(
                $proj,
                file_name => $file_name,
                file_type => $type,
                file_content => $content,
                info => "", 
                login => $login,
            );

            if (not $file_id) {
                $error = "DBError";
            } else {
                my $send_title = $self->form->{send_title};
                my $res = BM::DBFiles::send_file_link($proj, file_id => $file_id, login => $login, title => $send_title, );
                if (not $res) {
                    $error = "SendError";
                }
            }

            my $message = $error ? "ERROR: $error" : "DBList_OK";
            $vars->{template} = "Lists/message.tmpl";
            $vars->{text} = "$message";
            $vars->{simple} = 1;

        }elsif($act eq 'edit_phrase_list'){

            my $phl = $proj->phrase_list([ map { join(" =*> ", @$_) } @$list ]); 
 
            $proj->save_phrase_list($phl);
            $proj->do_redirect(join("&", 
                "ind.pl?cmd=edit_phrase_list",
                "act=showphl", 
                "phlid=".$phl->cache_id,
                "viewoptionsstr=".$form->{viewoptionsstr},
            ));
        }

    }elsif( $act =~ /^spact_(.*)/ ){ #Отображение списка
        my $actname = $1;
        my @ract = ();
        @ract = grep { $_->{name} eq $actname } @{$tinf->{'bottom_actions'}} if $tinf->{'bottom_actions'} && ! @ract;
        @ract = grep { $_->{name} eq $actname } @{$tinf->{'spacts'}} if $tinf->{'spacts'} && ! @ract;
        #$proj->dd(\@ract, $actname, $tinf->{'spacts'});
        if(@ract){
            my $acth = $ract[0]; #Берём только первое действие

            #Получаем значения дополнительных полей, если есть
            my $sp_h = {};
            for my $k (keys %$form){
                if($k =~ /^spactfld_(.+)/){
                    $sp_h->{$1} = $form->{$k};
                }
            }

            my $spact = $acth->{'redir_action'} || $acth->{action};

            my $ellist = [];
            if($acth->{ellist}){ #Получение полного списка элементов, над которыми нужно сделать действие
                #Фильтрация
                my $flt = $addflt;
                $flt = { type => $form->{type} } if $tinf->{typeflt} && defined($form->{type});

                #Не включаем для всех, так как может быть дорогой операцией
                my $list = $self->dtact_list( filter => $flt, 
                        ($acth->{ellist_limit} ? ( limit => $acth->{ellist_limit} ) : () ),
                        ($acth->{ellist_order_by} ? ( order_by => $acth->{ellist_order_by} ) : () ),
                    ); #Получение списка с текущей фильтрацией

                $ellist = $list; 
            }

            my $res = $spact->(
                $self, 
                $form->{lst1}, # Строка со списком элементов первой колонки выбора
                $form->{lst2}, # Строка со списком элементов второй колонки выбора
                $sp_h, # Хэш значений дополнительных полей для выбора
                $addflt,
                $ellist,
            );

            #Выгружаем данные в XLS
            if($acth->{xls}){
                $vars->{'_return_real_xls'} = "data.xls";
                $vars->{text} = array2xls($res);
                return;
            }

            $proj->do_redirect($res) if $acth->{'redir_action'};
        }
        $proj->do_redirect($listurl);     
    }elsif( $act =~ /^inlacts_(.*)/ ){ #Отображение списка
        my $actname = $1;
        my @ract = ();
        @ract = grep { $_->{name} eq $actname } map { $_->{inlacts} ? @{$_->{inlacts}} : () } @{$tinf->{fields}} if @{$tinf->{fields}} && ! @ract;
        if(@ract){             
            $vars->{text} = $ract[0]{act}->($proj, $ract[0], $form->{id});
        }else{
            $vars->{text} = " ";
        }
        $vars->{'_return_text'} = 1;
#$proj->dd(\@ract, $vars->{text});
#exit;
    }else{ #Отображение списка
        my $flt = $addflt;
        #Фильтрация
        $flt = { type => $form->{type} } if $tinf->{typeflt} && defined($form->{type});

        my $prm = { filter => $flt };

        #Сортировка
        $prm->{order_by} = $tinf->{order_by} if $tinf->{order_by};
        #Листалка
        if($tinf->{pager} && ! $vopts->{charts}){ #Для графиков отключаем листалку
            my $pi = $tinf->{pager};
            my $curp = $form->{$pi->{name}} || 1;
            my $cc = $proj->viewoptions->{ $vars->{pagercc_name} } || $pi->{cc} || 50;
            my $list_count = $self->dbt_count($flt);
            $prm->{limit} = ( ($curp - 1) * $cc ).' , '.$cc;   
            $vars->{pages} = int($list_count / $cc);
            $vars->{pages}++ if $list_count % $cc;
            $vars->{curpage} = $curp;
        } 
        #Получение списка
        my $list = $self->dtact_list( %$prm );

        if ($vopts->{charts} && $tinf->{'charts'}) {
            # Дописываем title для графиков: для каждого графика, если не задан title, то берем title из fields
            my %fldtitles = map { ($_->{name} // $_->{extname} // '') => $_->{title}} @{$tinf->{fields}}; # Заголовки полей из $tinf->{fields}
            for my $ch (@{$tinf->{'charts'}{list} // []}) {
                # Если для графика не определен title, то пытаемся взять его из title соответствующего поля из $tinf->{fields}
                $ch->{title} //= $fldtitles{$ch->{dtvalue}};
            }
        }

        if($vopts->{charts} && $tinf->{charts}){

            #Накладываем дефолтные значения для графиков
            if($tinf->{charts}{default_chart_params}){
                my $dp = $tinf->{charts}{default_chart_params};
                for my $ch (@{$tinf->{charts}{list}}){
                    for my $k (keys %$dp){
                        $ch->{$k} = $dp->{$k} unless defined $ch->{$k};
                    }
                }
            }

            for my $ch (@{$tinf->{charts}{list}}){
                if ($ch->{precise_date_axis}) {
                    # Отображать на оси дат время с точностью до секунды
                    my $js_settings_precise_date_axis = '
                        "dataDateFormat": "YYYY-MM-DD JJ:NN:SS",
                        "categoryAxis": { "parseDates": true, "dashLength": 1, "minorGridEnabled": true, "position": "top", "minPeriod": "ss", },
                    ';
                    $ch->{js_settings} = $js_settings_precise_date_axis . ($ch->{js_settings} // '');
                }

                $ch->{href_name} //= do { my $s = $ch->{title} || $ch->{dtvalue};  $s =~ s/\s/_/g;  $s };   # Для ссылок на график <a name=...>
            }

            my @fld_charts = map { $_->{dtvalue} // () } @{ $tinf->{charts}{list} };
            for my $el (@$list) {
                $el->{"gfld$_"} //= $el->{$_}   for @fld_charts;  # kostyl for charts     TODO Передавать нужные названия полей в chart_macros.tmpl
            }

            my $split_values = {};  # список срезов
            {
                #Специальная группировка для графиков
                #Если вывод графиков с разбивкой по одному из полей, то перекладываем данные
                my $split_field = $tinf->{charts}{split_field} // ''; #Поле, по которому разбиваем
                my $date_field = $tinf->{charts}{date_field}; #Поле даты
                #$proj->dd([$split_field, $date_field, [@$list]]);
                my $date2spl2el = {}; #Группируем данные по дате и разбиваемому полю
                $date2spl2el->{ $_->{$date_field} }{ $_->{$split_field} // '' } = $_ for @{$list};
                my @arr = (); #Новый массив с данными
                $split_values = {};  #Получаем список срезов
                for my $date (keys %$date2spl2el){
                    my $spl2el = $date2spl2el->{$date};
                    for my $spl (keys %$spl2el){
                        $split_values->{$spl}++;
                        my $el = $spl2el->{$spl};
                        push(@arr, { $date_field => $date, ( map { $spl.'_'.$_ => $el->{$_} } keys %$el ) } ); 
                    }
                }
                @arr =  sort { $a->{$date_field} cmp $b->{$date_field} } @arr; 
                $list = \@arr; #Перераскладываем поля
            }

            my @split_values = keys %$split_values;
            #$proj->dd([ split_values => \@split_values ]);
            for my $ch (@{ $tinf->{'charts'}{'list'} }){
                #$proj->dd([ ch => $ch ]);
                $ch->{type} //= 'multilines';
                $ch->{flist} //= [ map { { name => $_, value => $_.'_gfld'.$ch->{dtvalue}, } } @split_values ];
            }
        }
        #/Специальная группировка для графиков

        parse_meta($tinf->{fields}, $list);
        $vars->{list} = $list;
        $vars->{template} = 'Lists/list.tmpl';
    }

    my $tlog = time - $begtime;
#$proj->dd('tlog:'.$tlog);

}


1;
