package Macros;

use utf8;
use base qw(ObjLib::ProjPart);
use Data::Dumper;
use Utils::Sys;
use Utils::Urls;
use URI::Escape qw(uri_escape_utf8);
use Encode;
use List::Util qw(min);
use Unicode::UCD qw(charinfo);

sub get_data_type {
    return 'UNDEF' if ! defined $_[0];
    return 'EMPTY' if (! ref($_[0])) && ($_[0] eq '');
    #return 'UTYPE' if (! ref($_[0])) && ($_[0] =~ /\#UTYPE\#/);
    return ref($_[0]) || ($_[0] =~ /^https?:\/\// ? 'URL' : '') || '';
};

#Превращаем любую структуру в структуру массивов
sub data2tables {
    my ($data, $proj) = @_;
    my $type = get_data_type($data);
    if($type eq 'HASH'){
        return [ map { [ [[ $_ ]] => ( data2tables( $data->{$_} ) ) ] } sort keys %$data ];
    }elsif($type eq 'ARRAY'){
        my $j = 0; #Нумерация строк массива
        return [ map { [ ++$j.'.', data2tables( $_ ) ] } @$data ];
    }elsif($type eq 'URL'){
        return [ [ $data ] ];
    }elsif($type && ($type =~ /::PhraseList/)){
        return [ map { data2tables($_) } $data->phrases ];
    }elsif($type && ($type =~ /::Phrase/)){
        return [ [ "phrase: $data" ] ];
    }elsif($type && ($type =~ /::PageList/)){
        return data2tables([@$data]);
    }elsif($type && ($type =~ /::Page/)){
        my $name = $data->name;
        $name = "[".$data->is_metalinks_url."] $name" if $data->is_metalinks_url;
        $name = "[".$data->is_metalinks_text."] $name" if $data->is_metalinks_text;
        #$name = "[".$data->is_web_wideurlname."] $name" if $data->is_web_wideurlname;
        return [ [ $name, "#UTYPE# => $name => ".$data->is_web_wideurlname, $data->url ] ];
    }elsif($type && ($type =~ 'Project')){
        return [ [ 'proj' ] ];
    }elsif($type){
        return [ map { [ [[ $_ ]] => ( data2tables( $data->{$_} ) ) ] } sort keys %$data ];
        #return [ map { [$_] } $data->phrases ];
    }else{
        return [ [ $data ] ];
    }
}

# Выравнивает массивы массивов массивов по количеству строк
#  1     1 2 3         1          1 2 3
#        1 2 3  =>     undef      1 2 3
#        1 2 3         undef      1 2 3
# Тест Macros::fixtablesline([[[111]], [[12,22,32], [22,32,42], [32,42,52]],[[12,22], [22,42],]  ]);
sub fixtablesline {
    my ($data) = @_;
    my $maxcol = 0;
    $maxcol = $maxcol < @$_ ? @$_ : $maxcol for @$data;
    push( @$_, ([(undef) x (0+@{$_->[0]}) ]) x ($maxcol - @$_) ) for @$data; #Дополняем колонки до полной длины
    #print Dumper($data);
    #print "dddd\n";
    return $data;
}

# Выравнивает массив массивов по количеству элементов в строке
#  1  2              1  2  undef undef
#  1  2  3      =>   1  2  3     undef
#  1  3  4  5        1  3  4     5
#  Тест print Dumper(Macros::fixtablescol([[12,22], [22,32,42], [32]]));
sub fixtablescol {
    my ($data) = @_;
    my $maxline = 0;
    $maxline = $maxline < @$_ ? @$_ : $maxline for @$data;
    push( @$_, ((undef) x ($maxline - @$_)) ) for @$data; #Дополняем колонки до полной длины
    #print Dumper($data);
    #print "dddd\n";
    return $data;
}

#Объединяем прямоугольные массивы строкой в массив
#  1     1 2 3             1 1 2 3
#        1 2 3  =>     undef 1 2 3
#        1 2 3         undef 1 2 3
sub jointables {
    my ($data) = @_;
    fixtablescol($_) for @$data; #Исправляем проблему, если в таблице разное число элементов
    $data = fixtablesline($data);
    my $lines = 0+@{$data->[0]};
    my @res = ();
    for(my $i = 0; $i < $lines; $i++){
        push(@res, [  map { @{ $_->[$i] } } @$data ]);
    }
    return \@res;
}

#Превращение структуры таблиц в единую таблицу
sub tables2table {
    my ($data, $line) = @_;
    $res = [[]] unless $res;
    if(ref($data) eq 'ARRAY'){
            my $curres = [ map { tables2table($_, ($line ? 0 : 1)) } @$data ];
            if($line){
                return jointables($curres);
            }else{ #Объединяем колонку
                return [ map { @$_ } @$curres ];
            }
    }else{
        return [[ $data ]];
        #push( @{ $res->[@$res-1] }, $data, $res );
    }
}

#Превращение структуры данный в плоскую таблицу
sub data2commontable {
    my ($data, $proj) = @_;
    return tables2table data2tables $data, $proj;
}

sub get_macros {
    my ($self, $rf, $vars) = @_;

    $vars //= {};

    $vars->{trh} = {};
    $vars->{trh} = $self->proj->get_transl_hash if $vars->{viewoptions}{lang} && ($vars->{viewoptions}{lang} ne 'ru');

    my %h = (
        #'catid2catname' => sub {
        #    my $proj = $$rf;
        #    return $proj->get_category_name($_[0], $_[1]);
        #},
       'cat2inf' => sub { my $proj = $$rf; return $proj->get_category_by_name($_[0], $_[1]); },
       #'catlist' => sub { my $proj = $$rf; return $proj->get_cached_categories_list; }, #Выводился для тестов
       'data2commontable' => sub { my $proj = $$rf; return data2commontable( $_[0], $proj ); },
       'catid2catname' => sub { my $proj = $$rf; return $proj->get_cached_categories_list->{catid2catname}{$_[0].' _ '.($_[1]||'ru')}; },
       'catname2catid' => sub { my $proj = $$rf; return $proj->get_cached_categories_list->{catname2catid}{$_[0]}; },
       'get_data_type' => sub {
            return 'UTYPE' if $_[0] =~ /^\#UTYPE\#/;
            ref($_[0]) || ($_[0] =~ /^https?:\/\// ? 'URL' : '') || '';
        },
       'format_number' => \&format_number,
       'format_number_2' => sub { return format_number($_[0], 2); },
       'format_number_3' => sub { return format_number($_[0], 3); },
       'delcommas' => sub { my $t = $_[0]; $t =~ s/,/ /g; $t =~ s/\s+/ /g; return "$t"; },
       'nline2comma' => sub { my $t = $_[0]; $t =~ s/\n/, /g; $t =~ s/\s+/ /g; $t =~ s/\s+,/,/g; return "$t"; },
       'text2phrasecount' => sub { my $t = $_[0]; my @arr = split(/[\n,]+/, $t); return 0+@arr; },
       'punycode2unicodeurl' => sub { my $proj = $$rf; return url_to_unicode($_[0]) },
       'geturlimage' => sub {
            my ($url) = @_;
            my $proj = $$rf;
            my $pg = $proj->page($url);
            return $pg->get_page_image;
       },
       'cuttext' => sub {
            my ($str) = @_;
            my $proj = $$rf;
            return $proj->phrase($str)->cuttext;
       },
       'splitlongtext' => sub {
            my ($str) = @_;
            my $proj = $$rf;
            return $proj->phrase($str)->splitlongtext;
       },
       'widesplitlongtext' => sub {
            my ($str) = @_;
            my $proj = $$rf;
            return $proj->phrase($str)->splitlongtext(300);
       },
       'shylongtext' => sub {
            my ($str) = @_;
            my $proj = $$rf;
            $str =~ s/(.{20})/$1\&shy;/g;
            return $str;
       },
       'shyfilter' => sub {
            return sub {
                my ($str) = @_;
                my $proj = $$rf;
                $str =~ s/(.{40})/$1\&shy;/g;
                return $str;
            };
       },
       'splitlongarray' => sub {
            my ($aa, $lmt) = @_;
            $lmt ||= 10;
            my @oldarr = @$aa;
            my @arr = ();
            while( my @subarr = splice(@oldarr, 0, $lmt) ){
                push(@arr, \@subarr);
            }
            return \@arr;
       },
       'get_atoms_inf' => sub {
            my ($str) = @_;
            my $proj = $$rf;

            my @atoms = split /([\[\/])(\.[^\]\/]+)/, $str;
            my @data = ();

            if(@atoms > 1) {
                # выделяем айдишники именованных атомов
                for(my $i = 0; $i < @atoms; $i += 3) {
                   push @data, {text => join("", @atoms[$i..min($i + 1, $#atoms)]), categ_id => 0};

                   if($i + 2 < @atoms) {
                       my $name = $atoms[$i + 2];
                       my $categ = $proj->get_category_by_name($name);
                       push @data, {text => $name, categ_id => ($categ ? $categ->{CatID} : 0 )};
                   }
                }
            } else {
                @data = ({ text => $str, categ_id => 0 });
            }
            return \@data;
       },
       'hidereferer' => sub {
           my ($url) = @_;
           #http://wiki.yandex-team.ru/intranet/hidereferer
           #http://h.yandex.net/?http%3A%2F%2Fyandex.ru%2F
           #return 'http://h.yandex.net/?'.uri_escape($url);
           return 'http://h.yandex.net/?'.uri_escape_utf8($url);
       },
       'mlns' => sub {
            my ($num) = @_;
            $num /= 1000000;
            $num = format_number($num, 0);
            return $num;
       },
       'bscost' => sub {
            my ($cost) = @_;
            $cost /= 1000000;
            $cost = format_number($cost, 2);
            return $cost;
       },
       'jsbscost' => sub {
            my ($cost) = @_;
            $cost /= 1000000;
            #$cost =~ s/,/./g;
            return $cost;
       },
       'catid2inf' => sub {
            my ($str, $lang) = @_;
            $lang ||= 'ru';
            my $proj = $$rf;
            my $ci = $proj->get_category($str, $lang);
            $ci->{CategoryPhrases} = '';
            return $ci;
       },
       'curtime' => sub {
            my $proj = $$rf;
            $proj->dates->cur_date('db_time');
       },
       'space2nbsp' => sub {
            my ($str) = @_;
            $str =~ s/\s+/&nbsp;/g;
            return $str;
       },
       'comma2commaspace' => sub {
            my ($str) = @_;
            $str =~ s/,/, /g;
            return $str;
       },
       'quote2bkslquote' => sub {
            my ($str) = @_;
            $str =~ s/\'/\\'/g;
            $str =~ s/\\/\\\\/g;
            $str =~ s/\"/\\"/g;
            return $str;
       },
       'liststr2hash' => sub {
            my ($str) = @_;
            return {} unless defined $str;
            chomp($str);
            my @arr = split( /\s*;\s*/, $str);
            @arr = '' if $str eq '';
            push(@arr, '') if $str =~ /;$/;
            return { map { $_=>1 } @arr };
       },
       'text2id' => sub {
            my ($text) = @_;
            my $proj = $$rf;
            #my $sid = substr( md5int('sdf223'.$text), 0, 10 );
            $text = Encode::encode('utf-8', $text);
            Encode::_utf8_on($text);
            use Digest::MD5;
            #my $str_bytes = Encode::encode('UTF-8', $text);
            return substr( Digest::MD5::md5_hex($text), 0, 7 );
            my $sid = substr( md5_hex('sdf223'.$text), 0, 7 );
            return $sid;
       },
       'uri_escape_utf8' => sub {
            my ($text) = @_;
            return uri_escape_utf8($text);
       },
       'week2text' => sub {
            my ($text) = @_;
            my $proj = $$rf;
            return $proj->dates->trdate('db_week', 'week_txt', $text);
       },
       'datetime2date' => sub {
            my ($text) = @_;
            my $proj = $$rf;
            return $proj->dates->trdate('db_time', 'db', $text);
       },
       'pagerslist' => sub { #Возвращает список пейджей около рассматриваемых окресностей
            my ( $curp, $ttl) = @_;
            my $proj = $$rf;
            return []  if ($ttl // 0) == 0;
            my @pp = grep { $_ > 0 } grep {  $_ < $ttl + 1 } (1 .. 5, $curp-5 .. $curp+5, $ttl-5 .. $ttl);
            @pp = sort { $a <=> $b } keys %{{ map {$_=>1} @pp }};
            return \@pp;
       },
       'trl' => sub {
            my ($text) = @_;
            return $vars->{trh}{$text} || $text;
       },
       'rand_id' => sub {
            my ($text) = @_;
            return int(10000000 * rand());
       },
       'text2phlid' => sub {
            my ($text) = @_;
            my $proj = $$rf;
            my $phl = $proj->phrase_list($text);
            $proj->save_phrase_list($phl);
            return $phl->cache_id;
       },
       'projrf' => sub {
            return $$rf;
       },
       'query_string' => sub {
            return $ENV{'QUERY_STRING'};
       },
       'perldata2js' => sub {
            # Copy-pasted from CatalogiaMediaProject.pm   # TODO
           sub _perldata2js {
                my ($data) = @_;
                my $text = '';
                return $data =~ /^[0-9\.]+$/ ? $data : '"'.$data.'"' unless ref($data);
                return '['.join(', ', map { _perldata2js($_) } @$data ).']' if ref($data) eq 'ARRAY';
                return '{'.join(', ',  map { '"'.$_.'": '. _perldata2js($data->{$_}) } keys %$data ).'}' if ref($data) eq 'HASH';
                return 'CODE';
           }

           my $tt = _perldata2js(@_);
           $tt =~ s/^\s*\{|\}\s*,?\s*$//g;
           return $tt;
       },
       'sort_list' => sub {
            my ($list, $fld) = @_;
            return [ sort { $a->{$fld} <=> $b->{$fld} } @$list ];
       },
       'check_rights' => sub {
            my ($list) = @_;
            my $proj = $$rf;
            return $proj->_check_rights($list);
       },
       'use_macro_for_substr' => sub {
            my ($text, $macro) = @_;
            $text =~ s/"/\\"/g;
            my @a = $text =~ /[^a-zа-я]+|[a-zа-я][-a-zа-я_,\.\(\): ]+/ig;
            @a = map { /[a-zа-я]/i ? '[%'.$macro.'("'.$_.'")'.'%]' : $_ } @a;
            return join('',@a);
       },
       # праздничный день
       'is_holiday' => sub {
           my $date = shift;
           my $proj = $$rf;
           return $proj->dates->trdate("db", "holiday", $date);
       },
       'ka_state' => sub {
           my ($st, $l) = @_;
           my $proj = $$rf;
           #$proj->dd([$st, $l]);
           my $sc = 0;
           ref($_)||($_ ne '') ? last : $sc++ for @$l;
           my $vislimit = 10;
           $st->{vislimit} = $vislimit;
           $st->{tableid} ||= int(10000000 * rand()); #Идентификатор текущей таблицы, так как может быть несколько на странице
           $st->{glblockid}||=1; #Глобальная нумерация блоков
           $st->{blockid}||=0; #Номер текущего блока
           $st->{elemid}++; #Номер текущего элемента
           $st->{stack} ||= []; #Стек вложенности - массив параметров элементов вверх по иерархии
           if($sc == $st->{sc}){ #Элемент на том же уровне
           }else{
                if($sc > $st->{sc}){ #Углубление вложенности
                    for ( 1 .. $sc - $st->{sc}){ #Возможны переходы на несколько уровней
                        push(@{$st->{stack}}, { map { $_ => $st->{$_} } qw{ blockid count visible class } }); #Убираем текущие значения цикла в стэк
                        $st->{blockid} = $st->{glblockid}++; #Смена номера блока
                        $st->{count}=1;   #Сбрасываем очередь
                    }
                }else{ #Уменьшение вложенности
                    for ( 1 .. $st->{sc} - $sc){ #Возможны переходы на несколько уровней
                        my $rr = pop(@{$st->{stack}});
                        $st->{$_} = $rr->{$_} for qw{ blockid count visible class };
                    }
                }
           }
           $st->{count}++;
           $st->{sc} = $sc;
           $st->{visible} = $st->{count} <= $vislimit; #Должен ли отображаться элемент в данном блоке
           $st->{pager} = $st->{count} == $vislimit + 1; #Нужно ли отображать пейджер перед этим элементом

           #На уровнях вложенности есть скрытие отображения
           #Определяет, нужно ли при начальном показе отображать строку
           $st->{deepvisible} = !( grep {! $_->{visible}} @{$st->{stack}}, $st);

           #Список классов - идентификаторы блоков, которые отключают показ при сокрытии пейджера этого блока
           #Имя блока с добавлением vsbl - элементы, которые должны включаться при выборе показа пейджера

           #Имя класса текущего блока
           $st->{class}  = "tb".$st->{tableid}."bl".$st->{blockid};
           my @cls =
                map {$_->{class}} #Имя класса
                grep { ! $_->{visible} } #Берём только те блоки, в которых не попадаем во всегда отображаемую облась
                (@{$st->{stack}});   #

           my @pcls = @cls; #Список классов для пейджера
           push(@pcls, $pcls[@pcls-1].'vsbl') if @pcls; #Доклеиваем маркер видимости для класса максимальной глубины - нужно для включения отображения
           $st->{pagerclasslist} = join(" ", @pcls); #Список классов для пейджера, так как он тоже должен прятаться
           $st->{pagerdeepvisible} = !( grep {! $_->{visible}} @{$st->{stack}} ); #Проверка видимости по иерархии без текущего элемента

           push( @cls, $st->{class} ) if ! $st->{visible}; #Доклеиваем текущий класс, если этот элемент должен быть скрыт
           push(@cls, $cls[@cls-1].'vsbl') if @cls; #Доклеиваем маркер видимости для класса максимальной глубины - нужно для включения отображения
           $st->{classlist} = join(" ", @cls);

           $st->{smallpagerclass} = '';
           if( ! $st->{visible} ){
               my $pggrp = int(($st->{count} - 1) / $vislimit);
               my $llpgr = (($st->{count} - 1) % $vislimit) == 0;
               my $pgclass = $st->{class}."pp".$pggrp;
               $st->{pggrp} = $pggrp;
               $st->{smallpagerclass} = $pgclass if $pggrp && $llpgr;

               #Нужно для синхронизации показа или скрытия всех
               $st->{smallpagerfrt} = $st->{class}."ppfrt"; #Класс для первой листалки
               $st->{smallpagerscd} = $st->{class}."ppscd"; #Класс для всех листалок кроме первой

               if($pggrp > 1){ #Ведём себя как элемент
                   $st->{smallpagerclasslist} = $st->{classlist};
                   $st->{smallpagerclasslist} .= " ".$st->{class}."pp".($pggrp-1); #Предыдущая страница листалки длинных списков

                   $st->{smallpagerclasslist} .= " ".$st->{smallpagerscd};
               }else{ #Ведём себя как общая листалка
                   $st->{smallpagerclasslist} = $st->{pagerclasslist};
                   $st->{smallpagerclasslist} .= " ".$st->{smallpagerfrt};
               }
               $st->{classlist} .= " $pgclass"; #Добавляем класс постраничной листалки
           }

           #$st->{classlist} .= ' deepvisiblehide' if $st->{deepvisible};
           return $st;
        },

        get_url_search_banners => sub {
            my ($text, $ctg) = @_;

            my $search_text = URI::Escape::uri_escape_utf8($text);
            $search_text .= " categ_$ctg"   if defined $ctg;  # IF phrase.Action == "AddAntiword"
            return "ind.pl?cmd=search_banners&do_search=1&phrase_text=$search_text";
        },
        param2urlpart => sub {
            my ($key, $item) = @_;
            if (ref($item) eq 'ARRAY') {
                return join("&", map { "$key=" . URI::Escape::uri_escape_utf8($_) } @$item);
            };
            return ("$key=" . URI::Escape::uri_escape_utf8($item));
        },

        # Для использования в Lists/chart_macros.tmpl
        grep_data_for_charts => sub {
            my ($data, $chr) = @_;
            my %need_value_names = map { $_->{value} => 1 } @{$chr->{flist}};
            my $data_new = [ grep { my $el = $_;  (grep { $need_value_names{$_} } keys %$el) } @$data ];   # TODO
            return $data_new;
        },
        seconds_to_hms => sub {
            my ($text) = @_;
            my $sec = int($text);
            my $h = int($sec / 3600);
            my $m = int(($sec % 3600) / 60);
            $sec = $sec % 60;
            return $h > 0 ? "<b>$h</b> ч. $m м." : "$m м. $sec c.";
        },
        seconds_to_dh => sub {
            my ($text) = @_;
            my $sec = int($text);
            my $d = int($sec / (3600 * 24));
            my $h = int(($sec % (3600 * 24)) / 3600);
            return "$d д. $h ч.";
        },
        text_to_charinfo => sub {
            my ($text, $is_full) = @_;
            my @charinfo = ();
            my $tooltips = '';
            my $tooltipscolor = '';
            my %scripts = ();
            for my $char (split //, $text) {
                push @charinfo, { char => $char, %{charinfo(utf8::native_to_unicode(ord($char)))} };
            }
            sub maketooltip {
                my ($char, $title, $color, $mono) = @_;
                my $span_title = $title ? "title=\"$title\"" : "";
                my $span_color = $color ? "color: $color;" : "";
                my $span_mono = $mono ? "font-family: monospace;" : "";
                my $span = "<span $span_title style=\" $span_color $span_mono white-space:pre\">$char</span>";
                return $span;
            }
            $scripts{$_->{script}} = '' foreach @charinfo;
            my %scripts_charcount = ();
            $scripts_charcount{$_->{script}}++ foreach @charinfo;
            my @colors_arr = ( '', 'magenta', 'red', 'blue', 'brown' );
            my %colors = ();
            @colors{sort {$scripts_charcount{$b} <=> $scripts_charcount{$a}} keys %scripts_charcount} = @colors_arr;
            foreach my $char ( @charinfo ) {
                $tooltipscolor .= maketooltip($char->{char}, $char->{name}, $colors{$char->{script}}, 0);
                $tooltips .= maketooltip($char->{char}, $char->{name}, 0, 1);
                foreach my $script ( keys %scripts ) {
                    if ( $char->{script} eq $script ) {
                        $scripts{$script} .= maketooltip($char->{char}, $char->{name}, 0, 1);
                    }
                    else {
                        $scripts{$script} .= maketooltip(" ",'', 0, 1);
                    }
                }
            }
            my $result;
            if ($is_full) {
                $result = "<table>";
                $result .= "<tr><td>all (with tooltips)</td><td>$tooltips</td></tr>";
                $result .= "<tr><td>$_</td><td>$scripts{$_}</td></tr>" foreach keys %scripts;
                $result .= "</table>";
            }
            else {
                $result = $tooltipscolor;
            }
            return $result;
        }
    );
    return \%h;
}

1;

