package User;

use POSIX qw(strftime);
use utf8;
use open ':utf8';

use base qw(ObjLib::ProjPart);

use Data::Dumper;

use Encode qw(from_to);

########################################################
#Доступ к полям
########################################################

__PACKAGE__->mk_accessors(qw(
    login
    dbt
    grpdbt
    logdbt
));

########################################################
# Инициализация
########################################################

sub init {
    my ($self) = @_;

    my $proj = $self->proj;    
    $self->{dbt} = $proj->dbtable($self->{'table'}, 'Login', $self->{'dbhname'});
    $self->{grpdbt} = $proj->dbtable($self->{'group_table'}, 'Login', $self->{'dbhname'});
    $self->{logdbt} = $proj->dbtable($self->{'log_table'}, 'Login', $self->{'dbhname'});
    
}

########################################################
# Методы
########################################################

sub log_visit {
    my ($self) = @_;
    $self->dbt->Edit($self->login, { NumVisits => $self->user_inf->{'NumVisits'} + 1,
                                     LastVisit => strftime("%Y-%m-%d %H:%M:%S", localtime) } );
    my $form = $self->proj->form;
    #$self->proj->dd($form, { Login => $self->login, (  map { $_ => $form->{$_} || '' } qw{ cmd act } ) });
    $self->logdbt->Add({ Login => $self->login, (  map { $_ => $form->{$_} || '' } qw{ cmd act } ) });
}

sub user_inf :CACHE {
    my ($self) = @_;
    my $res = $self->dbt->Get($self->login);
    return $res if $res;
    
    #Если ничего не знаем о пользователе, то заводим его в базе
    $self->dbt->Add({ Login => $self->login, role => 'user', state => 'USER_0', });

    $res = $self->dbt->Get($self->login);
    return $res;
}

sub admin_role :CACHE {
    my ($self) = @_;
    return $self->role eq "admin";
}

sub role :CACHE {
    my ($self) = @_;
    return $self->user_inf->{'role'} || 'user';
}

sub group :CACHE {
    my ($self) = @_;
    my $h = $self->grpdbt->Get('Login');
    my $defgr = 'unkn';
    return $defgr unless $h;
    return $h->{'Group'} || $defgr;
}

sub default_cmd {
    my ($self) = @_;
    my $host = $self->proj->host_role;
    return 'edit_phrase_list';
}

sub rights : CACHE {
    my ($self) = @_;
    my $rghts = $self->proj->user_states->getActions($self->login);
    $rghts = { %$rghts, ( $self->login."@" => 1, ) };
    return $rghts;
    return {  SSS => 1 }; 
}

1;

