package UserStates;
use strict;

use utf8;
use open ':utf8';

use base qw(ObjLib::StateActions ObjLib::ProjPart);


sub dbh {
    my $self = shift;
    return $self->proj->dbhlist->{$self->{dbhname}} if $self->{dbhname};
    return $self->proj->dbh;
}

sub init {
    my $self = shift;
    $self->{default_state} = 'USER_0';
}

sub getState {
    my ($self, $login) = @_;
    my $dbh = $self->dbh;
    my $res = $dbh->selectall_arrayref("select state from Users where login=".$dbh->quote($login))
        or $self->log("ERROR: can't get user state for login=$login: ".$dbh->errstr);
    return $res->[0][0] || $self->{default_state};
}

sub setState {
    my ($self, $login, $state) = @_;
    my $dbh = $self->dbh;
    my $str = join(',', $dbh->quote($login), $dbh->quote($state), );
    $dbh->do("replace into Users (login, state) values ($str)")
        or $self->log("ERROR: can't set banner state for login=$login: " . $dbh->errstr) and return;
    return 1;
}

sub logAction {

}

sub getIdsByStates {
    my ($self, $starr, %par) = @_;
    return ();
}

1;
