package WebCommon;

use Template;
use URI::Escape;
use FindBin;

use lib "$FindBin::Bin/../../lib";
use Utils::DB;
use Utils::Sys qw(md5_shuffle);

use lib "$FindBin::Bin/../../wlib";


our ( $template_path );

BEGIN {
    $template_path = "$FindBin::Bin/../../wtemplate";
};

sub set_template_path {
    my $newpath = shift;
    $template_path = $newpath;
}

sub CommonTemplate {
    return Template->new(
        INCLUDE_PATH => $template_path,
        EVAL_PERL    => 1,               # evaluate Perl code blocks
        PRE_CHOMP    => 1, 
        POST_CHOMP   => 1,
        ENCODING     => 'UTF-8',
   );
}

sub CatalogiaTemplate {

    my $prefdir = ($ENV{SERVER_SOFTWARE} =~ /Apache/) ? 'apache' : 'nginx';

    return Template->new(
        INCLUDE_PATH => $template_path,
        EVAL_PERL    => 1,               # evaluate Perl code blocks
        PRE_CHOMP    => 1, 
        POST_CHOMP   => 1,
        DEFAULT_ENCODING => 'UTF-8',
        ENCODING     => 'UTF-8',
        COMPILE_DIR  => '/tmp/ttc-'.$prefdir,
   );
}

sub CheckCatalogiaAuth  {
    use BlackboxSimple;
    my $login = BlackboxSimple::get_login();
    if ( $login eq "" ) {
        print "Content-type: text/html; charset=utf-8\n\n";
        WebCommon::CatalogiaTemplate()->process("no_auth.tmpl", { retpath => uri_escape("http://".$ENV{SERVER_NAME}.$ENV{REQUEST_URI}) });
        exit(0);
    }
    return $login;
}

sub UpdateVisitTime {
    my ( $dbh, $login ) = @_;
    $dbh->do("
        CREATE TABLE if not exists `CatalogiaVisits` (
        `Login` char(255) NOT NULL DEFAULT '',
          `UpdateTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`Login`)
        ) ENGINE=MyISAM DEFAULT CHARSET=utf8
    ") 
    or die $dbh->errstr;

    $dbh->do("replace into CatalogiaVisits (Login,UpdateTime) values (" . $dbh->quote($login) . ", now() )")
    or die $dbh->errstr;
    return 1;
}

1;
