#!/usr/bin/python
# -*- coding: utf-8 -*-

# Переписано со скрипта, использовавшего Berkanavt-библиотеку для выполнения YQL-запросов, на Аркадийный YQL
# Тикет https://st.yandex-team.ru/CATALOGIA-1244

import sys
import argparse
import os
import yt.wrapper as yt
import random
from bannerland.yql.tools import do_yql, get_client
from bm.yt_tools import get_yt_bm_config


DEFAULT_YT_POOL = "catalogia"


def random_id():
    res = ""
    for i in range(17):
        res += str(random.randint(0, 9))
    return res


def create_parser():
    parser = argparse.ArgumentParser()
    parser.add_argument('--timeout_hour')
    return parser


def main():
    is_yt_set_config = 0
    parser = create_parser()
    namespace = parser.parse_args(sys.argv[1:])
    timeout_hour = namespace.timeout_hour

    yt_pool = DEFAULT_YT_POOL
    if 'YT_POOL' in os.environ:
        yt_pool = os.environ['YT_POOL']

    query = 'pragma yt.Pool = "' + yt_pool + '";\n'
    for line in sys.stdin:
        query += line
    query = query.decode("utf-8")

    client = get_client('hahn')
    result = do_yql(client, query, timeout_hour=float(timeout_hour))

    for table in result:
        length = len(table.refs)

        if length != 0:
            yt_cluster = table.refs[0][0]
            table_path = table.refs[0][1]
        else:
            if not is_yt_set_config:
                yt_config = get_yt_bm_config(production=True)
                yt.update_config(yt_config)
                yt.update_config({"spec_defaults": {"data_size_per_job": 1024 ** 3}})  # 1G data size per job
                yt.update_config({"memory_limit": 1.5 * 1024 ** 3})
                is_yt_set_config = 1

            table_path = "tmp/robot-bm-admin/tmp_table_from_yql_" + random_id()
            yt.write_table("//" + table_path, ({table.column_names[i]: row[i] for i in range(len(row))} for row in table.rows))
            yt_cluster = yt.config["proxy"]["url"].split(".")[0]

        print "\t".join([yt_cluster, table_path])


if __name__ == "__main__":
    main()
