#!/usr/bin/env python
# -- coding: utf8 --

import getpass
import yt.yson as yson

from catalogia_mapper import run_catalogia_mapper


def main():

    # эти примеры - запускаемые, все входные таблицы лежат где должны лежать
    # если у вас не запускается либо падает свой код с run_catalogia_mapper() - то попробуйте для начала позапускать этот пример
    # если не заработает и он - обратитесь к нам, разработчикам

    src_prefix = "//home/catalogia/users/breqwas/catalogia_mapper_sample_data/"
    dst_prefix = "//tmp/catalogia_mapper_output_" + getpass.getuser() + "_"

    # TL;DR:
    # как сделать из таблицы с текстами таблицу с текстами + их категориями:
    run_catalogia_mapper(
        src_table=src_prefix + "texts_schematized",              # входная таблица (желательно схематизированная)
        dst_table=dst_prefix + "texts_schematized_categorized",  # будущая выходная таблица - копия исходной + колонка с результатами
        text_field="text",                                       # название колонки, в которой лежит текст для обработки
        targets={'categories': '_categories'}                    # { 'что посчитать по колонке $text_field' : 'в какую новую колонку положить результат' }
    )

    # подробнее:

    # пусть у нас есть таблица '$src_prefix/banners'
    # она содержит информацию о баннерах: все нужные поля, и ещё много ненужных. Схематизирована.
    # посчитаем по ней всё, что можем про баннер посчитать:

    run_catalogia_mapper(
        # входная таблица
        src_table=src_prefix + "banners",

        # выходная таблица
        # в неё будут скопированы все колонки входной (те, что перечислены в её схеме), и добавлены новые, с результатами вычислений
        # она будет схематизирована, как и входная, колонки с результатами будут добавлены к схеме
        # но она будет несортированной, поэтому все колонки в схеме потеряют 'sort_order', если они его имели
        dst_table=dst_prefix + "banners_extended_full",

        # имена колонок входной таблицы, в которых лежат данные баннера
        # в формате 'что': 'в какой колонке лежит'
        banner_fields={
            'title': 'title',
            'title_extension': 'title_extension',
            'body': 'body',
            'url': 'url',
            'phrases': 'phrases',

            # в нашей входной таблице все имена "по умолчанию",
            # но если у вас не так, и например ссылка, которую рекламирует баннер, лежит в колонке http_link, то так и укажите:
            # 'url': 'http_link'
        },

        # список того, что про баннер нужно посчитать
        # в формате 'что': 'в какую колонку положить результат'
        targets={
            'categories': '_bm_categories',    # категории Каталогии, через '/'
            'catids': '_bm_catids',            # внутренние ID категорий Каталогии, через ','
            'flags': '_bm_flags',              # флаги, через ','
            'directids': '_bm_directids',      # ID категорий как их хранит Директ, через ','
            'mediagroups': '_bm_mediagroups',  # медиагруппы, через '/'
            'mediaids': '_bm_mediaids',        # ID медиагрупп, через ','
        },
    )

    # теперь предположим, что у нас есть таблица '$src_prefix/texts'
    # она несхематизированная, но в каждой строке есть поле text, в котором лежат какие-то произвольные тексты
    # попробуем эти тексты категоризовать
    run_catalogia_mapper(
        src_table=src_prefix + "texts",
        dst_table=dst_prefix + "texts_categorized",

        # у входной таблицы нет схемы, поэтому укажем её вручную
        # если её не указывать (как в следующем запуске), то маппер тоже отработает, но все колонки в выходной таблице превратятся в строки, что не всегда хорошо
        src_schema=yson.YsonList([
            {"name": "bid", "type": "uint64"},
            {"name": "text", "type": "string"},
        ]),

        # имя поля, из которого нужно взять тексты для категоризации
        text_field="text",

        # поддерживаются все те же действия, что для баннера: categories, catids, flags, directids, mediagroups, mediaids
        targets={
            'categories': '_bm_categories',
            'catids': '_bm_category_ids',
        },
    )

    # кстати, с помощью этого маппера к текстам можно применять произвольные(*) методы bmapi
    # но если вы не знаете что это - скорее всего это вам не нужно
    run_catalogia_mapper(
        src_table=src_prefix + "texts",
        dst_table=dst_prefix + "texts_bmapi",
        text_field="text",

        targets={
            'bmapi': {
                'methods': ['get_wide_phrases', 'norm_phrase_list'],  # последовательность методов, которые надо применить к фразе
                'result_field': '_bmapi_result',                      # колонка, в которую будет положен итоговый результат
            }

            # (*) если вы попытались воспользоваться target='bmapi', но получили ошибку "unsupported bmapi method", то:
            # это значит что запрошенного вами метода нет в белом списке методов, разрешённых для запуска в YT
            # обратитесь к разработчикам: если метод безопасен для запуска в YT, то мы добавим его в белый список в течение дня
        },
    )


if __name__ == '__main__':
    main()
