# coding=utf-8
import logging


logger = logging.getLogger(__name__)


class CountRowReducer:
    def __init__(self, new_count_field_name):
        self.new_count_field_name = new_count_field_name
        pass

    def __call__(self, key, recs):
        tmp_key = dict()
        tmp_key.update(key)
        tmp_key[self.new_count_field_name] = sum(1 for _ in recs)
        yield tmp_key


def generate_bnr_count(bmyt_cl, src_banner_table, src_campaigns_table,
                       dst_banner_all_table, dst_banner_ru_table, dst_banner_tr_table):

    yt_client = bmyt_cl.yt_client

    with yt_client.Transaction() as tx,\
            yt_client.TempTable() as tmp_table:
        # get only active banners abd campanies!
        query = '''
        PRAGMA SimpleColumns;
        PRAGMA yt.InferSchema;

        INSERT INTO `{tmp_table}` WITH TRUNCATE
        SELECT
            banner.*
        FROM `{src_banner_table}` as banner
        INNER JOIN `{src_campaigns_table}` as comp
        USING (cid)
        WHERE
            banner.is_active == 1 AND
            comp.broad_match_flag == 'Yes' AND
            banner.phrases != ''
        '''.format(tmp_table=tmp_table,
                   src_banner_table=src_banner_table,
                   src_campaigns_table=src_campaigns_table)

        bmyt_cl.do_yql(query, title='filter active banner', transaction_id=tx.transaction_id)

        output_fields = {
            'phrase': str,
        }

        bm_mapper = {
            'begin': '''
                use BM::Banners::BannerFactory;
                use BM::Banners::LBannerBM;

                use BaseProject;

                my $proj = BaseProject->new({
                    load_languages => [ qw(ru en tr) ],
                    load_dicts => 1, # норм снорм осн словари
                    load_minicategs_light => 1, # категоризация
                    allow_lazy_dicts => 1,
                    use_comptrie_subphraser => 1, # ходить в сабфрейзер (сейчас не ходить)
                    use_sandbox_categories_suppression_dict => 1,
                });

                $self->{proj} = $proj;
            ''',

            'mapper': '''
                my $proj = $self->{proj};

                my $yt_banners_mapping = { map { $_->{yt_field} => $_->{mysql_field} } @{$proj->options->{yt_direct_banners_mapping}} };

                my $mysql_hash = { map { $yt_banners_mapping->{$_} => $r->{$_} } ( grep { defined $yt_banners_mapping->{$_} } keys(%$r) )};

                my $bnr = $proj->bf->lbanner($mysql_hash);
                my $bnr_lang = $bnr->lang;

                for my $phr ($bnr->phrases) {
                    yield( { phrase => $phr->norm_phr} => BNR_COUNTS);
                }

                if ($bnr_lang eq 'ru') {
                    for my $phr ($bnr->phrases) {
                        yield( { phrase => $phr->norm_phr} => BNR_COUNTS_RU);
                    }
                }

                if ($proj->geo->has_tr_region_id($bnr->targetting)) {
                    for my $phr ($bnr->phrases) {
                        yield( { phrase => $phr->norm_phr} => BNR_COUNTS_TR);
                    }
                }
            ''',
            'dst_names': ['BNR_COUNTS', 'BNR_COUNTS_RU', 'BNR_COUNTS_TR'],
            'dst_fields': [output_fields] * 3
        }

        dst_tables = [dst_banner_all_table, dst_banner_ru_table, dst_banner_tr_table]
        tmp_dst_tables = [x + '.tmp' for x in dst_tables]

        bmyt_cl.run_bm_map(
            bm_mapper,
            tmp_table,
            tmp_dst_tables,
        )

        for table in dst_tables:
            tmp_table = table + '.tmp'
            logger.info('start for table %s', table)

            yt_client.remove(table, force=True)
            yt_client.create_table(table, attributes={'schema': [{'name': 'count', 'type': 'uint64'}, {'name': 'phrase', 'type': 'string'}]})

            yt_client.run_map_reduce(
                None,
                CountRowReducer(new_count_field_name='count'),
                tmp_table,
                table,
                reduce_by=['phrase']
            )

            yt_client.run_sort(table, sort_by=["phrase"])
            logger.info('/ end for table %s', table)
