#!/usr/bin/env python
# coding=utf-8


def mapper(r):
    if r['freq_query'] > 0:
        yield {'norm': r['norm'], 'freq_query': r['freq_query']}


def aggregator(key, rows):
    res = dict(key)
    res['freq_query'] = 0
    for row in rows:
        res['freq_query'] += int(row['freq_query'])
    yield res


def generate_counts_query(yt_client, src_table, dst_table):
    yt_client.run_map_reduce(
        mapper,
        aggregator,
        src_table,
        dst_table,
        reduce_by=["norm"])

    yt_client.run_sort(dst_table, sort_by=["norm"], spec={"combine_chunks": True})
