#!/usr/bin/perl
use strict;

use utf8;
use open ":utf8";

use FindBin;
use lib "$FindBin::Bin/../../lib";
use Project;
use Utils::Common;
use Data::Dumper;
use Utils::Sys qw/
    get_file_lock release_file_lock
    handle_errors
/;
use Utils::Urls qw(url_to_domain get_sec_level_domain);

get_file_lock() or exit(0);
handle_errors();

my $proj = Project->new();
$proj->log('start collect');

my $days = 90;

my @dyn_data = ();
for my $tablename ('DynTasks', 'PerfTasks') {
	my $table_data = $proj->dbtable($tablename, undef, 'bannerland_dbh')->List_SQL(
		"SELECT DISTINCT Domain FROM $tablename WHERE end BETWEEN CURDATE() - INTERVAL $days DAY AND NOW()");
	push(@dyn_data, map{$_->{Domain}} @$table_data);
}

# костыль для теста отдельных доменов
my $additional_domains = '
стильный-ремонт.рф
ремонт-экспресс.рф
remont-f.ru
remontvspb.ru
studia-remontov.ru
русский-ремонт.рф
luxvann.ru
smartremont.pro
abada.ru
coloss.ru
europcar.ru
dieselironside5bar.belousss.ru
бангкок35.рф
атк52.рф
artmotors93.ru
tk-global.ru
joom.com
joom.ru
';
my @add_domains = split(/\n/,$additional_domains);

my $bad_domains = {};
open(my $fh, $proj->options->{dicts} . '/dyn_bad_domains');
while (my $row = <$fh>) {
    chomp $row;
    $bad_domains->{$row} = 1;
}
close($fh);
my $bad_domains_2level = {};
open($fh, $proj->options->{dicts} . '/dyn_bad_domains_2level');
while (my $row = <$fh>) {
    chomp $row;
    $bad_domains_2level->{$row} = 1;
}
close($fh);

my $all_data = {};
for (@dyn_data, @add_domains) {
    next unless $_;
    unless ($bad_domains->{url_to_domain($_)} || $bad_domains_2level->{get_sec_level_domain($_)}) {
        $all_data->{$_} = 1;
    }
}

my $filename = $proj->get_tempfile('domains');
open($fh, '>', $filename) or die "Could not open file '$filename' $!";
map{print $fh "$_\n"} keys %$all_data;
close $fh;
$proj->log('end collect');

$proj->log('start upload');
$proj->yt_client->write_tsv_file($filename, "//home/bannerland/data/dse/preparing/dyn-perf-domains-tmp", ["Domain"], ["string"]);
$proj->log('end upload');

$proj->do_sys_cmd("ARCADIA_ROOT=/opt/arcadia $FindBin::Bin/copy_direct_domains/copy_direct_domains");

release_file_lock();
exit(0);
