#!/usr/bin/env python
# coding=utf8
# Данный скрипт выгружает тег=значение из кондуктора и кладет их в место, откуда ansible смотрит переменные (именно ansible vars не ansible теги)
# Дополнительно выставляет is_iron=True
# После этого запускает ansible-pull из нашего github репозитория
import urllib
import os
from subprocess import check_call
ANSIBLE_TAGS_FILE_PATH = '/root/.ansible_vars_file'
SEPARATOR = ': '


def host_tags_from_conductor():
    hostname = open('/etc/hostname').readline()
    url = 'https://c.yandex-team.ru/api/get_host_tags/{}'.format(hostname)
    res = urllib.urlopen(url)
    if res.code != 200:
        print "ERROR: request {} failed; status code: {}".format(url, res.code)
        print "Fallback to use local file"
        if not os.path.exists(ANSIBLE_TAGS_FILE_PATH):
            raise Exception("No exists file: ANSIBLE_TAGS_FILE_PATH = "+str(ANSIBLE_TAGS_FILE_PATH))
    else:
        tmp_file = ANSIBLE_TAGS_FILE_PATH + "_tmp"
        res_text = res.read()
        with open(tmp_file, "w") as f:
            f.write('# from get_conductor_tags.py (deb pkg yandex-bm-ansible-pull) \n')
            f.write('is_iron: True\n')
            f.write('\n')
            f.write('# from conductor host tags:\n')
            for line in res_text.split('\n'):
                if line and '=' in line:
                    key, val = line.split('=', 2)
                    f.write('{}{}{}\n'.format(key, SEPARATOR, val))
        os.rename(tmp_file, ANSIBLE_TAGS_FILE_PATH)
        print "UPDATE OK "


def run_ansible_pull():
    ansible_vars = {}
    with open(ANSIBLE_TAGS_FILE_PATH) as f:
        for line in f.readlines():
            if line.startswith('#'):
                continue

            if SEPARATOR in line:
                k, v = line.split(SEPARATOR, 1)
                ansible_vars[k] = v

    cmd = 'ansible-pull -i localhost, -U https://github.yandex-team.ru/IRT/ansible-playbooks.git -vvvv'
    if "ansible_pull_branch" in ansible_vars:
        cmd += " --checkout={}".format(ansible_vars["ansible_pull_branch"])
    check_call(cmd, shell=True)


if __name__ == '__main__':
    host_tags_from_conductor()
    run_ansible_pull()
