from tqdm import tqdm, tqdm_notebook


try:
    # Not adding YT to ya.make in interface module
    # Assuming if you need YT you add it independently
    import yt.wrapper as yt
except ImportError:
    yt = None

try:
    # Use Label and display for smart description in Jupyter
    from ipywidgets import Label
    from IPython.display import display
except ImportError:
    Label = None
    display = None


def in_notebook():
    try:
        from IPython import get_ipython
        get_ipython = 'IPKernelApp' in get_ipython().config or 'ArcadiaKernelApp' in get_ipython().config
    except ImportError:
        get_ipython = False
    return get_ipython


def progress_bar(*args, **kwargs):
    # type: (...) -> tqdm.tqdm
    """
    Return constructed tqdm.tqdm_notebook in Jupyter and tqdm.tqdm in console
    :param args: Args for tqdm
    :param kwargs: Kwargs for tqdm
    :return: Constructed tqdm
    """
    return tqdm_notebook(*args, **kwargs) if in_notebook() else tqdm(*args, **kwargs)


def read_table_pbar(table, desc=None, client=None, *args, **kwargs):
    if yt is None:
        raise RuntimeError("You should add yt/python/client to your ya.make in order to use yt.wrapper")
    if desc is not None and in_notebook() and callable(display) and callable(Label):
        display(Label(desc))
        desc = None
    total_rows = yt.get(yt.ypath_join(str(table), '@row_count'), client=client)
    return progress_bar(yt.read_table(table, client=client, *args, **kwargs), total=int(total_rows), desc=desc)


__all__ = [
    'in_notebook', 'read_table_pbar'
]
