import logging
import os
from sandbox.common.types.misc import OSFamily
import sandbox.common.upload as _sandbox_upload

logger = logging.getLogger(__name__)


SANDBOX_URL = 'https://sandbox.yandex-team.ru'
SANDBOX_PROXY_URL = 'http://proxy.sandbox.yandex-team.ru'


def _upload(
    path,
    resource_owner,
    resource_type,
    description,
    sandbox_token,
    attrs=None
):
    logger.info('Try to upload \'%s\'', path)

    file_meta = _sandbox_upload.HTTPHandle.FileMeta(
        open(path, 'rb'),
        os.stat(path).st_size,
        os.path.basename(path)
    )
    h = _sandbox_upload.HTTPHandle(
        _sandbox_upload.HTTPHandle.ResourceMeta(
            resource_type,
            OSFamily.ANY,
            resource_owner,
            description,
            attrs,
            release_to_yd=False,
        ),
        sandbox_token,
        SANDBOX_URL,
        SANDBOX_PROXY_URL,
        None,
        file_meta
    )

    last = list(h())[-1]

    task_id = last.meta['task']['id']
    logger.info('File \'%s\' uploaded sucessfully, task_id: %d', path, task_id)
    return task_id
