import json
import logging
import requests
from irt.common.base_json_adapter import BaseJSONApiAdapter


class StaffAdapter(BaseJSONApiAdapter):
    API_URL = 'https://staff-api.yandex-team.ru/v3/{request}'

    def __init__(self, token):
        self._token = token

    def get_user_by_telegram(self, tlgrm):
        """
        Get user staff data JSON by tlgrm account
        :param tlgrm: Telegram nickname
        :return: User JSON
        """
        query_params = {
            '_query': 'accounts==match({})'.format(json.dumps({"type": "telegram", "value_lower": tlgrm})),
            '_fields': 'login,accounts'
        }

        req = self._request(requests.get,
                            self.API_URL.format(request="persons"),
                            result_field='result',
                            headers={"Authorization": "OAuth {}".format(self._token)},
                            params=query_params)
        if req is not None:
            if req:
                return req[0]
            logging.info('No data for StaffAdapter.get_user_by_telegram({}{}{})'.format(tlgrm[0], '*' * (len(tlgrm) - 2), tlgrm[-1]))
        else:
            logging.error('Bad request StaffAdapter.get_user_by_telegram()')
