from library.python.svn_version import svn_revision, svn_branch, svn_tag

from . import sandbox
from .sandbox import download_file

from .classes import Singleton, SingletonMetaclass

from .deploy import get_deploy_dc,\
    get_deploy_dynamic_pod_fqdn, get_deploy_node_fqdn, get_deploy_pod_fqdn,\
    get_deploy_pod_id,\
    get_deploy_box_ipv6

from .file_utils import open_resource_or_file, read_env_or_file

from .file_utils import to_json, to_yml, to_csv, to_tsv
from .file_utils import from_json, from_yml, from_csv, from_tsv

from .file_utils import get_user_config_file, get_system_config_file, get_user_app_path, makedirs

from .file_utils import TemporaryDirectory

from .dates import get_duration

from .iter import chunks, ensure_list, list_like

from .yav import get_secrets

from .yt import get_current_yt_cluster, get_current_yt_job_id, get_current_yt_operation_id, is_inside_yt_job, is_inside_local_yt_job

from .rm import ReleaseInfo

from .request import make_json_request

from .strings import strip_html


def get_version():
    """ String package version based on arcadia revision. Non-trunk revisions are -1. """

    return "r" + str(svn_revision()) if svn_revision() > 0 else "r0"


__version__ = get_version()


class suppress:
    """Context manager to suppress specified exceptions

    After the exception is suppressed, execution proceeds with the next
    statement following the with statement.

         with suppress(FileNotFoundError):
             os.remove(somefile)
         # Execution still resumes here if the file was already removed
    """

    def __init__(self, *exceptions):
        self._exceptions = exceptions

    def __enter__(self):
        pass

    def __exit__(self, exctype, excinst, exctb):
        # Unlike isinstance and issubclass, CPython exception handling
        # currently only looks at the concrete type hierarchy (ignoring
        # the instance and subclass checking hooks). While Guido considers
        # that a bug rather than a feature, it's a fairly hard one to fix
        # due to various internal implementation details. suppress provides
        # the simpler issubclass based semantics, rather than trying to
        # exactly reproduce the limitations of the CPython interpreter.
        #
        # See http://bugs.python.org/issue12029 for more details
        return exctype is not None and issubclass(exctype, self._exceptions)


__all__ = [
    'suppress',
    'chunks', 'ensure_list', 'list_like',
    'make_json_request',
    'get_secrets',
    'get_version', 'svn_revision', 'svn_branch', 'svn_tag',
    # Classes
    'Singleton', 'SingletonMetaclass',

    # Sandbox
    'sandbox', 'download_file',

    # File utils
    'to_json', 'to_yml', 'to_csv', 'to_tsv',
    'from_json', 'from_yml', 'from_csv', 'from_tsv',
    'get_user_config_file', 'get_system_config_file', 'get_user_app_path',
    'read_env_or_file', 'open_resource_or_file',
    'makedirs',
    'TemporaryDirectory',

    # Datetime utils
    'get_duration',

    # YT utils
    'get_current_yt_cluster', 'get_current_yt_job_id', 'get_current_yt_operation_id',
    'is_inside_yt_job', 'is_inside_local_yt_job',

    # Y.Deploy
    'get_deploy_dc',
    'get_deploy_dynamic_pod_fqdn', 'get_deploy_node_fqdn', 'get_deploy_pod_fqdn',
    'get_deploy_pod_id',
    'get_deploy_box_ipv6',

    # ReleaseMachine
    'ReleaseInfo',

    # Strings
    'strip_html',
]
