from six import with_metaclass


class SingletonMetaclass(type):
    _instances = {}

    def __call__(cls, *args, **kwargs):
        if cls not in cls._instances:
            cls._instances[cls] = type.__call__(cls, *args, **kwargs)
        return cls._instances[cls]


class Singleton(with_metaclass(SingletonMetaclass)):
    pass


__all__ = ['Singleton', 'SingletonMetaclass']
