import os

import netifaces as ni


def get_deploy_dc():
    return os.getenv('DEPLOY_NODE_DC', None)


def get_deploy_pod_id():
    return os.getenv('DEPLOY_POD_ID', None)


def get_deploy_node_fqdn():
    return os.getenv('DEPLOY_NODE_FQDN', None)


def get_deploy_pod_fqdn():
    return os.getenv('DEPLOY_POD_PERSISTENT_FQDN', None)


def get_deploy_dynamic_pod_fqdn():
    return os.getenv('DEPLOY_POD_TRANSIENT_FQDN', None)


def get_deploy_box_ipv6():
    interfaces = ni.interfaces()
    if 'veth' in interfaces:
        return ni.ifaddresses('veth').get(ni.AF_INET6, [{'addr': None}])[0]['addr']
