import itertools
import six
import six.moves.collections_abc as collections_abc
import typing


def list_like(arg):
    # type: (typing.Any) -> bool
    """
    Check argument is list_like.

    :param arg: Any object
    :return:
    """
    return (
        isinstance(arg, collections_abc.Iterable)
        and not isinstance(arg, six.string_types)
        and not isinstance(arg, six.binary_type)
    )


def ensure_list(candidate):
    # type: (typing.Any) -> typing.List
    """
    If candidate is iterable convert it to list, else return list with single element equal to `candidate`.

    :param candidate: Any object
    :return: List of objects
    """
    return list(candidate) if list_like(candidate) else [candidate]


def chunks(iterable, size=100):
    # type: (typing.Iterable, int) -> typing.Generator[itertools.chain]
    """
    Split any iterable object into chunks with size not more then `size`.

    .. warning::
      Reader must read chunk to the end
    .. warning::
      Reader can't read chunk twice

    :param iterable: Iterable object.
    :param size: Size of chunks
    :return: Generator with chunks
    """
    iterator = iter(iterable)
    for first in iterator:
        yield itertools.chain([first], itertools.islice(iterator, size - 1))
