import logging

logger = logging.getLogger(__name__)


def make_json_request(method, url, result_field=None, **kwargs):
    res = method(url, **kwargs)
    if res.ok:
        try:
            return res.json()[result_field] if result_field is not None else res.json()
        except Exception as e:
            logger.error(e)


__all__ = ['make_json_request']
