import re

import library.python.svn_version as svn_version


class ReleaseInfo(object):
    """
    Get release info from release branches.

    Default template for release tag is '{component_name}/{tag_prefix}-{major}-{minor}'.
    """

    BRANCHED_TEMPLATE = r'^(.*?)/(.*?)-(\d+)-(\d+)$'
    TAGGED_TEMPLATE = r'^(.*?)/(.*?)-(\d+)$'

    __template = BRANCHED_TEMPLATE

    @classmethod
    def set_template(cls, template):
        cls.__template = template

    def __init__(self):
        self._prefix = svn_version.svn_branch()
        self._major = self._revision = svn_version.svn_revision()

        self._minor = None
        self._component = None

        match = re.match(self.__template, svn_version.svn_branch())
        if match is not None:
            self._component = match.group(1)
            self._prefix = match.group(2)
            self._major = int(match.group(3))
            try:
                self._minor = int(match.group(4))
            except IndexError:
                pass

    @property
    def major(self):
        return self._major

    @property
    def minor(self):
        return self._minor

    @property
    def component(self):
        return self._component

    @property
    def prefix(self):
        return self._prefix

    @property
    def revision(self):
        return self._revision


__all__ = (
    'ReleaseInfo'
)
