import six.moves.html_parser as html_parser
import six


class HTMLStripper(html_parser.HTMLParser):
    def __init__(self):
        html_parser.HTMLParser.__init__(self)
        self.reset()
        self.strict = False
        self.convert_charrefs = True
        self.text = six.StringIO()

    def handle_data(self, d):
        self.text.write(d)

    def get_data(self):
        return self.text.getvalue()


def strip_html(text):
    s = HTMLStripper()
    s.feed(text)
    return s.get_data()
