import os
import sys
import six

try:
    from library.python.vault_client.instances import Production as VaultClient
    from library.python.vault_client.errors import ClientError

    def get_secrets(secret_id, store=None, token=os.getenv('YAV_TOKEN')):
        if token is None:
            return {}
        try:
            yav_client = VaultClient(authorization='OAuth {}'.format(token))
        except ClientError:
            return {}

        secret = yav_client.get_version(secret_id)['value']

        if isinstance(store, six.string_types):
            module = sys.modules[store]
            for key in secret:
                setattr(module, key, secret[key])
        elif store is not None:
            for key in secret:
                setattr(store, key, secret[key])

        return secret
except ImportError:
    VaultClient = None
    ClientError = None

    def get_secrets(*args, **kwargs):
        raise RuntimeError('Please add library/python/vault_client to PEERDIR')


__all__ = ['get_secrets']
