import os


def get_current_yt_cluster():
    """
    Get current cluster name. For local YT return False
    :return: Cluster name or None
    """
    return os.getenv('YT_CLUSTER_NAME')


def get_current_yt_operation_id():
    """
    Get current YT operation id
    :return: YT operation id or None
    """
    return os.getenv('YT_OPERATION_ID')


def get_current_yt_job_id():
    """
    Get current YT job id
    :return: YT job id or None
    """
    return os.getenv('YT_JOB_ID')


def is_inside_yt_job():
    """
    Detect if we are running inside YT job
    In every YT job must be YT_JOB_ID variable, but we are checking some more data
    :return: True if we are running inside YT job else False
    """
    return bool(get_current_yt_operation_id() and get_current_yt_job_id())


def is_inside_local_yt_job():
    """
    Detect if we are running inside YT job
    In every YT job must be YT_JOB_ID variable, but we are checking some more data
    :return: True if we are running inside YT job else False
    """
    return is_inside_yt_job() and get_current_yt_cluster() is None
