# coding=utf-8
import argparse
import logging
import os

import yenv

from irt.utils import get_secrets

from .bot import IrtBot

logging.basicConfig(format='%(asctime)s - %(name)s - %(levelname)s - %(message)s', level=logging.INFO)

YT_ACCOUNT = os.getenv('YT_ACCOUNT', 'multik')

TRACKER_QUEUES = ('covid', 'multik', 'supbl', 'irt', 'dynsmart', 'catsup')

ABC_ID = os.getenv('ABC_ID')
if ABC_ID is not None:
    ABC_ID = int(ABC_ID)

STABLE, PRESTABLE, DEVELOPMENT = 'production', 'prestable', 'development'

SECRETS = {
    STABLE: 'sec-01e327a8372cwfawapkqn38znv',
    PRESTABLE: 'sec-01e3efgjte6fx20cqb4bxmnt8a',
    DEVELOPMENT:  'sec-01e5gk01e6wbvt1cf9edfp9kq6',
}

YA_IRT_BOT_TOKEN, ARTMON_TOKEN, YT_TOKEN, ST_TOKEN = None, None, None, None  # Will get from secrets


def main():
    """Run the bot."""
    parser = argparse.ArgumentParser(description='IRT bot binary')
    parser.add_argument('--contour',
                        help='Run with Bot with production/prestable/development contour',
                        default=yenv.type,
                        choices=(STABLE, PRESTABLE, DEVELOPMENT))
    parser.add_argument('--no-lock', action='store_false', dest='lock', help='Run bot without lock', default=None)
    parser.add_argument('--lock', action='store_true', help='Run bot with lock', default=None)
    parser.add_argument('--port', type=int, default=5000, help='Port for liveness check')

    args = parser.parse_args()

    if args.lock is None:
        args.lock = args.contour != DEVELOPMENT

    get_secrets(SECRETS[args.contour], __name__)

    IrtBot(YA_IRT_BOT_TOKEN, ARTMON_TOKEN, YT_TOKEN, YT_ACCOUNT, ST_TOKEN,
           TRACKER_QUEUES,
           abc_id=ABC_ID,
           contour=args.contour,
           liveness_port=args.port).loop(args.lock)


if __name__ == '__main__':
    main()
