# -*- coding: utf-8 -*-

import irt.bannerland.hosts
import irt.broadmatching.common_options


def get_srcs():
    """
    :return: возваращает список железных ресурсов, хранящихся на bmgen-е
    """
    perl_common_options = irt.broadmatching.common_options.get_options()
    srcs_dict = dict()

    # Ресурсы роли 'bmcdict-gen' (Chronicle, Cdict и Datoteka)
    bmcdict_gen_hosts = irt.bannerland.hosts.get_hosts_by_role("bmcdict-gen")
    for cdict in ["ChronicleCdict_params", "DatotekaCdict_params"]:
        srcs_dict[perl_common_options[cdict]["single_file"]] = bmcdict_gen_hosts

    return srcs_dict


def short_src_path(path):
    """
    :param path: полный путь к файлу
    :return: сокращенный путь к файлу (без стартового /opt/arcadia/...)
    """
    short_path = "/".join(x for x in path.split("/")[5:])
    if not short_path:
        short_path = path
    return short_path
