# -*- coding: utf-8 -*-

HDD = 'default'
SSD_BLOBS = 'ssd_blobs'
SSD_JOURNALS = 'ssd_journals'

# Разновидности дисковых ресурсов для наших аккаунтов на YT
YT_DISK_ACCOUNTS = {
    'arnold': {
        'bannerland': {HDD, SSD_BLOBS},
        'catalogia': {HDD},
        'irt': {HDD},
        'multik': {HDD},
    },
    'hahn': {
        'bannerland': {HDD, SSD_BLOBS, SSD_JOURNALS},
        'broadmatching': {HDD},
        'catalogia': {HDD, SSD_BLOBS, SSD_JOURNALS},
        'irt': {HDD},
        'multik': {HDD, SSD_BLOBS},
    },
    'markov': {
        'bannerland': {HDD},
        'multik': {HDD},
    },
    'seneca-sas': {
        'multik': {HDD, SSD_BLOBS},
    },
    'seneca-vla': {
        'multik': {HDD, SSD_BLOBS},
    },
}

SOLOMON_TS_TEMPLATE = {'project': 'yt', 'service': 'accounts'}


def get_config():
    return YT_DISK_ACCOUNTS


def get_default_sources():
    return {'chunk_count', 'node_count'}


def get_source_sensor(account, cluster, source_name):
    if source_name in (HDD, SSD_BLOBS, SSD_JOURNALS):
        return dict(SOLOMON_TS_TEMPLATE, sensor='disk_space_in_gb', account=account, cluster=cluster, medium=source_name)
    return dict(SOLOMON_TS_TEMPLATE, sensor=source_name, account=account, cluster=cluster)


def get_source_limit_sensor(account, cluster, source_name):
    if source_name in (HDD, SSD_BLOBS, SSD_JOURNALS):
        return dict(SOLOMON_TS_TEMPLATE, sensor='disk_space_limit_in_gb', account=account, cluster=cluster, medium=source_name)
    return dict(SOLOMON_TS_TEMPLATE, sensor='{}_limit'.format(source_name), account=account, cluster=cluster)


def get_display_source_name(source_name):
    return 'hdd' if source_name == HDD else source_name
