# -*- coding: utf-8 -*-

# Спеки мониторящихся нами YT-таблиц (см. https://st.yandex-team.ru/DYNSMART-945)
# Желательно соблюдать сортировку по "juggler_aggr_service". :)
yt_tables_spec = [

    # Экспортные таблицы для БК (одна - на Hahn, другая - на Arnold) с токенами баннеров, их нормами, снормами, языками и флагами стоп-слов
    {
        "juggler_aggr_service": "broad_phrase_norm_export",
        "yt_path": "//home/bannerland/export/BroadPhraseNorm",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_broad_phrase_norm_export_hahn",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 12,
        "min_rows": 6000000,
    },

    {
        "juggler_aggr_service": "broad_phrase_norm_export",
        "yt_path": "//home/bannerland/export/BroadPhraseNorm",
        "yt_cluster": "arnold",
        "solomon_alert_id": "yt_broad_phrase_norm_export_arnold",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_arnold",
        "max_hours_old": 12,
        "min_rows": 6000000,
    },

    # ======================================== catalogia_banners =========================================
    {   # Таблица всех баннеров Директа с категоризацией Каталогией
        # Планируется к закапыванию летом 2022 г. (пока поддерживаем на всякий случай)
        "juggler_aggr_service": "catalogia_banners",
        "yt_path": "//home/catalogia/catalogia-banners-recategorized-fast",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_catalogia-banners-recategorized-fast",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 120,
        "min_rows": 6000000000,
    },

    {   # Все баннеры Директа
        "juggler_aggr_service": "catalogia_banners",
        "yt_path": "//home/catalogia/banners_extended",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_banners_extended",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 72,
        "min_rows": 6000000000,
    },

    # =============================================== cdict ===============================================

    {   # Cdict 'datoteka'
        "juggler_aggr_service": "cdict",
        "yt_path": "//home/broadmatching/work/cdict/cdict_datoteka",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_cdict_datoteka",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 168,
        "min_rows": 3000000000,
    },

    {   # Cdict 'chronicle'
        "juggler_aggr_service": "cdict",
        "yt_path": "//home/broadmatching/work/cdict/cdict_chronicle",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_cdict_chronicle",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 168,
        "min_rows": 4500000000,
    },

    # ============================================ direct_tables ============================================

    {   # Директовая экспортная таблица по группам РК
        "juggler_aggr_service": "direct_tables",
        "yt_path": "//home/direct/export/bm/bm_adgroups",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_direct_bm_adgroups",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 72,
        "min_rows": 3200000000,
    },

    {   # Директовая экспортная таблица по баннерам
        "juggler_aggr_service": "direct_tables",
        "yt_path": "//home/direct/export/bm/bm_banners",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_direct_bm_banners",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 72,
        "min_rows": 6400000000,
    },

    {   # Директовая экспортная таблица по РК
        "juggler_aggr_service": "direct_tables",
        "yt_path": "//home/direct/export/bm/bm_campaigns",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_direct_bm_campaigns",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 72,
        "min_rows": 30000000,
    },

    # ================================================= dse =================================================

    {   # Актуальный список "хороших" (не сильно частотных) доменов в динамиках и смартах (нужен для генерации DSE)
        "juggler_aggr_service": "dse",
        "yt_path": "//home/bannerland/data/dse/preparing/dyn-perf-domains",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_dyn-perf-domains",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 36,
        "min_rows": 1200000,
    },

    {   # Источник 'links' (пофильтрованный и обработанный), использующийся для генерации DSE
        "juggler_aggr_service": "dse",
        "yt_path": "//home/bannerland/stable/data/dse/preparing/filtered_links",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_filtered_links",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 56,
        "min_rows": 25000000000,
    },

    {   # Источник пар <URL, Title> из KWYT для доменов из 'dyn-perf-domains'
        "juggler_aggr_service": "dse",
        "yt_path": "//home/bannerland/data/dse/preparing/kwyt_banners",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_kwyt_banners",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 150,
        "min_rows": 13000000000,
    },

    {   # Базовая таблица DSE, на основе которых формируются источники DSE в смартах и динамиках
        "juggler_aggr_service": "dse",
        "yt_path": "//home/bannerland/data/dse/preparing/dse_base",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_dse_base",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 144,
        "min_rows": 14000000000,
    },

    {   # DSE
        "juggler_aggr_service": "dse",
        "yt_path": "//home/bannerland/data/dse/result/dse_banners",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_dse_banners",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 144,
        "min_rows": 6500000000,
    },

    # ========================================= dyn_trashfilter =========================================

    {   # Нужна для банщика в динамиках. Цель банщика - отсеять плохие сгенерированные фразы с точки зрения статистики.
        # На основе информации по кликам, показам и CTR в рамках каждой из фраз мы можем произвести эту фильтрацию.
        "juggler_aggr_service": "dyn_trashfilter",
        "yt_path": "//home/bannerland/stable/data/trashfilter/bad_dyn_phrases",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_Bad_dyn_phrases",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 60,
        "min_rows": 90000,
    },

    {   # Информация, сагрегированная из основной таблицы банщика 'bad_dyn_phrases'
        # и подготовленная для записи в файл банщика для Bannerland-а
        "juggler_aggr_service": "dyn_trashfilter",
        "yt_path": "//home/bannerland/stable/data/trashfilter/grouped_bad_dyn_phrases",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_grouped_bad_dyn_phrases",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 60,
        "min_rows": 5000,
    },

    # ======================================== video_direct_groups ========================================

    {   # Соответствие id видеогруппы и его наименования
        "juggler_aggr_service": "video_direct_groups",
        "yt_path": "//home/catalogia/id2videodirectgroup",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_id2videodirectgroup",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 24,
        "min_rows": 50,
    },

    {   # Второй уровень группировки групп видеоподложек (используется видеорекламщиками)
        "juggler_aggr_service": "video_direct_groups",
        "yt_path": "//home/catalogia/videodirectgroups_second_level",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_videodirectgroups_second_level",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 24,
        "min_rows": 250,
    },

    # ========================================= web_master_tables =========================================

    {   # Cтатистика по поисковой выдаче: запросам, URL-ам на выдаче, кликам, показам, регионам.
        # Нужна для генерации источников 'dyn_sources' в динамиках. Это копия таблички от Вебмастера с Арнольда.
        "juggler_aggr_service": "web_master_tables",
        "yt_path": "//home/bannerland/data/dyn_phrase_sources/raw_queries-v2",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_raw_queries",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 240,
        "min_rows": 130000000000,
    },

    {   # Источник 'links': представляет из себя привязку урлов гиперссылок к их заголовкам.
        # Нужен в рамках генерации DSE и для источника 'links' в динамиках. Это копия таблички от Вебмастера с Арнольда.
        "juggler_aggr_service": "web_master_tables",
        "yt_path": "//home/bannerland/data/dyn_phrase_sources/raw_links",
        "yt_cluster": "hahn",
        "solomon_alert_id": "yt_raw_links",
        "solomon_service": "monitor_yt_tables",
        "solomon_cluster": "yt_hahn",
        "max_hours_old": 240,
        "min_rows": 4500000000,
    },
]
