# -*- coding: utf-8 -*-

from bannerland.archive_workers.aw_configs import get_worker_attr_names
from irt.monitoring.juggler.configs.lib import PROD_TELEGRAM_CHANNEL, telegram_notification_rules, get_classic_aggregate
from juggler_sdk import Child


def get_checks():
    """
    :return: Возвращает список агрегатов для Bannerland-а в YT
    """
    return get_checks_for_task_type("dyn") + get_checks_for_task_type("perf")


def get_checks_for_task_type(task_type):
    module_notifications = telegram_notification_rules(PROD_TELEGRAM_CHANNEL)
    juggler_host = "bannerland_yt"

    checks = []

    # Генерация смартов в YT
    gen_items = ["make_banners", "last_archive_make_banners"]

    gen_aggr = get_classic_aggregate(
        aggr_host=juggler_host,
        aggr_service="{}_generation".format(task_type),
        notification_rules=module_notifications,
        simple_children=[{"host": "yt_hahn", "service": "{}.{}.bannerland_yt.irt".format(key, task_type)} for key in gen_items],
        description="[{}] Генерация в YT".format(task_type),
    )

    gen_aggr["children"].append(Child(
        host="yt_hahn",
        service="avatars_delay.{}.bannerland_yt.irt".format(task_type),
    ))
    gen_aggr["children"].append(Child(
        host="yt_hahn",
        service="__ontime__.avatars_cache_hours_old.prepare_input.{}.irt".format(task_type),
    ))
    gen_aggr["children"].append(Child(
        host="yt_hahn",
        service="avatars_put.{}.bannerland_yt.irt".format(task_type),
    ))

    checks.append(gen_aggr)

    # FullState
    fs_items = ["__ontime__.actuality", "children_count", "domains_count", "orders_count", "phrases_count", "tasks_count"]
    checks.append(get_classic_aggregate(
        aggr_host=juggler_host,
        aggr_service="{}_full_state".format(task_type),
        notification_rules=module_notifications,
        simple_children=[{"host": "yt_hahn", "service": "{}.{}.full_state.bannerland_yt.irt".format(key, task_type)} for key in fs_items],
        description="[{}] Full State".format(task_type),
        only_value=True,
    ))

    if task_type == "dyn":
        # dyn_bs_log
        dyn_bs_log_re = [
            dict(host="yt_hahn", service="dyn_bs_log.{}.bannerland.irt".format(property))
            for property in ["last_success_days_ago", "row_count"]
        ]
        checks.append(get_classic_aggregate(
            aggr_host=juggler_host,
            aggr_service="dyn_bs_log",
            notification_rules=module_notifications,
            simple_children=dyn_bs_log_re,
            description="dyn_bs_log",
        ))

    # Успешность завершения работы архивариусов
    cypress_config_mode = "prod"
    cluster_attr_names = {
        "yt_hahn": [x for archive_worker_type in ["pocket", "full_state"] for x in get_worker_attr_names(task_type, archive_worker_type)],
    }
    for cluster, attr_names in cluster_attr_names.items():
        raw_events = []

        for attr_name in attr_names:
            raw_events.append({"host": cluster, "service": "{}.{}.{}.archive_worker_ok.bannerland_yt.irt".format(task_type, attr_name, cypress_config_mode)})

        checks.append(get_classic_aggregate(
            aggr_host=juggler_host,
            aggr_service="{}_{}_{}_archive_workers_ok".format(cluster, task_type, cypress_config_mode),
            notification_rules=module_notifications,
            simple_children=raw_events,
            description="Success of {} archive workers".format(task_type),
        ))

    return checks
