# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const

import irt.bannerland.constants as bl_constants
from irt.monitoring.juggler.configs.lib import get_classic_aggregate, telegram_notification_rules, PROD_TELEGRAM_CHANNEL


def get_checks():
    """
    :return: Возвращает список агрегатов для blrt
    """
    return [
        get_classic_aggregate(
            aggr_host='blrt',
            aggr_service='{}_generation'.format(task_type),
            notification_rules=telegram_notification_rules(PROD_TELEGRAM_CHANNEL),
            simple_children=[
                {'host': 'sandbox.{}'.format(release_type), 'service': 'make_banners.blrt.{}'.format(task_type)}
                for release_type in (rm_const.ReleaseStatus.stable, rm_const.ReleaseStatus.prestable)
            ],
            description="[{}] Генерация make_pocket в BLRT".format(task_type),
            only_value=True,
        )
        for task_type in (bl_constants.TaskType.PERF, bl_constants.TaskType.DYN)
    ]
