# -*- coding: utf-8 -*-

from irt.bannerland.hosts import get_hosts_by_roles
from irt.monitoring.juggler.configs.lib import PROD_TELEGRAM_CHANNEL, telegram_notification_rules, get_finish_scripts_aggregate, get_iron_hosts_aggregates


def get_checks():
    """
    :return: Возвращает список агрегатов для оставшегося железа, не вошедшего в предыдущие конфиги агрегатов
    """
    checks = []
    juggler_host = "bm_other"
    module_notifications = telegram_notification_rules(PROD_TELEGRAM_CHANNEL)

    # Состояния хостов
    checks += get_iron_hosts_aggregates(
        hosts=get_hosts_by_roles([
            "bmbender-front",
            "bmcache",
        ]),
        aggr_host=juggler_host,
        notification_rules=module_notifications,
        check_ansible=False,
    )

    # Проверяем успешное выполнение необходимых скриптов
    checks.append(get_finish_scripts_aggregate(
        hosts=get_hosts_by_roles([
            "bmbender-front",
            "bmcache",
        ]),
        scripts=["get-resources"],
        aggr_host=juggler_host,
        aggr_service="common_scripts",
        notification_rules=module_notifications,
    ))

    return checks
