# -*- coding: utf-8 -*-

from irt.bannerland.hosts import get_hosts_by_role
from irt.monitoring.juggler.configs.lib import juggler_option,\
    PROD_TELEGRAM_CHANNEL, \
    telegram_notification_rules, \
    get_balancer_aggregate, \
    get_finish_scripts_aggregate, \
    get_iron_hosts_aggregates, \
    get_classic_aggregate


def get_checks():
    """
    :return: Возвращает список агрегатов для bmfront-а
    """
    checks = []
    juggler_host = "bmfront"
    module_notifications = telegram_notification_rules(PROD_TELEGRAM_CHANNEL)
    bmfront_hosts = get_hosts_by_role("bmfront")

    # Хосты роли "bmfront"
    checks += get_iron_hosts_aggregates(
        hosts=bmfront_hosts,
        aggr_host=juggler_host,
        notification_rules=module_notifications,
    )

    # Проверяем успешное выполнение необходимых скриптов
    checks.append(get_finish_scripts_aggregate(
        hosts=bmfront_hosts,
        scripts=["get-resources", "update_service_tickets"],
        aggr_host=juggler_host,
        aggr_service="common_scripts",
        notification_rules=module_notifications,
    ))
    checks.append(get_finish_scripts_aggregate(
        hosts=get_hosts_by_role("bmfront:master"),
        scripts=["collect-logs", "sync_solomon_alerts", "update_juggler_checks"],
        aggr_host=juggler_host,
        aggr_service="master_scripts",
        notification_rules=module_notifications,
    ))

    # Коннект к Мускулю
    checks.append(get_classic_aggregate(
        aggr_host=juggler_host,
        aggr_service="mysql_connection",
        notification_rules=module_notifications,
        simple_children=[{"host": get_hosts_by_role("bmfront:master")[0], "service": "connect_monitoring_dbh.atoms.irt"}],
        description="Bmfront connection to monitoring_dbh",
    ))

    # Активная проверка балансера
    checks.append(get_balancer_aggregate("bmfront.bm.yandex-team.ru", module_notifications, juggler_option("bmfront_sms_logins")))

    return checks
