# -*- coding: utf-8 -*-

import irt.bannerland.constants as bl_constants
from irt.monitoring.juggler.configs.lib import get_classic_aggregate, telegram_notification_rules, PROD_TELEGRAM_CHANNEL


def get_checks():
    """
    :return: Aggregates list for Caesar
    """
    return [get_classic_aggregate(
        aggr_host='bannerland',
        aggr_service='caesar',
        notification_rules=telegram_notification_rules(PROD_TELEGRAM_CHANNEL),
        simple_children=[
            {'host': 'bsyeti.yandex.ru', 'service': 'bannerland/{}_banners_stable-skiperrors'.format(task_type)}
            for task_type in (bl_constants.TaskType.PERF, bl_constants.TaskType.DYN)
        ],
        description="Processing errors for BL banners in Caesar",
        only_value=True,
    )]
