# -*- coding: utf-8 -*-

from irt.bannerland.hosts import get_hosts_by_role, get_hosts_by_roles
from irt.monitoring.juggler.configs.lib import juggler_option, \
    PROD_TELEGRAM_CHANNEL, \
    get_balancer_aggregate, \
    get_classic_aggregate, \
    telegram_notification_rules, \
    get_finish_scripts_aggregate, \
    get_iron_hosts_aggregates


def get_checks():
    """
    :return: Возвращает список агрегатов для Каталогии (Catmedia, catalogia-media-* и т. д.)
    """
    checks = []
    juggler_host = "catalogia"
    module_notifications = telegram_notification_rules(PROD_TELEGRAM_CHANNEL)

    # Состояние железных хостов
    checks += get_iron_hosts_aggregates(
        hosts=get_hosts_by_roles([
            "catalogia-media-front",
            "catalogia-media-gen",
            "catalogia-media-gen-test",
            "catalogia-media-scripts",
            "catalogia-media-tasks",
        ]),
        aggr_host="catalogia_no_infuse",
        notification_rules=module_notifications,
        check_ansible=False,
    )
    checks += get_iron_hosts_aggregates(
        hosts=get_hosts_by_role("catmedia"),
        aggr_host="catalogia_infuse",
        notification_rules=module_notifications,
        custom_flaps={
            "svn_diff_count": {
                "stable": 4 * 3600,
                "critical": 8 * 3600,
            },
        },
        check_ansible=False,
    )

    # Проверяем успешное выполнение необходимых скриптов
    for hosts, scripts, at_least_one in [
        (get_hosts_by_role("catalogia-media-scripts"), ["get_log_percantage_slices"], True),
        (get_hosts_by_roles(["catalogia-media-front", "catmedia-dev"]), ["update_service_tickets"], False),
        (get_hosts_by_role("catmedia"), ["find_banners_benchmark_categs_diff"], False),
        (get_hosts_by_roles([
            "catalogia-media-front",
            "catalogia-media-gen",
            "catalogia-media-scripts",
            "catalogia-media-tasks",
            "catmedia",
        ]), ["get-resources"], False),
    ]:
        for script in scripts:
            checks.append(get_finish_scripts_aggregate(
                hosts=hosts,
                scripts=[script],
                aggr_host=juggler_host,
                aggr_service=script,
                notification_rules=module_notifications,
                at_least_one=at_least_one,
            ))

    # Коннект к Мускулю
    raw_events = []
    for host in get_hosts_by_roles(["catalogia-media-front", "catalogia-media-scripts", "catalogia-media-tasks", "catmedia", "catmedia-dev"]):
        raw_events.append(dict(host=host, service="connect_catalogia_media_dbh.atoms.irt"))
    checks.append(get_classic_aggregate(
        aggr_host=juggler_host,
        aggr_service="mysql_connection",
        notification_rules=module_notifications,
        simple_children=raw_events,
        description="Catmedia-hosts connection to MySQL",
    ))

    # Работает ли dyntable proxy
    raw_events = []
    for host in get_hosts_by_roles(["catalogia-media-front", "catmedia-dev"]):
        raw_events.append(dict(host=host, service="dyntable_proxy_access_is_ok.atoms.irt"))
    checks.append(get_classic_aggregate(
        aggr_host=juggler_host,
        aggr_service="dyntable_proxy",
        notification_rules=module_notifications,
        simple_children=raw_events,
        description="Catmedia-hosts connection to dyntable proxy",
        flaps_config={"stable": 200, "critical": 1000},
    ))

    # Проверяем файл подфраз категорий
    raw_events = []
    for host in get_hosts_by_roles(["catalogia-media-front", "catalogia-media-tasks", "catmedia"]):
        raw_events.append(dict(host=host, service="subphraser_init_file.atoms.irt"))
    checks.append(get_classic_aggregate(
        aggr_host=juggler_host,
        aggr_service="subphraser_init_file",
        notification_rules=module_notifications,
        simple_children=raw_events,
        description="Subphraser Init File",
    ))

    # Kyoto Cache
    raw_events = []
    for cache_name in ["broad_kyoto", "ktclient"]:
        for host in get_hosts_by_role("catmedia"):
            raw_events.append(dict(host=host, service="kyoto_cache_{}.atoms.irt".format(cache_name)))
    checks.append(get_classic_aggregate(
        aggr_host=juggler_host,
        aggr_service="kyoto_cache",
        notification_rules=module_notifications,
        simple_children=raw_events,
        flaps_config={"stable": 300, "critical": 600},
        description="Kyoto Cache",
    ))

    # Активная проверка балансера
    checks.append(get_balancer_aggregate("catmedia.yandex.ru", module_notifications, juggler_option("catmedia_sms_logins")))

    return checks
