# -*- coding: utf-8 -*-

from irt.bannerland.hosts import get_hosts_by_roles
from irt.monitoring.common_configs.iron_resources import get_srcs, short_src_path
from irt.monitoring.juggler.configs.lib import PROD_TELEGRAM_CHANNEL, \
    get_classic_aggregate, \
    telegram_notification_rules, \
    get_iron_hosts_aggregates


def get_checks():
    """
    :return: Возвращает список агрегатов для железных ресурсов bmcdict-а
    """
    checks = []
    juggler_host = "bmcdict"
    module_notifications = telegram_notification_rules(PROD_TELEGRAM_CHANNEL)

    # Состояние железных хостов
    checks += get_iron_hosts_aggregates(
        hosts=get_hosts_by_roles(["bmcdict-front", "bmcdict-front02", "bmcdict-gen"]),
        aggr_host=juggler_host,
        notification_rules=module_notifications,
        check_ansible=False,
    )

    # Проверяем наличие необходимых ресурсов на машинках
    raw_events = []
    iron_srcs = get_srcs()
    for path, hosts in iron_srcs.items():
        short_path = short_src_path(path)
        for host in hosts:
            raw_events.append(dict(host=host, service="iron_srcs_file_size.{}.atoms.irt".format(short_path)))
    checks.append(get_classic_aggregate(
        aggr_host=juggler_host,
        aggr_service="iron_srcs",
        notification_rules=module_notifications,
        simple_children=raw_events,
        description="Iron resources",
    ))

    return checks
