# -*- coding: utf-8 -*-

from irt.monitoring.common_configs import yt_tables
from irt.monitoring.juggler.configs.lib import juggler_option, PROD_TELEGRAM_CHANNEL, telegram_notification_rules
from juggler_sdk import Child

# Правила нотификаций всех агрегатов в рамках этого модуля
MODULE_NOTIFICATIONS = telegram_notification_rules(PROD_TELEGRAM_CHANNEL)


def get_checks():
    """
    :return: Возвращает список агрегатов для YT-таблиц
    """
    checks = dict()

    for table_spec in yt_tables.yt_tables_spec:
        juggler_aggr_service = table_spec["juggler_aggr_service"]

        if juggler_aggr_service not in checks:
            checks[juggler_aggr_service] = dict(
                juggler_option("check_template"),
                host="monitor_yt_tables",
                service=juggler_aggr_service,
                children=[],
                notifications=MODULE_NOTIFICATIONS,
                description="Мониторинг YT-таблиц ('{}')".format(juggler_aggr_service),
            )

        for property in ["row_count", "hours_old"]:
            for ontime_prefix in juggler_option("with_nor_ontime"):
                checks[juggler_aggr_service]["children"].append(Child(
                    host=table_spec["solomon_cluster"],
                    service="{}{}.{}.irt".format(ontime_prefix, property, table_spec["solomon_alert_id"])
                ))

    return checks.values()
