# -*- coding: utf-8 -*-

import juggler_sdk

import irt.monitoring.common_configs.yt_disk_sources as yt_disk_sources
from irt.monitoring.juggler.configs.lib import juggler_option, telegram_notification_rules, PROD_TELEGRAM_CHANNEL


def get_checks():
    """
    :return: Возвращает список агрегатов для мониторинга наших ресурсов на YT
    """
    yt_disk_config = yt_disk_sources.get_config()

    return [
        dict(
            juggler_option("check_template"),
            host="yt_{}_sources".format(cluster),
            service="account_{}".format(account),
            notifications=telegram_notification_rules(PROD_TELEGRAM_CHANNEL),
            flaps_config=juggler_sdk.FlapOptions(stable=1200, critical=3600),
            description="Usage disk quota (nodes/chunks/HDD/SSD) in account '{account}' on cluster '{cluster}'".format(cluster=cluster, account=account),
            children=[
                juggler_sdk.Child(
                    host="yt_{}".format(cluster),
                    service="free_{}_perc.{}.yt.irt".format(yt_disk_sources.get_display_source_name(source_name), account)
                )
                for source_name in yt_disk_config[cluster][account] | yt_disk_sources.get_default_sources()
            ],
        )
        for cluster in yt_disk_config
        for account in yt_disk_config[cluster]
    ]
