# -*- coding: utf-8 -*-

import logging

import irt.monitoring.common_configs.yt_tables
import irt.monitoring.solomon.alerts.alert_client


logger = logging.getLogger(__name__)


def get_alerts():
    """
    :return: массив алертов для мониторинга YT-таблиц
    """
    alerts = []

    for table_specs in irt.monitoring.common_configs.yt_tables.yt_tables_spec:
        if type(table_specs) is not dict:
            logger.error("[get_alert_for_yt_table]: Bad input!")
            return

        for req_key in ["solomon_alert_id", "solomon_cluster", "solomon_service", "yt_path", "max_hours_old"]:
            if req_key not in table_specs:
                logger.error("[get_alert_for_yt_table]: No required key '%s' in the table specs.", req_key)
                return

        for property in ["row_count", "hours_old"]:
            if property == "hours_old":
                crit_thr = "{}+".format(table_specs["max_hours_old"])
            else:
                crit_thr = []
                if "min_rows" in table_specs:
                    crit_thr.append("{}-".format(table_specs["min_rows"]))
                if "max_rows" in table_specs:
                    crit_thr.append("{}+".format(table_specs["max_rows"]))

            alerts += irt.monitoring.solomon.alerts.alert_client.get_universal_alerts(
                id="{}_{}".format(table_specs["solomon_alert_id"], property),
                name="[YT-monitoring] {} for '{}'".format(property, table_specs["yt_path"]),
                solomon_ts=irt.monitoring.solomon.alerts.alert_client.solomon_ts(
                    cluster=table_specs["solomon_cluster"],
                    service=table_specs["solomon_service"],
                    sensor=property,
                    table_name=table_specs["yt_path"],
                ),
                type="threshold",
                crit_thr=crit_thr,
                ontime_interval=900,
                juggler_annotations=irt.monitoring.solomon.alerts.alert_client.juggler_annotations(
                    host="yt_{}".format(table_specs["yt_cluster"]),
                    service="{}.{}.irt".format(property, table_specs["solomon_alert_id"]),
                    tags=["monitor_yt_tables", "yt"],
                    dashboard="monitor_yt_tables",
                ),
            )

    return alerts
