# -*- coding: utf-8 -*-

import irt.monitoring.common_configs.yt_disk_sources as yt_disk_sources
import irt.monitoring.solomon.alerts.alert_client as alert


def get_alerts():
    """
    :return: массив алертов по свободным ресурсам в YT
    """
    def _get_yt_source_alert(source_name, cluster, account, warn_thr=0.9, crit_thr=0.95):
        alert_expr = """
            let ratio = 1.0 * last({used_ts}) / last({limit_ts});
            alarm_if(ratio > {crit_thr});
            warn_if(ratio > {warn_thr});
        """.format(
            used_ts=alert.str_solomon_ts(yt_disk_sources.get_source_sensor(account, cluster, source_name)),
            limit_ts=alert.str_solomon_ts(yt_disk_sources.get_source_limit_sensor(account, cluster, source_name)),
            crit_thr=crit_thr,
            warn_thr=warn_thr
        )

        display_source_name = yt_disk_sources.get_display_source_name(source_name)
        return alert.get_value_alert(
            id="free_{}_{}_{}".format(display_source_name, account, cluster),
            name="[YT-{}] Free {} for account '{}'".format(cluster, display_source_name, account),
            type="expression",
            expression=alert_expr,
            check_expression="",
            ontime_interval=1800,
            juggler_annotations=alert.juggler_annotations(
                host="yt_{}".format(cluster),
                service="free_{}_perc.{}.yt.irt".format(display_source_name, account),
                tags=["bannerland", display_source_name, "yt_{}".format(cluster), "yt_sources", "yt"],
            ),
        )

    alerts = []
    yt_sources_config = yt_disk_sources.get_config()
    for cluster in yt_sources_config:
        for account in yt_sources_config[cluster]:
            for source_name in yt_sources_config[cluster][account] | yt_disk_sources.get_default_sources():
                alerts.append(_get_yt_source_alert(source_name, cluster, account))

    return alerts
