import os

import irt.utils as irt_utils

CONFIG_FILE = os.environ.get('MULTIK_MONITORING_CONFIG', '/etc/multik_monitoring.conf')
ROBOT_MULTIK_TESTER_PASSWORD_SECRET = 'sec-01ear75chb1dms3xwfvb71sy64'
ROBOT_MULTIK_TESTER_SECRET = os.getenv('MULTIK_TESTER_SECRET', 'sec-01ejxn67bwc48es05pxbzz9ef5')


def main():
    conf = {}

    secrets = {}
    secret = irt_utils.get_secrets(ROBOT_MULTIK_TESTER_SECRET)
    secrets['token'] = secret['MULTIK_TOKEN']
    secret = irt_utils.get_secrets(ROBOT_MULTIK_TESTER_PASSWORD_SECRET)
    secrets['password'] = secret['password']

    monitoring = {}
    monitoring['hostname'] = os.getenv('MULTIK_API_HOSTNAME')

    conf['secrets'] = secrets
    conf['monitoring'] = monitoring

    irt_utils.to_yml(CONFIG_FILE, conf)


if __name__ == '__main__':
    main()
