import datetime

from irt.multik.pylib.yt_orm import base, fields

TRUNK_NS = 1
STAGE_NS = 2
USER_NS = 4

NAMESPACE_DESCRIPTION = {
    TRUNK_NS: 'TRUNK',
    STAGE_NS: 'STAGE',
    USER_NS: 'USER',
}

ACTION_ADD = 'ADD'
ACTION_UPDATE = 'UPDATE'
ACTION_DELETE = 'DELETE'


class Label(base.Table):
    _table_name = 'labels'

    label_id = fields.IntegerField(key=True)
    namespace = fields.IntegerField(namespace=True, default=TRUNK_NS)  # TODO add choices & validation
    username = fields.CharField(namespace=True)

    tree_id = fields.IntegerField()
    name = fields.CharField()
    action = fields.CharField()  # TODO add choices
    parent_id = fields.IntegerField()
    dirty = fields.BooleanField(default=False)
    timestamp = fields.DateTimeField(default=datetime.datetime.now)


class LabelTree(base.Table):
    _table_name = 'label_trees'
    tree_id = fields.IntegerField(key=True)
    name = fields.CharField()


class Index(base.Table):

    bannerhash = fields.CharField(key=True)
    namespace = fields.IntegerField(namespace=True, default=TRUNK_NS)  # TODO add choices & validation
    username = fields.CharField(namespace=True)

    label_ids = fields.ListField(child_field=fields.IntegerField())
    action = fields.CharField()  # TODO add choices
    dirty = fields.BooleanField(default=False)
    timestamp = fields.DateTimeField(default=datetime.datetime.now)


class BannerData(base.Table):
    bannerhash = fields.CharField(key=True)
    title = fields.CharField()
    body = fields.CharField()
    href = fields.CharField()


class Banner(base.Table):
    _table_name = 'banners'
    _ignore_rogue_fields = ['label_ids']

    banner_uid = fields.CharField(key=True)
    bid = fields.UIntegerField()
    cid = fields.UIntegerField()
    pid = fields.UIntegerField()
    bannerhash = fields.CharField()
    domain = fields.CharField()

    order_id = fields.IntegerField()
    banner_id = fields.IntegerField()


class BannerLabels(base.Table):
    banner_uid = fields.CharField(key=True)
    label_ids = fields.ListField(child_field=fields.IntegerField())


class BannerCID(base.SecondaryIndexTable):
    _destination_table = Banner
    cid = fields.UIntegerField(key=True)


class BannerPID(base.SecondaryIndexTable):
    _destination_table = Banner
    pid = fields.UIntegerField(key=True)


class BannerBID(base.SecondaryIndexTable):
    _destination_table = Banner
    bid = fields.UIntegerField(key=True)


class BannerBannerID(base.SecondaryIndexTable):
    _destination_table = Banner
    BannerID = fields.UIntegerField(key=True)


class BannerBannerhash(base.SecondaryIndexTable):
    _destination_table = Banner
    bannerhash = fields.CharField(key=True)
