# Generated by Django 2.2.7 on 2019-12-17 14:12

from django.conf import settings
from django.db import migrations

from pq.tasks import PQ
from psycopg2 import connect


def _get_connection():
    return connect(
        dbname=settings.DATABASES['default']['NAME'],
        user=settings.DATABASES['default']['USER'],
        host=settings.DATABASES['default']['HOST'],
        port=settings.DATABASES['default']['PORT'],
        password=settings.DATABASES['default']['PASSWORD'],
        target_session_attrs='read-write',
    )


def create_pq_table(apps, schema_editor):
    connection = _get_connection()
    pq = PQ(connection)
    pq.create()


def drop_pq_table(apps, schema_editor):
    connection = _get_connection()
    connection.set_isolation_level(0)
    with connection:
        with connection.cursor() as cursor:
            cursor.execute('DROP TABLE queue;')


class Migration(migrations.Migration):
    initial = True

    dependencies = [migrations.swappable_dependency(settings.AUTH_USER_MODEL)]

    operations = [migrations.RunPython(create_pq_table, drop_pq_table)]
