# Generated by Django 2.2.7 on 2019-12-17 14:12

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
from django.contrib.postgres.fields import JSONField


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('operations_queue', '0001_initial')
    ]

    operations = [
        migrations.CreateModel(
            name='Queue',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('enqueued_at', models.DateTimeField()),
                ('dequeued_at', models.DateTimeField(blank=True, null=True)),
                ('expected_at', models.DateTimeField(blank=True, null=True)),
                ('schedule_at', models.DateTimeField(blank=True, null=True)),
                ('q_name', models.TextField()),
                ('data', models.TextField()),
            ],
            options={
                'db_table': 'queue',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Operation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('operation_status',
                 models.CharField(choices=[
                     ('created', 'Created'),
                     ('scheduled', 'Scheduled'),
                     ('started', 'Started'),
                     ('in_progress', 'In Progress'),
                     ('finished', 'Finished'),
                     ('canceled', 'Canceled'),
                     ('error', 'Error'),
                     ('rescheduled', 'Rescheduled')],
                     default='created', max_length=256)),
                ('operation_type',
                 models.CharField(choices=[
                    ('infuse', 'Infuse'),
                    ('other', 'Other')],
                    default='other', max_length=256)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_at', models.DateTimeField(auto_now=True, db_index=True)),
                ('started_at', models.DateTimeField(blank=True, null=True)),
                ('master_fqdn', models.TextField()),
                ('master_host', models.TextField()),
                ('worker', models.TextField(null=True)),
                ('worker_fqdn', models.TextField(null=True)),
                ('worker_host', models.TextField(null=True)),
                ('result', JSONField(null=True)),
                ('errors', JSONField(null=True)),
                ('queue', models.OneToOneField(null=True, on_delete=django.db.models.deletion.PROTECT, to='operations_queue.Queue')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
