import functools
import logging
import os

import yenv
from sandbox.projects.release_machine.core import const as rm_const

from irt.utils import suppress, get_secrets


def _get_db_name(override=None):
    """Get db name, corresponding to current yenv.type

    If override is defined and is present as environment variable, then
    it takes prescendance.
    """

    if override is not None and override in os.environ:
        return os.getenv(override)

    yt_env_map = {
        'production': rm_const.ReleaseStatus.stable,
        'prestable': rm_const.ReleaseStatus.prestable,
        'testing': rm_const.ReleaseStatus.testing,
        'development': rm_const.ReleaseStatus.unstable,
    }
    db_name = yt_env_map.get(yenv.type)
    if db_name is None:
        raise ValueError('Not supported YENV_TYPE: {}'.format(yenv.type))
    return db_name


get_yt_name = functools.partial(_get_db_name, override='YT_DB_NAME_OVERRIDE')
get_db_name = functools.partial(_get_db_name, override='DB_NAME_OVERRIDE')

STAGE_TYPE = _get_db_name(override='STAGE_NAME_OVERRIDE')
PROJECT_NAME = os.getenv('MULTIK_PROJECT_ID', os.getenv('DEPLOY_PROJECT_ID'))
GRAPH_FALLBACK_RESOURCE_ID = os.getenv('MULTIK_GRAPH_FALLBACK_RESOURCE_ID')

ENV_TYPE = yenv.type

YT_TOKEN = os.getenv('YT_TOKEN')
YT_PROXY = os.getenv('YT_PROXY')
DJANGO_SECRET_KEY = os.getenv('DJANGO_SECRET_KEY', 'not_so_secret')
SANDBOX_TOKEN = os.getenv('SANDBOX_TOKEN')
YP_TOKEN = os.getenv('YP_TOKEN')
POSTGRESQL_DB_PASSWORD = os.getenv('POSTGRESQL_DB_PASSWORD')

# TODO (k-zaitsev): Before MULTIK-379 this value was hardcoded
# Remove default after code has been merged and all deploy stages provide this value
MULTIK_SECRET = os.getenv('MULTIK_SECRET', 'sec-01eryaev2227jhybpch4eyxqxh')
get_secrets(MULTIK_SECRET, __name__)

TVM_CLIENT_ID = os.environ.get('MULTIK_TVM2_CLIENT_ID') or os.environ.get('MULTIK_TVM_CLIENT_ID')
TVM_SECRET_ID = os.environ.get('MULTIK_TVM2_SECRET_ID') or os.environ.get('MULTIK_TVM_SECRET_ID')

if TVM_SECRET_ID is None:
    # TODO: Remove after all stages provide this value
    TVM_SECRET_ID = {
        '2016155': 'sec-01dp47g0s9f5wa9y1rasewss1j',
        '2020395': 'sec-01e8y925cqc34tdmcgwybtfs26'
    }.get(TVM_CLIENT_ID)

TVM_SECRET = get_secrets(TVM_SECRET_ID).get('client_secret') if TVM_SECRET_ID is not None else ''


with suppress(ImportError):
    # Not making peerdir to yt from settings
    # But we have same init of yt_orm.registry
    import yt.wrapper as yt_wrapper

    YT_TABLE_PREFIX = os.getenv('YT_FULL_TABLE_PREFIX') or yt_wrapper.ypath_join(
        os.getenv('YT_TABLE_PREFIX', '//home/multik'), get_yt_name()
    )

    from irt.multik.pylib.yt_orm.registry import registry

    registry.set_yt_client(
        yt_wrapper.YtClient(
            # TODO not use of YT_PROXY
            proxy=os.getenv('YT_PROXY'),
            token=YT_TOKEN,
            config={
                'backend': 'rpc',
                'dynamic_table_retries': {'enable': False}})
    )

MAX_USER_NAMESPACE_NEIGHBORS = os.getenv('MAX_USER_NAMESPACE_NEIGHBORS', 10)

TIME_ZONE = 'Europe/Moscow'
USE_TZ = True

LANGUAGE_CODE = 'ru-ru'
USE_I18N = True
USE_L10N = True

SECRET_KEY = DJANGO_SECRET_KEY

DEBUG = os.environ.get('MULTIK_DEBUG', yenv.type != 'production')
LOG_LEVEL = os.getenv('LOG_LEVEL', 'DEBUG' if DEBUG else 'INFO')
logging.basicConfig(level=LOG_LEVEL)
