import mock
import pytest


@pytest.fixture()
def fake_registry():
    from irt.multik.pylib.yt_orm.registry import registry
    with mock.patch.object(registry, 'get_yt_client', return_value=object()):
        yield
    # Reset table stores
    for table in registry.tables.values():
        if hasattr(table.objects, '_store'):
            del table.objects._store


@pytest.fixture()
def local_yt_registry(local_yt_client):
    from irt.multik.pylib.yt_orm.registry import registry
    with mock.patch.object(registry, 'get_yt_client', return_value=local_yt_client):
        yield
    # Reset table stores
    for table in registry.tables.values():
        if hasattr(table.objects, '_store'):
            del table.objects._store
