import logging

log = logging.getLogger('yt_orm.registry')


class TableRegistry(object):
    """Global store for all registered Table objects"""
    def __init__(self):
        self.tables = {}
        self.indexes = {}
        self._client = None

    def register_table(self, name, table):
        # TODO: Use a more complex structure here:
        # i.e.: each table should have a _cluster parameter or smth
        # then each cluster would have it's own client.
        self.tables[name] = table

    def register_secondary_index_table(self, table, destination_table, pk):
        if destination_table not in self.indexes:
            self.indexes[destination_table] = {}
        self.indexes[destination_table][pk] = table

    def get_secondary_indexes(self, table):
        return self.indexes.get(table, {}).values()

    def get_secondary_index(self, table, pk):
        return self.indexes.get(table, {}).get(pk)

    def create_all_tables(self, exists_ok=False):
        for table in self.tables:
            log.info("Creating %s", table)
            t_class = self.tables[table]
            t_class.objects.create_table(exists_ok=exists_ok)

    def drop_all_tables(self):
        for table in self.tables:
            log.info("Dropping %s", table)
            t_class = self.tables[table]
            t_class.objects.store.drop_store()

    # TODO: This methods should be more complex and should allow getting client
    # for different clusters simultaneously
    def get_yt_client(self):
        if self._client is None:
            raise RuntimeError("Please set client with .set_yt_client() before accessing it")
        return self._client

    def set_yt_client(self, client):
        self._client = client


registry = TableRegistry()
