#pragma once

#include <saas/protos/rtyserver.pb.h>

#include <util/generic/string.h>

namespace NSaas {
    void AddSimpleStream(const TString& name, const TString& value, NRTYServer::TMessage::TStreamData& streamInfo, bool encode = true);
    void AddSimpleFactor(const TString& name, const TString& value, NRTYServer::TMessage::TErfInfo& factorInfo);
    void AddSimpleIntFactor(const TString& name, const TString& value, NRTYServer::TMessage::TErfInfo& factorInfo);
    void AddSimpleFactorValue(const TString& value, NRTYServer::TMessage::TFactorValues& factorInfo);
    void AddSimpleIntFactorValue(const TString& value, NRTYServer::TMessage::TFactorValues& factorInfo);
    void ClearFactors(NRTYServer::TMessage::TErfInfo& factorInfo);
    ui64 FactorsSize(const NRTYServer::TMessage::TErfInfo& factorInfo);
    bool IsValidFactorInfo(const NRTYServer::TMessage::TErfInfo& factorInfo);
    TString ValueToString(const NRTYServer::TMessage::TFactorValues::TValue& value);
}
