#pragma once

#include <util/generic/vector.h>

namespace NSaas {
    // EGeoObjectKind: defines what geometric entity arises from the list of points (SAAS-5724)
    enum class EGeoObjectKind {
        // A union of isolated points
        PointSet = 0 /* "p" */,
        // A union of rectangles
        RectSet = 1 /* "r" */,
        // A "void" case: a union of non-geodetic points - e.g. mercator coords or a custom projection. Such object produces no hits in the inverted index
        SpecialPointSet = 2 /* "i" */
    };

}
