#pragma once

#include "geo.h"
#include "common.h"

#include <saas/protos/rtyserver.pb.h>
#include <library/cpp/json/json_value.h>

namespace NSaas {
    class TGeoBlock {
    public:
        // A set of isolated points
        class TPointSet {
        public:
            TPointSet(NRTYServer::TMessage::TGeoObject& object, EGeoObjectKind kind);
            TPointSet& AddPoint(float lon, float lat);

        private:
            NRTYServer::TMessage::TGeoObject& InternalProtobuf;
        };

        // A union of rectangular areas
        class TRectSet {
        public:
            TRectSet(NRTYServer::TMessage::TGeoObject& object);
            TRectSet& AddRect(float lowerLon, float lowerLat, float upperLon, float upperLat);

        private:
            NRTYServer::TMessage::TGeoObject& InternalProtobuf;
        };

    public:
        TGeoBlock(NRTYServer::TMessage::TGeoData& geoProto);

        TPointSet AddPointSet(const TString& layerName, bool geodetic);

        TRectSet AddRectSet(const TString& layerName);

        ui32 GetLayersCount() const {
            return InternalProtobuf.LayersSize();
        }

        const TString GetLayerName(ui32 layerIndex) const {
            return InternalProtobuf.GetLayers(layerIndex).GetLayer();
        }

        NJson::TJsonValue ToJson(ui32 layerIndex) const {
            return ToJson(InternalProtobuf.GetLayers(layerIndex));
        }

        static NJson::TJsonValue ToJson(const NRTYServer::TMessage::TGeoLayer& proto);

    private:
        NRTYServer::TMessage::TGeoData& InternalProtobuf;
    };
}
